/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.SendingEntityBody;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SendingHeaders
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingHeaders.class);
    private final HttpOutboundRespListener outboundResponseListener;
    boolean keepAlive;
    private final MessageStateContext messageStateContext;
    ChunkConfig chunkConfig;
    HttpResponseFuture outboundRespStatusFuture;

    public SendingHeaders(HttpOutboundRespListener outboundResponseListener, MessageStateContext messageStateContext) {
        this.outboundResponseListener = outboundResponseListener;
        this.messageStateContext = messageStateContext;
        this.chunkConfig = outboundResponseListener.getChunkConfig();
        this.keepAlive = outboundResponseListener.isKeepAlive();
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        LOG.warn("readInboundRequestHeaders {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        LOG.warn("readInboundRequestBody {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundResponseListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseBody {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        LOG.error("Remote client closed the connection while writing outbound response headers");
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        LOG.error("Idle timeout triggered while writing outbound response headers");
        return null;
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        ChunkConfig responseChunkConfig;
        ChunkConfig chunkConfig = responseChunkConfig = outboundResponseMsg.getProperty("chunking_config") != null ? (ChunkConfig)((Object)outboundResponseMsg.getProperty("chunking_config")) : null;
        if (responseChunkConfig != null) {
            this.setChunkConfig(responseChunkConfig);
        }
        this.outboundRespStatusFuture = this.outboundResponseListener.getInboundRequestMsg().getHttpOutboundRespStatusFuture();
        String httpVersion = this.outboundResponseListener.getRequestDataHolder().getHttpVersion();
        if (Util.isLastHttpContent(httpContent)) {
            if (this.chunkConfig == ChunkConfig.ALWAYS && StateUtil.checkChunkingCompatibility(httpVersion, this.chunkConfig)) {
                this.writeHeaders(outboundResponseMsg, this.keepAlive, this.outboundRespStatusFuture);
                this.writeResponse(outboundResponseMsg, httpContent, true);
                return;
            }
        } else if ((this.chunkConfig == ChunkConfig.ALWAYS || this.chunkConfig == ChunkConfig.AUTO) && StateUtil.checkChunkingCompatibility(httpVersion, this.chunkConfig)) {
            this.writeHeaders(outboundResponseMsg, this.keepAlive, this.outboundRespStatusFuture);
            this.writeResponse(outboundResponseMsg, httpContent, true);
            return;
        }
        this.writeResponse(outboundResponseMsg, httpContent, false);
    }

    private void writeResponse(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, boolean headersWritten) {
        this.messageStateContext.setListenerState(new SendingEntityBody(this.messageStateContext, this.outboundRespStatusFuture, headersWritten));
        this.messageStateContext.getListenerState().writeOutboundResponseBody(this.outboundResponseListener, outboundResponseMsg, httpContent);
    }

    private void writeHeaders(HttpCarbonMessage outboundResponseMsg, boolean keepAlive, HttpResponseFuture outboundRespStatusFuture) {
        Util.setupChunkedRequest(outboundResponseMsg);
        ChannelFuture outboundHeaderFuture = this.writeResponseHeaders(outboundResponseMsg, keepAlive);
        StateUtil.notifyIfHeaderWriteFailure(outboundRespStatusFuture, outboundHeaderFuture, "Remote client closed the connection before initiating outbound response");
    }

    void setChunkConfig(ChunkConfig chunkConfig) {
        this.chunkConfig = chunkConfig;
    }

    ChannelFuture writeResponseHeaders(HttpCarbonMessage outboundResponseMsg, boolean keepAlive) {
        HttpResponse response = Util.createHttpResponse(outboundResponseMsg, this.outboundResponseListener.getRequestDataHolder().getHttpVersion(), this.outboundResponseListener.getServerName(), keepAlive);
        return this.outboundResponseListener.getSourceContext().write(response);
    }
}

