/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contract.config;

import java.util.Map;
import org.wso2.transport.http.netty.contractimpl.common.Util;

public class ServerBootstrapConfiguration {
    private boolean tcpNoDelay;
    private boolean keepAlive;
    private boolean socketReuse;
    private int connectTimeOut;
    private int receiveBufferSize;
    private int sendBufferSize;
    private int soBackLog;
    private int socketTimeOut;

    public ServerBootstrapConfiguration(Map<String, Object> properties) {
        this.connectTimeOut = Util.getIntProperty(properties, "server.bootstrap.connect.timeout", 15000);
        this.keepAlive = Util.getBooleanProperty(properties, "server.bootstrap.keepalive", true);
        this.receiveBufferSize = Util.getIntProperty(properties, "server.bootstrap.recievebuffersize", 0x100000);
        this.sendBufferSize = Util.getIntProperty(properties, "server.bootstrap.sendbuffersize", 0x100000);
        this.tcpNoDelay = Util.getBooleanProperty(properties, "server.bootstrap.nodelay", true);
        this.socketReuse = Util.getBooleanProperty(properties, "server.bootstrap.socket.reuse", false);
        this.soBackLog = Util.getIntProperty(properties, "server.bootstrap.socket.backlog", 100);
        this.socketTimeOut = Util.getIntProperty(properties, "server.bootstrap.socket.timeout", 15);
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isSocketReuse() {
        return this.socketReuse;
    }

    public int getSoBackLog() {
        return this.soBackLog;
    }

    public int getSoTimeOut() {
        return this.socketTimeOut;
    }
}

