/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.states.MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.ReceivingHeaders;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ResponseCompleted
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseCompleted.class);
    private final SourceHandler sourceHandler;
    private final MessageStateContext messageStateContext;

    ResponseCompleted(SourceHandler sourceHandler, MessageStateContext messageStateContext, HttpCarbonMessage inboundRequestMsg) {
        this.sourceHandler = sourceHandler;
        this.messageStateContext = messageStateContext;
        this.cleanupSourceHandler(inboundRequestMsg);
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        this.messageStateContext.setListenerState(new ReceivingHeaders(this.sourceHandler, this.messageStateContext));
        this.messageStateContext.getListenerState().readInboundRequestHeaders(inboundRequestMsg, inboundRequestHeaders);
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        LOG.warn("readInboundRequestBody {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseBody {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        LOG.warn("handleAbruptChannelClosure {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        LOG.warn("handleIdleTimeoutConnectionClosure {}", (Object)"is not a dependant action of this state");
        return null;
    }

    private void cleanupSourceHandler(HttpCarbonMessage inboundRequestMsg) {
        inboundRequestMsg.waitAndReleaseAllEntities();
        this.sourceHandler.removeRequestEntry(inboundRequestMsg);
    }
}

