/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.securevault.tool;

import java.net.URLClassLoader;
import java.util.logging.Logger;
import org.wso2.carbon.kernel.internal.securevault.SecureVaultConfigurationProvider;
import org.wso2.carbon.kernel.securevault.MasterKeyReader;
import org.wso2.carbon.kernel.securevault.SecretRepository;
import org.wso2.carbon.kernel.securevault.SecureVaultUtils;
import org.wso2.carbon.kernel.securevault.config.model.SecureVaultConfiguration;
import org.wso2.carbon.kernel.securevault.exception.SecureVaultException;

public class CipherTool {
    private static final Logger logger = Logger.getLogger(CipherTool.class.getName());
    private SecureVaultConfiguration secureVaultConfiguration;
    private SecretRepository secretRepository;

    public void init(URLClassLoader urlClassLoader) throws SecureVaultException {
        MasterKeyReader masterKeyReader;
        this.secureVaultConfiguration = SecureVaultConfigurationProvider.getConfiguration();
        String secretRepositoryType = this.secureVaultConfiguration.getSecretRepositoryConfig().getType().orElseThrow(() -> new SecureVaultException("Secret repository type is mandatory"));
        String masterKeyReaderType = this.secureVaultConfiguration.getMasterKeyReaderConfig().getType().orElseThrow(() -> new SecureVaultException("Master key reader type is mandatory"));
        try {
            masterKeyReader = (MasterKeyReader)urlClassLoader.loadClass(masterKeyReaderType).newInstance();
            this.secretRepository = (SecretRepository)urlClassLoader.loadClass(secretRepositoryType).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SecureVaultException("Failed to instantiate implementation classes.", e);
        }
        masterKeyReader.init(this.secureVaultConfiguration.getMasterKeyReaderConfig());
        this.secretRepository.init(this.secureVaultConfiguration.getSecretRepositoryConfig(), masterKeyReader);
    }

    public void encryptSecrets() throws SecureVaultException {
        this.secretRepository.persistSecrets(this.secureVaultConfiguration.getSecretRepositoryConfig());
    }

    public String encryptText(String plainText) throws SecureVaultException {
        byte[] encryptedPassword = this.secretRepository.encrypt(SecureVaultUtils.toBytes(plainText.trim()));
        String base64Encoded = new String(SecureVaultUtils.toChars(SecureVaultUtils.base64Encode(encryptedPassword)));
        logger.info(base64Encoded);
        return base64Encoded;
    }

    public String decryptText(String cipherText) throws SecureVaultException {
        byte[] decryptedPassword = this.secretRepository.decrypt(SecureVaultUtils.base64Decode(SecureVaultUtils.toBytes(cipherText)));
        String plainText = new String(SecureVaultUtils.toChars(decryptedPassword));
        logger.info(plainText);
        return plainText;
    }
}

