/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.config.TransportsConfiguration;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class ConfigurationBuilder {
    private static final String NETTY_TRANSPORT_CONF = "transports.netty.conf";
    private static final Logger log = LoggerFactory.getLogger(ConfigurationBuilder.class);
    private static ConfigurationBuilder instance = new ConfigurationBuilder();
    private TransportsConfiguration transportsConfiguration;

    public static ConfigurationBuilder getInstance() {
        return instance;
    }

    private ConfigurationBuilder() {
    }

    public TransportsConfiguration getConfiguration() {
        String nettyTransportsConfigFile = System.getProperty(NETTY_TRANSPORT_CONF, "conf" + File.separator + "transports" + File.separator + "netty-transports.yml");
        this.transportsConfiguration = this.getConfiguration(nettyTransportsConfigFile);
        return this.transportsConfiguration;
    }

    public TransportsConfiguration getConfiguration(String configFileLocation) {
        TransportsConfiguration transportsConfiguration;
        block15: {
            File file = new File(configFileLocation);
            if (file.exists()) {
                try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.ISO_8859_1);){
                    Yaml yaml = new Yaml(new CustomClassLoaderConstructor(TransportsConfiguration.class, TransportsConfiguration.class.getClassLoader()));
                    yaml.setBeanAccess(BeanAccess.FIELD);
                    TransportsConfiguration transportsConfiguration2 = yaml.loadAs(in, TransportsConfiguration.class);
                    break block15;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while loading " + configFileLocation + " configuration file", e);
                }
            }
            log.warn("Netty transport configuration file not found in: " + configFileLocation + " ,hence using default configuration");
            transportsConfiguration = TransportsConfiguration.getDefault();
        }
        return transportsConfiguration;
    }
}

