/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Constants;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.sender.RedirectChannelInitializer;
import org.wso2.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.sender.channel.pool.ConnectionManager;

public class RedirectHandler
extends ChannelInboundHandlerAdapter {
    protected static final Logger LOG = LoggerFactory.getLogger(RedirectHandler.class);
    private Map<String, String> redirectState = null;
    private boolean isRedirect = false;
    private boolean isCrossDoamin = true;
    private HTTPCarbonMessage originalRequest;
    private SSLEngine sslEngine;
    private boolean httpTraceLogEnabled;
    private int maxRedirectCount;
    private Integer currentRedirectCount;
    private boolean chunkDisabled;
    private HTTPCarbonMessage targetRespMsg;
    private ChannelHandlerContext originalChannelContext;
    private boolean isIdleHandlerOfTargetChannelRemoved = false;

    public RedirectHandler(SSLEngine sslEngine, boolean httpTraceLogEnabled, int maxRedirectCount, boolean chunkDisabled) {
        this.sslEngine = sslEngine;
        this.httpTraceLogEnabled = httpTraceLogEnabled;
        this.maxRedirectCount = maxRedirectCount;
        this.chunkDisabled = chunkDisabled;
    }

    public RedirectHandler(SSLEngine sslEngine, boolean httpTraceLogEnabled, int maxRedirectCount, boolean chunkDisabled, ChannelHandlerContext originalChannelContext, boolean isIdleHandlerOfTargetChannelRemoved) {
        this.sslEngine = sslEngine;
        this.httpTraceLogEnabled = httpTraceLogEnabled;
        this.maxRedirectCount = maxRedirectCount;
        this.chunkDisabled = chunkDisabled;
        this.originalChannelContext = originalChannelContext;
        this.isIdleHandlerOfTargetChannelRemoved = isIdleHandlerOfTargetChannelRemoved;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.originalChannelContext == null) {
            this.originalChannelContext = ctx;
        }
        if (msg instanceof HttpResponse) {
            this.handleRedirectState(ctx, (HttpResponse)msg);
        } else if (msg instanceof LastHttpContent) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Last content received through channel : " + ctx.channel().id());
            }
            this.redirectRequest(ctx, msg);
        } else if (!this.isRedirect) {
            if (ctx == this.originalChannelContext) {
                this.originalChannelContext.fireChannelRead(msg);
            } else {
                HttpContent httpContent = (HttpContent)msg;
                this.targetRespMsg.addHttpContent(httpContent);
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Exception occurred in RedirectHandler.", cause);
        if (ctx != null && ctx.channel().isActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" And Channel ID is : " + ctx.channel().id());
            }
            HttpResponseFuture responseFuture = ctx.channel().attr(Constants.RESPONSE_FUTURE_OF_ORIGINAL_CHANNEL).get();
            responseFuture.notifyHttpListener(cause);
            ctx.close();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event;
        if (evt instanceof IdleStateEvent && ((event = (IdleStateEvent)evt).state() == IdleState.READER_IDLE || event.state() == IdleState.WRITER_IDLE)) {
            if (this.originalChannelContext == null) {
                this.originalChannelContext = ctx;
            }
            if (ctx == this.originalChannelContext) {
                this.originalChannelContext.fireUserEventTriggered(evt);
                this.isIdleHandlerOfTargetChannelRemoved = true;
            } else {
                this.sendTimeoutError(ctx);
            }
            if (ctx != this.originalChannelContext) {
                ctx.close();
            }
        }
    }

    private void sendTimeoutError(ChannelHandlerContext ctx) {
        HttpResponseFuture responseFuture;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timeout occurred in RedirectHandler. Channel ID : " + ctx.channel().id());
        }
        if ((responseFuture = ctx.channel().attr(Constants.RESPONSE_FUTURE_OF_ORIGINAL_CHANNEL).get()) != null) {
            responseFuture.notifyHttpListener(new Exception("Endpoint timed out"));
            responseFuture.removeHttpListener();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel " + ctx.channel().id() + " gets inactive so closing it from RedirectHandler.");
        }
        if (this.originalChannelContext == ctx) {
            ctx.fireChannelInactive();
        } else {
            ctx.close();
        }
    }

    private void handleRedirectState(ChannelHandlerContext ctx, HttpResponse msg) throws Exception {
        try {
            this.originalRequest = ctx.channel().attr(Constants.ORIGINAL_REQUEST).get();
            String location = this.getLocationFromResponseHeader(msg);
            int statusCode = msg.status().code();
            this.redirectState = location != null ? this.getRedirectState(location, statusCode, this.originalRequest) : null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Handling redirect state for channel : " + ctx.channel().id());
            }
            if (this.isRedirectEligible()) {
                this.isCrossDoamin = this.isCrossDomain(location, this.originalRequest);
                this.currentRedirectCount = this.updateAndGetRedirectCount(ctx);
                if (this.currentRedirectCount <= this.maxRedirectCount) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Redirection required.");
                    }
                    this.isRedirect = true;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Maximum redirect count reached.");
                    }
                    this.isRedirect = false;
                    this.sendResponseHeadersToClient(ctx, msg);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request is not eligible for redirection.");
                }
                this.isRedirect = false;
                if (ctx == this.originalChannelContext) {
                    this.originalChannelContext.fireChannelRead(msg);
                } else {
                    this.sendResponseHeadersToClient(ctx, msg);
                }
            }
        }
        catch (UnsupportedEncodingException exception) {
            LOG.error("UnsupportedEncodingException occurred when deciding whether a redirection is required", exception);
            this.exceptionCaught(ctx, exception.getCause());
        }
        catch (MalformedURLException exception) {
            LOG.error("MalformedURLException occurred when deciding whether a redirection is required", exception);
            this.exceptionCaught(ctx, exception.getCause());
        }
    }

    private void redirectRequest(ChannelHandlerContext ctx, Object msg) throws Exception {
        block10: {
            if (this.isRedirect) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Getting ready for actual redirection for channel " + ctx.channel().id());
                    }
                    URL locationUrl = new URL(this.redirectState.get("Location"));
                    HTTPCarbonMessage httpCarbonRequest = this.createHttpCarbonRequest();
                    Util.setupTransferEncodingForRequest(httpCarbonRequest, this.chunkDisabled);
                    HttpRequest httpRequest = Util.createHttpRequest(httpCarbonRequest);
                    if (this.isCrossDoamin) {
                        this.writeContentToNewChannel(ctx, locationUrl, httpCarbonRequest, httpRequest);
                        break block10;
                    }
                    this.writeContentToExistingChannel(ctx, httpCarbonRequest, httpRequest);
                }
                catch (MalformedURLException exception) {
                    LOG.error("Error occurred when parsing redirect url", exception);
                    this.exceptionCaught(ctx, exception.getCause());
                }
                catch (Exception exception) {
                    LOG.error("Error occurred during redirection", exception);
                    this.exceptionCaught(ctx, exception.getCause());
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("But is not a redirect.");
                }
                if (ctx == this.originalChannelContext) {
                    this.originalChannelContext.fireChannelRead(msg);
                    ctx.close();
                } else {
                    this.markEndOfMessage(ctx, (HttpContent)msg);
                }
            }
        }
    }

    private void writeContentToExistingChannel(ChannelHandlerContext ctx, HTTPCarbonMessage httpCarbonRequest, HttpRequest httpRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Use existing channel" + ctx.channel().id() + " to send the redirect request.");
        }
        ctx.channel().attr(Constants.ORIGINAL_REQUEST).set(httpCarbonRequest);
        ctx.write(httpRequest);
        ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
    }

    private void markEndOfMessage(ChannelHandlerContext ctx, HttpContent httpContent) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mark end of the message and reset channel attributes for channel : " + ctx.channel().id());
        }
        this.targetRespMsg.addHttpContent(httpContent);
        this.targetRespMsg.setEndOfMsgAdded(true);
        this.targetRespMsg = null;
        this.currentRedirectCount = 0;
        TargetChannel targetChannel = ctx.channel().attr(Constants.TARGET_CHANNEL_REFERENCE).get();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Return target channel : " + targetChannel.getChannel().id() + " back to its pool from " + "RedirectHandler. Currently in channel : " + ctx.channel().id());
            }
            Util.resetChannelAttributes(ctx);
            Util.resetChannelAttributes(this.originalChannelContext);
            if (!this.isIdleHandlerOfTargetChannelRemoved && targetChannel.getChannel().isActive()) {
                targetChannel.getChannel().pipeline().remove("idleStateHandler");
                this.isIdleHandlerOfTargetChannelRemoved = true;
            }
            ConnectionManager.getInstance().returnChannel(targetChannel);
            if (ctx != this.originalChannelContext) {
                ctx.close();
            }
        }
        catch (Exception exception) {
            LOG.error("Error occurred while returning target channel " + targetChannel.getChannel().id() + " from current" + " channel" + ctx.channel().id() + " " + "to its pool in " + "markEndOfMessage", exception);
            this.exceptionCaught(ctx, exception.getCause());
        }
    }

    private void sendResponseHeadersToClient(ChannelHandlerContext ctx, HttpResponse msg) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pass along received response headers to client. Channel id : " + ctx.channel().id());
        }
        HttpResponseFuture responseFuture = ctx.channel().attr(Constants.RESPONSE_FUTURE_OF_ORIGINAL_CHANNEL).get();
        responseFuture.notifyHttpListener(this.setUpCarbonResponseMessage(msg));
    }

    private boolean isRedirectEligible() {
        return this.redirectState != null && !this.redirectState.isEmpty() && this.redirectState.get("Location") != null && this.redirectState.get("HTTP_METHOD") != null;
    }

    private String getLocationFromResponseHeader(HttpResponse msg) throws UnsupportedEncodingException {
        return msg.headers().get(HttpHeaderNames.LOCATION) != null ? URLDecoder.decode(msg.headers().get(HttpHeaderNames.LOCATION), "UTF-8") : null;
    }

    private Integer updateAndGetRedirectCount(ChannelHandlerContext ctx) {
        Integer redirectCount;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Increment redirect count.");
        }
        if ((redirectCount = ctx.channel().attr(Constants.REDIRECT_COUNT).get()) != null && redirectCount != 0) {
            Integer n = redirectCount;
            Integer n2 = redirectCount = Integer.valueOf(redirectCount + 1);
        } else {
            redirectCount = 1;
        }
        this.currentRedirectCount = redirectCount;
        ctx.channel().attr(Constants.REDIRECT_COUNT).set(redirectCount);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Current redirect count." + this.currentRedirectCount + " and channel id is : " + ctx.channel().id());
        }
        return redirectCount;
    }

    private Map<String, String> getRedirectState(String location, int statusCode, HTTPCarbonMessage originalRequest) throws UnsupportedEncodingException {
        HashMap<String, String> redirectState = new HashMap<String, String>();
        String originalRequestMethod = originalRequest != null ? (String)originalRequest.getProperty("HTTP_METHOD") : null;
        switch (statusCode) {
            case 300: 
            case 305: 
            case 307: 
            case 308: {
                if (!"GET".equals(originalRequestMethod) && !"HEAD".equals(originalRequestMethod)) break;
                redirectState.put("HTTP_METHOD", originalRequestMethod);
                redirectState.put("Location", this.getLocationURI(location, originalRequest));
                break;
            }
            case 301: 
            case 302: {
                if (!"GET".equals(originalRequestMethod) && !"HEAD".equals(originalRequestMethod)) break;
                redirectState.put("HTTP_METHOD", "GET");
                redirectState.put("Location", this.getLocationURI(location, originalRequest));
                break;
            }
            case 303: {
                redirectState.put("HTTP_METHOD", "GET");
                redirectState.put("Location", this.getLocationURI(location, originalRequest));
                break;
            }
            default: {
                return null;
            }
        }
        return redirectState;
    }

    private String getLocationURI(String location, HTTPCarbonMessage originalRequest) throws UnsupportedEncodingException {
        if (location != null) {
            String host;
            if (!this.isRelativePath(location)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Location contain an absolute path : " + location);
                }
                return location;
            }
            String requestPath = originalRequest != null ? (String)originalRequest.getProperty("TO") : null;
            String protocol = originalRequest != null ? (String)originalRequest.getProperty("PROTOCOL") : "http";
            String string = host = originalRequest != null ? (String)originalRequest.getProperty("Host") : null;
            if (host == null) {
                return null;
            }
            int defaultPort = this.getDefaultPort(protocol);
            Integer port = originalRequest != null ? (originalRequest.getProperty("PORT") != null ? (Integer)originalRequest.getProperty("PORT") : defaultPort) : defaultPort;
            return this.buildRedirectURL(requestPath, location, protocol, host, port);
        }
        return null;
    }

    private String buildRedirectURL(String requestPath, String location, String protocol, String host, Integer port) throws UnsupportedEncodingException {
        String newPath;
        String string = newPath = requestPath == null ? "/" : URLDecoder.decode(requestPath, "UTF-8");
        newPath = location.startsWith("/") ? location : (newPath.endsWith("/") ? newPath + location : newPath + "/" + location);
        StringBuilder newLocation = new StringBuilder(protocol);
        newLocation.append("://").append(host);
        if (80 != port) {
            newLocation.append(":").append(port);
        }
        if (newPath.charAt(0) != "/".charAt(0)) {
            newLocation.append("/".charAt(0));
        }
        newLocation.append(newPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Redirect URL build from relative path is : " + newLocation.toString());
        }
        return newLocation.toString();
    }

    private boolean isCrossDomain(String location, HTTPCarbonMessage originalRequest) throws UnsupportedEncodingException, MalformedURLException {
        if (!this.isRelativePath(location)) {
            try {
                String port;
                String host;
                URL locationUrl = new URL(location);
                String protocol = originalRequest != null ? (String)originalRequest.getProperty("PROTOCOL") : null;
                String string = host = originalRequest != null ? (String)originalRequest.getProperty("Host") : null;
                String string2 = originalRequest != null ? (originalRequest.getProperty("PORT") != null ? Integer.toString((Integer)originalRequest.getProperty("PORT")) : null) : (port = null);
                if (locationUrl.getProtocol().equals(protocol) && locationUrl.getHost().equals(host) && locationUrl.getPort() == Integer.parseInt(port)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Is cross domain url : false");
                    }
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Is cross domain url : true");
                }
                return true;
            }
            catch (MalformedURLException exception) {
                LOG.error("MalformedURLException occurred while deciding whether the redirect url is cross domain", exception);
                throw exception;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Is cross domain url : false");
        }
        return false;
    }

    private HTTPCarbonMessage createHttpCarbonRequest() throws MalformedURLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create redirect request with http method  : " + this.redirectState.get("HTTP_METHOD"));
        }
        URL locationUrl = new URL(this.redirectState.get("Location"));
        HttpMethod httpMethod = new HttpMethod(this.redirectState.get("HTTP_METHOD"));
        HTTPCarbonMessage httpCarbonRequest = new HTTPCarbonMessage(new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, ""));
        httpCarbonRequest.setProperty("PORT", locationUrl.getPort() != -1 ? locationUrl.getPort() : this.getDefaultPort(locationUrl.getProtocol()));
        httpCarbonRequest.setProperty("PROTOCOL", locationUrl.getProtocol());
        httpCarbonRequest.setProperty("Host", locationUrl.getHost());
        httpCarbonRequest.setProperty("HTTP_METHOD", this.redirectState.get("HTTP_METHOD"));
        httpCarbonRequest.setProperty("REQUEST_URL", locationUrl.getPath());
        httpCarbonRequest.setProperty("TO", locationUrl.getPath());
        StringBuffer host = new StringBuffer(locationUrl.getHost());
        if (locationUrl.getPort() != -1 && locationUrl.getPort() != 80 && locationUrl.getPort() != 443) {
            host.append(":").append(locationUrl.getPort());
        }
        httpCarbonRequest.setHeader("Host", host.toString());
        httpCarbonRequest.setEndOfMsgAdded(true);
        return httpCarbonRequest;
    }

    private HTTPCarbonMessage setUpCarbonResponseMessage(Object msg) {
        this.targetRespMsg = new HTTPCarbonMessage((HttpMessage)msg);
        this.targetRespMsg.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        HttpResponse httpResponse = (HttpResponse)msg;
        this.targetRespMsg.setProperty("HTTP_STATUS_CODE", httpResponse.status().code());
        return this.targetRespMsg;
    }

    private void writeContentToNewChannel(ChannelHandlerContext channelHandlerContext, URL redirectUrl, HTTPCarbonMessage httpCarbonRequest, HttpRequest httpRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Send redirect request using a new channel");
        }
        if ("http".equals(redirectUrl.getProtocol())) {
            this.sslEngine = null;
        }
        this.bootstrapClient(channelHandlerContext, redirectUrl, httpCarbonRequest, httpRequest);
    }

    private void bootstrapClient(ChannelHandlerContext channelHandlerContext, URL redirectUrl, HTTPCarbonMessage httpCarbonRequest, HttpRequest httpRequest) {
        EventLoop group = channelHandlerContext.channel().eventLoop();
        Bootstrap clientBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)clientBootstrap.group(group)).channel(NioSocketChannel.class)).remoteAddress(new InetSocketAddress(redirectUrl.getHost(), redirectUrl.getPort() != -1 ? redirectUrl.getPort() : this.getDefaultPort(redirectUrl.getProtocol()))).handler(new RedirectChannelInitializer(this.sslEngine, this.httpTraceLogEnabled, this.maxRedirectCount, this.chunkDisabled, this.originalChannelContext, this.isIdleHandlerOfTargetChannelRemoved));
        ((Bootstrap)clientBootstrap.option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 15000);
        ChannelFuture channelFuture = clientBootstrap.connect();
        this.registerListener(channelHandlerContext, channelFuture, httpCarbonRequest, httpRequest);
    }

    private void registerListener(final ChannelHandlerContext channelHandlerContext, ChannelFuture channelFuture, final HTTPCarbonMessage httpCarbonRequest, final HttpRequest httpRequest) {
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess() && future.isDone()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Connected to the new channel " + future.channel().id() + " and getting ready to " + "write request.");
                    }
                    long channelStartTime = channelHandlerContext.channel().attr(Constants.ORIGINAL_CHANNEL_START_TIME).get();
                    int timeoutOfOriginalRequest = channelHandlerContext.channel().attr(Constants.ORIGINAL_CHANNEL_TIMEOUT).get();
                    RedirectHandler.this.setChannelAttributes(channelHandlerContext, future, httpCarbonRequest, channelStartTime, timeoutOfOriginalRequest);
                    long remainingTimeForRedirection = RedirectHandler.this.getRemainingTimeForRedirection(channelStartTime, timeoutOfOriginalRequest);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Remaining time for redirection is : " + remainingTimeForRedirection);
                    }
                    future.channel().pipeline().addBefore("redirectHandler", "idleStateHandler", new IdleStateHandler(remainingTimeForRedirection, remainingTimeForRedirection, 0L, TimeUnit.MILLISECONDS));
                    future.channel().write(httpRequest);
                    future.channel().writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
                    if (channelHandlerContext != RedirectHandler.this.originalChannelContext) {
                        channelHandlerContext.close();
                    }
                } else {
                    LOG.error("Error occurred while trying to connect to redirect channel.", future.cause());
                    RedirectHandler.this.exceptionCaught(channelHandlerContext, future.cause());
                }
            }
        });
    }

    private void setChannelAttributes(ChannelHandlerContext channelHandlerContext, ChannelFuture future, HTTPCarbonMessage httpCarbonRequest, long channelStartTime, int timeoutOfOriginalRequest) {
        HttpResponseFuture responseFuture = channelHandlerContext.channel().attr(Constants.RESPONSE_FUTURE_OF_ORIGINAL_CHANNEL).get();
        future.channel().attr(Constants.RESPONSE_FUTURE_OF_ORIGINAL_CHANNEL).set(responseFuture);
        future.channel().attr(Constants.ORIGINAL_REQUEST).set(httpCarbonRequest);
        future.channel().attr(Constants.REDIRECT_COUNT).set(this.currentRedirectCount);
        future.channel().attr(Constants.ORIGINAL_CHANNEL_START_TIME).set(channelStartTime);
        future.channel().attr(Constants.ORIGINAL_CHANNEL_TIMEOUT).set(timeoutOfOriginalRequest);
        TargetChannel targetChannel = channelHandlerContext.channel().attr(Constants.TARGET_CHANNEL_REFERENCE).get();
        future.channel().attr(Constants.TARGET_CHANNEL_REFERENCE).set(targetChannel);
    }

    private long getRemainingTimeForRedirection(long channelStartTime, int timeoutOfOriginalRequest) {
        long timeElapsedSinceOriginalRequest = System.currentTimeMillis() - channelStartTime;
        return (long)timeoutOfOriginalRequest - timeElapsedSinceOriginalRequest;
    }

    private boolean isRelativePath(String location) {
        return !location.toLowerCase(Locale.ROOT).startsWith("http://") && !location.toLowerCase(Locale.ROOT).startsWith("https://");
    }

    private int getDefaultPort(String protocol) {
        int defaultPort = "https".equals(protocol) ? 443 : 80;
        return defaultPort;
    }
}

