/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplateHandler;

public class DefaultUriTemplateHandler
implements UriTemplateHandler {
    private String baseUrl;
    private boolean parsePath;

    public void setBaseUrl(String baseUrl) {
        if (baseUrl != null) {
            UriComponents uriComponents = UriComponentsBuilder.fromUriString(baseUrl).build();
            Assert.hasText(uriComponents.getScheme(), "'baseUrl' must have a scheme");
            Assert.hasText(uriComponents.getHost(), "'baseUrl' must have a host");
            Assert.isNull(uriComponents.getQuery(), "'baseUrl' cannot have a query");
            Assert.isNull(uriComponents.getFragment(), "'baseUrl' cannot have a fragment");
        }
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setParsePath(boolean parsePath) {
        this.parsePath = parsePath;
    }

    public boolean shouldParsePath() {
        return this.parsePath;
    }

    @Override
    public URI expand(String uriTemplate, Map<String, ?> uriVariables) {
        UriComponentsBuilder uriComponentsBuilder = this.initUriComponentsBuilder(uriTemplate);
        UriComponents uriComponents = uriComponentsBuilder.build().expand(uriVariables).encode();
        return this.insertBaseUrl(uriComponents);
    }

    @Override
    public URI expand(String uriTemplate, Object ... uriVariableValues) {
        UriComponentsBuilder uriComponentsBuilder = this.initUriComponentsBuilder(uriTemplate);
        UriComponents uriComponents = uriComponentsBuilder.build().expand(uriVariableValues).encode();
        return this.insertBaseUrl(uriComponents);
    }

    protected UriComponentsBuilder initUriComponentsBuilder(String uriTemplate) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(uriTemplate);
        if (this.shouldParsePath()) {
            List<String> pathSegments = builder.build().getPathSegments();
            builder.replacePath(null);
            for (String pathSegment : pathSegments) {
                builder.pathSegment(pathSegment);
            }
        }
        return builder;
    }

    protected URI insertBaseUrl(UriComponents uriComponents) {
        if (this.getBaseUrl() == null || uriComponents.getHost() != null) {
            return uriComponents.toUri();
        }
        String url = this.getBaseUrl() + uriComponents.toUriString();
        try {
            return new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid URL after inserting base URL: " + url, ex);
        }
    }
}

