/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.common.certificatevalidation.pathvalidation;

import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.certificatevalidation.CertificateVerificationException;
import org.wso2.transport.http.netty.common.certificatevalidation.RevocationStatus;
import org.wso2.transport.http.netty.common.certificatevalidation.RevocationVerifier;

public class PathChecker
extends PKIXCertPathChecker {
    private X509Certificate[] certChainArray;
    private RevocationVerifier verifier;
    private int position;
    private static final Logger log = LoggerFactory.getLogger(PathChecker.class);

    protected PathChecker(X509Certificate[] certChainArray, RevocationVerifier verifier) {
        this.certChainArray = certChainArray;
        this.position = certChainArray.length - 1;
        this.verifier = verifier;
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("Forward checking is not supported");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        try {
            RevocationStatus status = this.verifier.checkRevocationStatus((X509Certificate)cert, this.nextIssuer());
            if (log.isInfoEnabled()) {
                log.info("Certificate status is: " + status.getMessage());
            }
            if (status != RevocationStatus.GOOD) {
                throw new CertPathValidatorException("Revocation Status is Not Good");
            }
        }
        catch (CertificateVerificationException e) {
            throw new CertPathValidatorException(e);
        }
    }

    private X509Certificate nextIssuer() {
        if (this.position > 0) {
            return this.certChainArray[this.position--];
        }
        throw new ArrayIndexOutOfBoundsException("Certificate Chain Index Out of Bounds");
    }
}

