/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.websocket;

import io.netty.channel.EventLoopGroup;
import java.util.Map;
import org.wso2.transport.http.netty.contract.websocket.HandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnector;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WsClientConnectorConfig;
import org.wso2.transport.http.netty.sender.websocket.WebSocketClient;

public class DefaultWebSocketClientConnector
implements WebSocketClientConnector {
    private final String remoteUrl;
    private final String subProtocols;
    private final int idleTimeout;
    private final Map<String, String> customHeaders;
    private final EventLoopGroup wsClientEventLoopGroup;

    public DefaultWebSocketClientConnector(WsClientConnectorConfig clientConnectorConfig, EventLoopGroup wsClientEventLoopGroup) {
        this.remoteUrl = clientConnectorConfig.getRemoteAddress();
        this.subProtocols = clientConnectorConfig.getSubProtocolsAsCSV();
        this.customHeaders = clientConnectorConfig.getHeaders();
        this.idleTimeout = clientConnectorConfig.getIdleTimeoutInMillis();
        this.wsClientEventLoopGroup = wsClientEventLoopGroup;
    }

    @Override
    public HandshakeFuture connect(WebSocketConnectorListener connectorListener) {
        WebSocketClient webSocketClient = new WebSocketClient(this.remoteUrl, this.subProtocols, this.idleTimeout, this.wsClientEventLoopGroup, this.customHeaders, connectorListener);
        return webSocketClient.handshake();
    }
}

