/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.Http2OutboundRespListener;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;

public final class Http2SourceHandler
extends Http2ConnectionHandler {
    private static final Logger log = LoggerFactory.getLogger(Http2SourceHandler.class);
    private Map<Integer, HTTPCarbonMessage> streamIdRequestMap = PlatformDependent.newConcurrentHashMap();
    private ChannelHandlerContext ctx;
    private Http2FrameListener http2FrameListener = new Http2FrameListener();
    private String interfaceId;
    private ServerConnectorFuture serverConnectorFuture;
    private Http2Connection conn;
    private String serverName;

    public Http2SourceHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, String interfaceId, Http2Connection conn, ServerConnectorFuture serverConnectorFuture, String serverName) {
        super(decoder, encoder, initialSettings);
        this.interfaceId = interfaceId;
        this.serverConnectorFuture = serverConnectorFuture;
        this.conn = conn;
        this.serverName = serverName;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.pipeline().remove("idleStateHandler");
        this.ctx = ctx;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.close();
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            FullHttpRequest upgradedRequest = ((HttpServerUpgradeHandler.UpgradeEvent)evt).upgradeRequest();
            DefaultHttpRequest httpRequest = new DefaultHttpRequest(new HttpVersion("HTTP/2.0", true), upgradedRequest.method(), upgradedRequest.uri(), upgradedRequest.headers());
            HttpCarbonRequest requestCarbonMessage = this.setupCarbonRequest(httpRequest);
            requestCarbonMessage.addHttpContent(new DefaultLastHttpContent(upgradedRequest.content()));
            this.notifyRequestListener(requestCarbonMessage, 1);
        }
        super.userEventTriggered(ctx, evt);
    }

    Http2FrameListener getHttp2FrameListener() {
        return this.http2FrameListener;
    }

    private void notifyRequestListener(HTTPCarbonMessage httpRequestMsg, int streamId) {
        if (this.serverConnectorFuture != null) {
            try {
                ServerConnectorFuture outboundRespFuture = httpRequestMsg.getHttpResponseFuture();
                outboundRespFuture.setHttpConnectorListener(new Http2OutboundRespListener(httpRequestMsg, this.ctx, this.conn, this.encoder(), streamId, this.serverName));
                this.serverConnectorFuture.notifyHttpListener(httpRequestMsg);
            }
            catch (Exception e) {
                log.error("Error while notifying listeners", e);
            }
        } else {
            log.error("Cannot find registered listener to forward the message");
        }
    }

    private HttpCarbonRequest setupCarbonRequest(HttpRequest httpRequest) {
        HttpCarbonRequest sourceReqCMsg = new HttpCarbonRequest(httpRequest);
        sourceReqCMsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", new PooledDataStreamerFactory(this.ctx.alloc()));
        sourceReqCMsg.setProperty("CHNL_HNDLR_CTX", this.ctx);
        HttpVersion protocolVersion = httpRequest.protocolVersion();
        sourceReqCMsg.setProperty("HTTP_VERSION", protocolVersion.majorVersion() + "." + protocolVersion.minorVersion());
        sourceReqCMsg.setProperty("HTTP_METHOD", httpRequest.method().name());
        InetSocketAddress localAddress = null;
        if (this.ctx.channel().localAddress() instanceof InetSocketAddress) {
            localAddress = (InetSocketAddress)this.ctx.channel().localAddress();
        }
        sourceReqCMsg.setProperty("LOCAL_ADDRESS", localAddress);
        sourceReqCMsg.setProperty("LISTENER_PORT", localAddress != null ? Integer.valueOf(localAddress.getPort()) : null);
        sourceReqCMsg.setProperty("listener.interface.id", this.interfaceId);
        sourceReqCMsg.setProperty("PROTOCOL", "http");
        String uri = httpRequest.uri();
        sourceReqCMsg.setProperty("REQUEST_URL", uri);
        sourceReqCMsg.setProperty("TO", uri);
        return sourceReqCMsg;
    }

    private class Http2FrameListener
    extends Http2EventAdapter {
        private Http2FrameListener() {
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
            HTTPCarbonMessage sourceReqCMsg = this.setupHttp2CarbonMsg(headers, streamId);
            if (endOfStream) {
                sourceReqCMsg.addHttpContent(new DefaultLastHttpContent());
            } else {
                Http2SourceHandler.this.streamIdRequestMap.put(streamId, sourceReqCMsg);
            }
            Http2SourceHandler.this.notifyRequestListener(sourceReqCMsg, streamId);
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
            this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
        }

        @Override
        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            HTTPCarbonMessage sourceReqCMsg = (HTTPCarbonMessage)Http2SourceHandler.this.streamIdRequestMap.get(streamId);
            if (sourceReqCMsg != null) {
                if (endOfStream) {
                    sourceReqCMsg.addHttpContent(new DefaultLastHttpContent(data.retain()));
                    Http2SourceHandler.this.streamIdRequestMap.remove(streamId);
                } else {
                    sourceReqCMsg.addHttpContent(new DefaultHttpContent(data.retain()));
                }
            } else {
                log.warn("Inconsistent state detected : data has received before headers");
            }
            return data.readableBytes() + padding;
        }

        private HTTPCarbonMessage setupHttp2CarbonMsg(Http2Headers http2Headers, int streamId) throws Http2Exception {
            return Http2SourceHandler.this.setupCarbonRequest(Util.createHttpRequestFromHttp2Headers(http2Headers, streamId));
        }
    }
}

