/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.handler.codec.http.HttpContent;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.MessageListener;

public class MessageFuture {
    private MessageListener messageListener;
    private HTTPCarbonMessage httpCarbonMessage;
    private ConcurrentLinkedQueue<HttpContent> pendingPayload;

    public MessageFuture(HTTPCarbonMessage httpCarbonMessage) {
        this.httpCarbonMessage = httpCarbonMessage;
        this.pendingPayload = new ConcurrentLinkedQueue();
    }

    public synchronized void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
        while (!this.httpCarbonMessage.isEmpty()) {
            HttpContent httpContent = this.httpCarbonMessage.getHttpContent();
            this.notifyMessageListener(httpContent);
        }
        while (!this.pendingPayload.isEmpty()) {
            this.notifyMessageListener(this.pendingPayload.poll());
        }
    }

    public synchronized void removeMessageListener() {
        this.messageListener = null;
    }

    public synchronized void notifyMessageListener(HttpContent httpContent) {
        if (this.messageListener != null) {
            this.messageListener.onMessage(httpContent);
        } else {
            this.pendingPayload.add(httpContent);
        }
    }

    public synchronized HttpContent sync() {
        return this.httpCarbonMessage.getBlockingEntityCollector().getHttpContent();
    }
}

