/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.HttpBodyPart;

public class MultipartRequestDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartRequestDecoder.class);
    private InterfaceHttpPostRequestDecoder nettyRequestDecoder;
    private HTTPCarbonMessage httpCarbonMessage;
    private List<HttpBodyPart> multiparts = new ArrayList<HttpBodyPart>();

    public MultipartRequestDecoder(HTTPCarbonMessage httpCarbonMessage) {
        this.httpCarbonMessage = httpCarbonMessage;
    }

    public boolean isMultipartRequest() {
        this.nettyRequestDecoder = new HttpPostRequestDecoder(Util.createHttpRequest(this.httpCarbonMessage));
        return this.nettyRequestDecoder.isMultipart();
    }

    public void parseBody() throws IOException {
        boolean isReadAll = false;
        while (!isReadAll) {
            HttpContent httpContent = this.httpCarbonMessage.getHttpContent();
            if (httpContent == null) {
                this.resetPostRequestDecoder();
                throw new IOException("No content was found to decode!");
            }
            this.nettyRequestDecoder = this.nettyRequestDecoder.offer(httpContent);
            this.readChunkByChunk();
            if (httpContent instanceof LastHttpContent) {
                this.resetPostRequestDecoder();
                isReadAll = true;
                continue;
            }
            isReadAll = false;
        }
    }

    private void readChunkByChunk() {
        try {
            while (this.nettyRequestDecoder.hasNext()) {
                InterfaceHttpData data = this.nettyRequestDecoder.next();
                if (data == null) continue;
                try {
                    this.processChunk(data);
                }
                finally {
                    data.release();
                }
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException e) {
            LOG.debug("EndOfDataDecoderException occurred since there's no more data to decode but that's fine");
        }
    }

    private void processChunk(InterfaceHttpData data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Multipart HTTP Data Name: {}, Type: {}", (Object)data.getName(), (Object)data.getHttpDataType());
        }
        HttpBodyPart bodyPart = null;
        switch (data.getHttpDataType()) {
            case Attribute: {
                Attribute attribute = (Attribute)data;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Attribute content size: {}", (Object)attribute.getByteBuf().readableBytes());
                    }
                    bodyPart = new HttpBodyPart(attribute.getName(), attribute.get(), "text/plain", attribute.getByteBuf().readableBytes());
                }
                catch (IOException e) {
                    LOG.error("Unable to read attribute content", e);
                }
                break;
            }
            case FileUpload: {
                FileUpload fileUpload = (FileUpload)data;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Fileupload size: {}", (Object)fileUpload.getByteBuf().readableBytes());
                    }
                    bodyPart = new HttpBodyPart(fileUpload.getName(), fileUpload.getFilename(), fileUpload.get(), fileUpload.getContentType(), fileUpload.getByteBuf().readableBytes());
                }
                catch (IOException e) {
                    LOG.error("Unable to read fileupload content", e);
                }
                break;
            }
            default: {
                LOG.warn("Received unknown attribute type.");
            }
        }
        this.multiparts.add(bodyPart);
    }

    private void resetPostRequestDecoder() {
        this.nettyRequestDecoder.destroy();
        this.nettyRequestDecoder = null;
    }

    public List<HttpBodyPart> getMultiparts() {
        return this.multiparts;
    }
}

