/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.wso2.msf4j.MicroservicesRunner;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.spring.transport.HTTPSTransportConfig;
import org.wso2.msf4j.spring.transport.TransportConfig;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.config.ListenerConfiguration;
import org.wso2.transport.http.netty.config.Parameter;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpWsConnectorFactory;
import org.wso2.transport.http.netty.listener.ServerBootstrapConfiguration;

@Component
public class SpringMicroservicesRunner
extends MicroservicesRunner
implements ApplicationContextAware,
InitializingBean {
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private ApplicationContext applicationContext;

    public SpringMicroservicesRunner() {
    }

    public SpringMicroservicesRunner(int ... ports) {
        super(ports);
    }

    public void init() {
        for (Map.Entry<String, Object> entry : this.applicationContext.getBeansWithAnnotation(Path.class).entrySet()) {
            this.log.info("Deploying " + entry.getKey() + " bean as a resource");
            this.deploy(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.applicationContext.getBeansOfType(ExceptionMapper.class).entrySet()) {
            this.log.info("Adding " + entry.getKey() + "  ExceptionMapper");
            this.addExceptionMapper((ExceptionMapper)entry.getValue());
        }
        this.configureTransport(this.applicationContext.getBeansOfType(ListenerConfiguration.class).values(), this.applicationContext.getBeansOfType(TransportConfig.class).values());
        this.start();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    @Override
    protected void configureTransport() {
    }

    protected void configureTransport(Collection<ListenerConfiguration> listeners, Collection<TransportConfig> transportConfigs) {
        if (System.getProperty("transports.netty.conf") != null) {
            super.configureTransport();
            return;
        }
        DefaultHttpWsConnectorFactory connectorFactory = new DefaultHttpWsConnectorFactory();
        ServerBootstrapConfiguration bootstrapConfiguration = new ServerBootstrapConfiguration(new HashMap<String, Object>());
        listeners.forEach(listenerConfiguration -> {
            DataHolder.getInstance().getMicroservicesRegistries().put(Util.createServerConnectorID(listenerConfiguration.getHost(), listenerConfiguration.getPort()), this.getMsRegistry());
            ServerConnector serverConnector = connectorFactory.createServerConnector(bootstrapConfiguration, (ListenerConfiguration)listenerConfiguration);
            this.serverConnectors.add(serverConnector);
        });
        for (TransportConfig transportConfig : transportConfigs) {
            if (!transportConfig.isEnabled()) continue;
            ListenerConfiguration listenerConfiguration2 = this.createListenerConfiguration(transportConfig);
            DataHolder.getInstance().getMicroservicesRegistries().put(Util.createServerConnectorID(listenerConfiguration2.getHost(), listenerConfiguration2.getPort()), this.getMsRegistry());
            ServerConnector serverConnector = connectorFactory.createServerConnector(bootstrapConfiguration, listenerConfiguration2);
            this.serverConnectors.add(serverConnector);
        }
    }

    private ListenerConfiguration createListenerConfiguration(TransportConfig transportConfig) {
        ListenerConfiguration listenerConfig = new ListenerConfiguration(transportConfig.getId(), transportConfig.getHost(), transportConfig.getPort());
        listenerConfig.setScheme(transportConfig.getScheme());
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Map.Entry<String, String> entry : transportConfig.getParameters().entrySet()) {
            parameters.add(this.createParameter(entry.getKey(), entry.getValue()));
        }
        listenerConfig.setParameters(parameters);
        if ("https".equals(transportConfig.getScheme())) {
            HTTPSTransportConfig httpsTransportConfig = (HTTPSTransportConfig)transportConfig;
            listenerConfig.setKeyStoreFile(httpsTransportConfig.getKeyStoreFile());
            listenerConfig.setKeyStorePass(httpsTransportConfig.getKeyStorePass());
            listenerConfig.setCertPass(httpsTransportConfig.getCertPass());
        }
        return listenerConfig;
    }

    private Parameter createParameter(String key, String value) {
        Parameter parameter = new Parameter();
        parameter.setName(key);
        parameter.setValue(value);
        return parameter;
    }
}

