/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.MessageListener;

public class MessageFuture {
    private static final Logger LOG = LoggerFactory.getLogger(MessageFuture.class);
    private MessageListener messageListener;
    private final HttpCarbonMessage httpCarbonMessage;

    public MessageFuture(HttpCarbonMessage httpCarbonMessage) {
        this.httpCarbonMessage = httpCarbonMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener messageListener) {
        HttpCarbonMessage httpCarbonMessage = this.httpCarbonMessage;
        synchronized (httpCarbonMessage) {
            this.messageListener = messageListener;
            while (!this.httpCarbonMessage.isEmpty()) {
                HttpContent httpContent = this.httpCarbonMessage.getHttpContent();
                this.notifyMessageListener(httpContent);
                if (!(httpContent instanceof LastHttpContent)) continue;
                this.httpCarbonMessage.removeMessageFuture();
                return;
            }
            if (this.httpCarbonMessage.isPassthrough()) {
                this.httpCarbonMessage.removeInboundContentListener();
            }
        }
    }

    void notifyMessageListener(HttpContent httpContent) {
        if (this.messageListener != null) {
            this.messageListener.onMessage(httpContent);
        } else {
            LOG.error("The message chunk will be lost because the MessageListener is not set.");
        }
    }

    public boolean isMessageListenerSet() {
        return this.messageListener != null;
    }

    public synchronized HttpContent sync() {
        return this.httpCarbonMessage.getBlockingEntityCollector().getHttpContent();
    }
}

