/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.http2;

import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;

class EventLoopPool {
    private Map<String, PerRouteConnectionPool> perRouteConnectionPools = new HashMap<String, PerRouteConnectionPool>();

    EventLoopPool() {
    }

    PerRouteConnectionPool fetchPerRoutePool(String key) {
        return this.perRouteConnectionPools.get(key);
    }

    Map<String, PerRouteConnectionPool> getPerRouteConnectionPools() {
        return this.perRouteConnectionPools;
    }

    static class PerRouteConnectionPool {
        private BlockingQueue<Http2ClientChannel> http2ClientChannels = new LinkedBlockingQueue<Http2ClientChannel>();
        private int maxActiveStreams;

        PerRouteConnectionPool(int maxActiveStreams) {
            this.maxActiveStreams = maxActiveStreams;
        }

        Http2ClientChannel fetchTargetChannel() {
            if (!this.http2ClientChannels.isEmpty()) {
                Http2ClientChannel http2ClientChannel = (Http2ClientChannel)this.http2ClientChannels.peek();
                Channel channel = http2ClientChannel.getChannel();
                if (!channel.isActive()) {
                    this.http2ClientChannels.remove(http2ClientChannel);
                    return this.fetchTargetChannel();
                }
                int activeSteamCount = http2ClientChannel.incrementActiveStreamCount();
                if (activeSteamCount < this.maxActiveStreams) {
                    return http2ClientChannel;
                }
                if (activeSteamCount == this.maxActiveStreams) {
                    http2ClientChannel.markAsExhausted();
                    this.http2ClientChannels.remove(http2ClientChannel);
                    return http2ClientChannel;
                }
                this.http2ClientChannels.remove(http2ClientChannel);
                return this.fetchTargetChannel();
            }
            return null;
        }

        void addChannel(Http2ClientChannel http2ClientChannel) {
            this.http2ClientChannels.add(http2ClientChannel);
        }

        void removeChannel(Http2ClientChannel http2ClientChannel) {
            this.http2ClientChannels.remove(http2ClientChannel);
        }
    }
}

