/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpMessageDataStreamer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpMessageDataStreamer.class);
    private static final int CONTENT_BUFFER_SIZE = 8192;
    private final HttpCarbonMessage httpCarbonMessage;
    private ByteBufAllocator pooledByteBufAllocator;
    private ByteBufferInputStream byteBufferInputStream;
    private ByteBufferOutputStream byteBufferOutputStream;

    public HttpMessageDataStreamer(HttpCarbonMessage httpCarbonMessage) {
        this.httpCarbonMessage = httpCarbonMessage;
    }

    public HttpMessageDataStreamer(HttpCarbonMessage httpCarbonMessage, ByteBufAllocator pooledByteBufAllocator) {
        this.httpCarbonMessage = httpCarbonMessage;
        this.pooledByteBufAllocator = pooledByteBufAllocator;
    }

    public OutputStream getOutputStream() {
        if (this.byteBufferOutputStream == null) {
            this.byteBufferOutputStream = new ByteBufferOutputStream();
        }
        return this.byteBufferOutputStream;
    }

    private InputStream createInputStreamIfNull() {
        if (this.byteBufferInputStream == null) {
            this.byteBufferInputStream = new ByteBufferInputStream();
        }
        return this.byteBufferInputStream;
    }

    public InputStream getInputStream() {
        String contentEncodingHeader = this.httpCarbonMessage.getHeader(HttpHeaderNames.CONTENT_ENCODING.toString());
        if (contentEncodingHeader != null) {
            this.httpCarbonMessage.removeHeader(HttpHeaderNames.CONTENT_ENCODING.toString());
            try {
                if (contentEncodingHeader.equalsIgnoreCase("gzip")) {
                    return new GZIPInputStream(this.createInputStreamIfNull());
                }
                if (contentEncodingHeader.equalsIgnoreCase("deflate")) {
                    return new InflaterInputStream(this.createInputStreamIfNull());
                }
                if (!contentEncodingHeader.equalsIgnoreCase("identity")) {
                    LOG.warn("Unknown Content-Encoding: {}", (Object)contentEncodingHeader);
                }
            }
            catch (IOException e) {
                LOG.error("Error while creating inputStream for content-encoding: " + contentEncodingHeader, e);
            }
        }
        return this.createInputStreamIfNull();
    }

    protected class ByteBufferOutputStream
    extends OutputStream {
        private ByteBuf dataHolder;

        protected ByteBufferOutputStream() {
        }

        @Override
        public void write(int b) {
            if (this.dataHolder == null) {
                this.dataHolder = this.getBuffer();
            }
            if (this.dataHolder.writableBytes() != 0) {
                this.dataHolder.writeByte((byte)b);
            } else {
                try {
                    HttpMessageDataStreamer.this.httpCarbonMessage.addHttpContent(new DefaultHttpContent(this.dataHolder));
                    this.dataHolder = this.getBuffer();
                    this.dataHolder.writeByte((byte)b);
                }
                catch (RuntimeException ex) {
                    throw new EncoderException(HttpMessageDataStreamer.this.httpCarbonMessage.getIoException());
                }
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            try {
                if (this.dataHolder != null && this.dataHolder.isReadable()) {
                    HttpMessageDataStreamer.this.httpCarbonMessage.addHttpContent(new DefaultLastHttpContent(this.dataHolder));
                } else {
                    HttpMessageDataStreamer.this.httpCarbonMessage.addHttpContent(LastHttpContent.EMPTY_LAST_CONTENT);
                }
            }
            catch (RuntimeException ex) {
                throw new EncoderException(HttpMessageDataStreamer.this.httpCarbonMessage.getIoException());
            }
            catch (Exception e) {
                LOG.error("Error while closing output stream but underlying resources are reset", e);
            }
            finally {
                HttpMessageDataStreamer.this.byteBufferOutputStream = null;
            }
        }

        private ByteBuf getBuffer() {
            if (HttpMessageDataStreamer.this.pooledByteBufAllocator == null) {
                return Unpooled.buffer(8192);
            }
            return HttpMessageDataStreamer.this.pooledByteBufAllocator.directBuffer(8192);
        }
    }

    protected class ByteBufferInputStream
    extends InputStream {
        private int count;
        private boolean chunkFinished = true;
        private int limit;
        private ByteBuffer byteBuffer;
        private HttpContent httpContent;

        protected ByteBufferInputStream() {
        }

        @Override
        public int read() {
            if (this.httpContent instanceof LastHttpContent && this.chunkFinished) {
                return -1;
            }
            if (this.chunkFinished) {
                this.httpContent = HttpMessageDataStreamer.this.httpCarbonMessage.getHttpContent();
                this.validateHttpContent();
                this.byteBuffer = this.httpContent.content().nioBuffer();
                this.count = 0;
                this.limit = this.byteBuffer.limit();
                if (this.limit == 0) {
                    return -1;
                }
                this.chunkFinished = false;
            }
            ++this.count;
            if (this.count == this.limit) {
                int value = this.byteBuffer.get() & 0xFF;
                this.chunkFinished = true;
                this.byteBuffer = null;
                this.releaseHttpContent();
                return value;
            }
            return this.byteBuffer.get() & 0xFF;
        }

        private void validateHttpContent() {
            if (this.httpContent == null) {
                throw new DecoderException("No entity was added to the queue before the timeout");
            }
            if (this.httpContent.decoderResult().isFailure()) {
                throw new DecoderException(this.httpContent.decoderResult().cause().getMessage());
            }
        }

        @Override
        public void close() throws IOException {
            this.byteBuffer = null;
            super.close();
        }

        private synchronized void releaseHttpContent() {
            if (this.httpContent != null && this.httpContent.refCnt() > 0) {
                this.httpContent.release();
            }
        }
    }
}

