/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache.interceptor;

import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleCacheResolver;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.cache.jcache.interceptor.AnnotationJCacheOperationSource;
import org.springframework.cache.jcache.interceptor.JCacheOperationSource;
import org.springframework.cache.jcache.interceptor.KeyGeneratorAdapter;
import org.springframework.cache.jcache.interceptor.SimpleExceptionCacheResolver;
import org.springframework.util.Assert;

public class DefaultJCacheOperationSource
extends AnnotationJCacheOperationSource
implements BeanFactoryAware,
InitializingBean,
SmartInitializingSingleton {
    private CacheManager cacheManager;
    private CacheResolver cacheResolver;
    private CacheResolver exceptionCacheResolver;
    private KeyGenerator keyGenerator = new SimpleKeyGenerator();
    private KeyGenerator adaptedKeyGenerator;
    private BeanFactory beanFactory;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheResolver(CacheResolver cacheResolver) {
        this.cacheResolver = cacheResolver;
    }

    public CacheResolver getCacheResolver() {
        return this.cacheResolver;
    }

    public void setExceptionCacheResolver(CacheResolver exceptionCacheResolver) {
        this.exceptionCacheResolver = exceptionCacheResolver;
    }

    public CacheResolver getExceptionCacheResolver() {
        return this.exceptionCacheResolver;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void afterPropertiesSet() {
        this.adaptedKeyGenerator = new KeyGeneratorAdapter((JCacheOperationSource)this, this.keyGenerator);
    }

    @Override
    public void afterSingletonsInstantiated() {
        Assert.notNull(this.getDefaultCacheResolver(), "Cache resolver should have been initialized");
    }

    @Override
    protected <T> T getBean(Class<T> type) {
        try {
            return this.beanFactory.getBean(type);
        }
        catch (NoUniqueBeanDefinitionException ex) {
            throw new IllegalStateException("No unique [" + type.getName() + "] bean found in application context - " + "mark one as primary, or declare a more specific implementation type for your cache", ex);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No bean of type [" + type.getName() + "] found in application context", ex);
            }
            return BeanUtils.instantiateClass(type);
        }
    }

    protected CacheManager getDefaultCacheManager() {
        if (this.cacheManager == null) {
            try {
                this.cacheManager = this.beanFactory.getBean(CacheManager.class);
            }
            catch (NoUniqueBeanDefinitionException ex) {
                throw new IllegalStateException("No unique bean of type CacheManager found. Mark one as primary or declare a specific CacheManager to use.");
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new IllegalStateException("No bean of type CacheManager found. Register a CacheManager bean or remove the @EnableCaching annotation from your configuration.");
            }
        }
        return this.cacheManager;
    }

    @Override
    protected CacheResolver getDefaultCacheResolver() {
        if (this.cacheResolver == null) {
            this.cacheResolver = new SimpleCacheResolver(this.getDefaultCacheManager());
        }
        return this.cacheResolver;
    }

    @Override
    protected CacheResolver getDefaultExceptionCacheResolver() {
        if (this.exceptionCacheResolver == null) {
            this.exceptionCacheResolver = new LazyCacheResolver();
        }
        return this.exceptionCacheResolver;
    }

    @Override
    protected KeyGenerator getDefaultKeyGenerator() {
        return this.adaptedKeyGenerator;
    }

    class LazyCacheResolver
    implements CacheResolver {
        private CacheResolver cacheResolver;

        LazyCacheResolver() {
        }

        @Override
        public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
            if (this.cacheResolver == null) {
                this.cacheResolver = new SimpleExceptionCacheResolver(DefaultJCacheOperationSource.this.getDefaultCacheManager());
            }
            return this.cacheResolver.resolveCaches(context);
        }
    }
}

