/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.websocket;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.listener.MessageQueueHandler;
import org.wso2.transport.http.netty.contractimpl.websocket.DefaultClientHandshakeFuture;
import org.wso2.transport.http.netty.contractimpl.websocket.DefaultWebSocketConnection;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketInboundFrameHandler;
import org.wso2.transport.http.netty.message.DefaultListener;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;
import org.wso2.transport.http.netty.message.Listener;

public class WebSocketClientHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketClientHandshakeHandler.class);
    private final WebSocketClientHandshaker handshaker;
    private final MessageQueueHandler messageQueueHandler;
    private final boolean secure;
    private final boolean autoRead;
    private final String requestedUri;
    private final DefaultClientHandshakeFuture handshakeFuture;
    private final WebSocketConnectorFuture connectorFuture;
    private HttpCarbonResponse httpCarbonResponse;

    public WebSocketClientHandshakeHandler(WebSocketClientHandshaker handshaker, DefaultClientHandshakeFuture handshakeFuture, MessageQueueHandler messageQueueHandler, boolean secure, boolean autoRead, String requestedUri, WebSocketConnectorFuture connectorFuture) {
        this.handshaker = handshaker;
        this.messageQueueHandler = messageQueueHandler;
        this.secure = secure;
        this.autoRead = autoRead;
        this.requestedUri = requestedUri;
        this.connectorFuture = connectorFuture;
        this.handshakeFuture = handshakeFuture;
    }

    public HttpCarbonResponse getHttpCarbonResponse() {
        return this.httpCarbonResponse;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof FullHttpResponse)) {
            throw new IllegalArgumentException("HTTP response is expected");
        }
        FullHttpResponse handshakeResponse = (FullHttpResponse)msg;
        this.httpCarbonResponse = this.setUpCarbonMessage(ctx, handshakeResponse);
        try {
            ctx.channel().config().setAutoRead(false);
            this.handshaker.finishHandshake(ctx.channel(), handshakeResponse);
            Channel channel = ctx.channel();
            String extensionsHeader = handshakeResponse.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            if (extensionsHeader == null) {
                channel.pipeline().replace(WebSocketFrameDecoder.class, "ws-decoder", (ChannelHandler)new WebSocket13FrameDecoder(false, false, this.handshaker.maxFramePayloadLength(), false));
            }
            WebSocketInboundFrameHandler inboundFrameHandler = new WebSocketInboundFrameHandler(false, this.secure, this.requestedUri, this.handshaker.actualSubprotocol(), this.connectorFuture, this.messageQueueHandler);
            channel.pipeline().addLast("WEBSOCKET_FRAME_HANDLER", (ChannelHandler)inboundFrameHandler);
            channel.pipeline().remove("websocket-client-handshake-handler");
            DefaultWebSocketConnection webSocketConnection = inboundFrameHandler.getWebSocketConnection();
            if (this.autoRead) {
                webSocketConnection.startReadingFrames();
            } else {
                webSocketConnection.stopReadingFrames();
            }
            this.handshakeFuture.notifySuccess(webSocketConnection, this.httpCarbonResponse);
            ctx.fireChannelActive();
            LOG.debug("WebSocket Client connected");
        }
        finally {
            handshakeResponse.release();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("Caught exception", cause);
        this.handshakeFuture.notifyError(cause, this.httpCarbonResponse);
    }

    private HttpCarbonResponse setUpCarbonMessage(ChannelHandlerContext ctx, HttpResponse msg) {
        HttpCarbonResponse carbonResponse = new HttpCarbonResponse(msg, (Listener)new DefaultListener(ctx));
        carbonResponse.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        carbonResponse.setProperty("HTTP_STATUS_CODE", msg.status().code());
        return carbonResponse;
    }
}

