/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.extensions.servers.carbonserver.TestServerManager;
import org.wso2.ppaas.integration.tests.PPaaSTestServerManager;

public class CarbonTestServerManager
extends TestServerManager {
    private static final Log log = LogFactory.getLog(CarbonTestServerManager.class);
    public static final String PATH_SEP = File.separator;
    public static final String CARBON_CONF_PATH = "repository" + PATH_SEP + "conf";
    public static final String CARBON_HOME_KEY = "carbon.home";
    public static final String BASE_PATH = PPaaSTestServerManager.class.getResource(PATH_SEP).getPath();
    public static final String MOCK_IAAS_XML_FILENAME = "mock-iaas.xml";
    public static final String SCALING_DROOL_FILENAME = "scaling.drl";
    public static final String JNDI_PROPERTIES_FILENAME = "jndi.properties";
    public static final String JMS_OUTPUT_ADAPTER_FILENAME = "JMSOutputAdaptor.xml";
    public static final String CLOUD_CONTROLLER_FILENAME = "cloud-controller.xml";
    public static final String AUTOSCALER_FILENAME = "autoscaler.xml";
    public static final String CARTRIDGE_CONFIG_PROPERTIES_FILENAME = "cartridge-config.properties";
    public static final String IDENTITY_FILENAME = "identity.xml";
    private static final String LOG4J_PROPERTIES_FILENAME = "log4j.properties";

    public CarbonTestServerManager(AutomationContext context) {
        super(context);
    }

    public CarbonTestServerManager(AutomationContext context, String carbonZip, Map<String, String> commandMap) {
        super(context, carbonZip, commandMap);
    }

    public CarbonTestServerManager(AutomationContext context, int portOffset) {
        super(context, portOffset);
    }

    public CarbonTestServerManager(AutomationContext context, String carbonZip) {
        super(context, carbonZip);
    }

    public String startServer() throws IOException, AutomationFrameworkException, XPathExpressionException {
        String carbonHome = super.startServer();
        System.setProperty(CARBON_HOME_KEY, carbonHome);
        return carbonHome;
    }

    public void configureServer() throws AutomationFrameworkException {
        try {
            this.copyArtifacts(this.carbonHome);
        }
        catch (IOException e) {
            log.error((Object)"Could not configure PPAAS server", (Throwable)e);
        }
    }

    public void stopServer() throws AutomationFrameworkException {
        super.stopServer();
    }

    protected void copyArtifacts(String carbonHome) throws IOException {
        String commonResourcesPath = BASE_PATH + PATH_SEP + ".." + PATH_SEP + ".." + PATH_SEP + "src" + PATH_SEP + "test" + PATH_SEP + "resources" + PATH_SEP + "common";
        this.copyConfigFile(carbonHome, commonResourcesPath, MOCK_IAAS_XML_FILENAME, CARBON_CONF_PATH);
        this.copyConfigFile(carbonHome, commonResourcesPath, JNDI_PROPERTIES_FILENAME, CARBON_CONF_PATH);
        this.copyConfigFile(carbonHome, commonResourcesPath, LOG4J_PROPERTIES_FILENAME, CARBON_CONF_PATH);
        this.copyConfigFile(carbonHome, commonResourcesPath, CLOUD_CONTROLLER_FILENAME, CARBON_CONF_PATH);
        this.copyConfigFile(carbonHome, commonResourcesPath, AUTOSCALER_FILENAME, CARBON_CONF_PATH);
        this.copyConfigFile(carbonHome, commonResourcesPath, CARTRIDGE_CONFIG_PROPERTIES_FILENAME, CARBON_CONF_PATH);
        this.copyConfigFile(carbonHome, commonResourcesPath, IDENTITY_FILENAME, CARBON_CONF_PATH);
        this.copyConfigFile(carbonHome, commonResourcesPath, SCALING_DROOL_FILENAME, CARBON_CONF_PATH + PATH_SEP + "drools");
        this.copyConfigFile(carbonHome, commonResourcesPath, JMS_OUTPUT_ADAPTER_FILENAME, "repository" + PATH_SEP + "deployment" + PATH_SEP + "server" + PATH_SEP + "outputeventadaptors");
    }

    private void copyConfigFile(String carbonHome, String filePath, String fileName, String destinationFolder) throws IOException {
        Assert.assertNotNull((Object)carbonHome, (String)"CARBON_HOME is null");
        String fileAbsPath = filePath + PATH_SEP + fileName;
        log.info((Object)("Copying file: " + fileAbsPath));
        File srcFile = new File(fileAbsPath);
        Assert.assertTrue((boolean)srcFile.exists(), (String)("File does not exist [file] " + srcFile.getAbsolutePath()));
        File destFile = new File(carbonHome + PATH_SEP + destinationFolder + PATH_SEP + fileName);
        FileUtils.copyFile((File)srcFile, (File)destFile);
        log.info((Object)("Copying file [source] " + srcFile.getAbsolutePath() + " to [dest] " + destFile.getAbsolutePath()));
    }
}

