/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.stratos.common.test.TestLogAppender;
import org.testng.Assert;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.extensions.servers.carbonserver.MultipleServersManager;
import org.wso2.carbon.automation.extensions.servers.carbonserver.TestServerManager;
import org.wso2.ppaas.integration.tests.CarbonTestServerManager;
import org.wso2.ppaas.integration.tests.rest.IntegrationMockClient;
import org.wso2.ppaas.integration.tests.rest.RestClient;

public class PPaaSTestServerManager {
    private static final Log log = LogFactory.getLog(PPaaSTestServerManager.class);
    public static final String PATH_SEP = File.separator;
    public static final String PORT_OFFSET_KEY = "carbon.port.offset";
    public static final String CARBON_ZIP_KEY = "carbon.zip";
    public static final String ACTIVEMQ_BIND_ADDRESS = "activemq.bind.address";
    public static final int GLOBAL_TEST_TIMEOUT = 300000;
    private static final String DEFAULT_PROFILE = "default";
    protected String adminUsername;
    protected String adminPassword;
    protected String ppaasBackendURL;
    protected String activemqBindAddress;
    protected RestClient restClient;
    private BrokerService broker = new BrokerService();
    private TestLogAppender testLogAppender = new TestLogAppender();
    protected AutomationContext ppaasAutomationCtx;
    protected IntegrationMockClient mockIaasApiClient;
    private MultipleServersManager manager = new MultipleServersManager();

    public PPaaSTestServerManager() {
        this.activemqBindAddress = System.getProperty(ACTIVEMQ_BIND_ADDRESS);
    }

    public void init() {
        Logger.getRootLogger().addAppender((Appender)this.testLogAppender);
        Logger.getRootLogger().setLevel(Level.INFO);
        try {
            long time1 = System.currentTimeMillis();
            log.info((Object)"Starting ActiveMQ...");
            this.broker.setDataDirectory(PPaaSTestServerManager.class.getResource(PATH_SEP).getPath() + File.separator + ".." + File.separator + "activemq-data");
            this.broker.setBrokerName("testBroker");
            this.broker.addConnector(this.activemqBindAddress);
            this.broker.start();
            long time2 = System.currentTimeMillis();
            log.info((Object)String.format("ActiveMQ started in %d sec", (time2 - time1) / 1000L));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start ActiveMQ", e);
        }
        try {
            log.info((Object)"Setting up PPaaS server...");
            this.ppaasAutomationCtx = new AutomationContext("PPAAS", "ppaas-001", TestUserMode.SUPER_TENANT_ADMIN);
            this.adminUsername = this.ppaasAutomationCtx.getConfigurationValue("/automation/userManagement/superTenant/tenant/admin/user/userName");
            this.adminPassword = this.ppaasAutomationCtx.getConfigurationValue("/automation/userManagement/superTenant/tenant/admin/user/password");
            this.ppaasBackendURL = this.ppaasAutomationCtx.getContextUrls().getWebAppURL();
            this.restClient = new RestClient(this.ppaasBackendURL, this.adminUsername, this.adminPassword);
            this.mockIaasApiClient = new IntegrationMockClient(this.ppaasBackendURL + PATH_SEP + "mock-iaas" + PATH_SEP + "api");
            HashMap<String, String> startupParameterMap1 = new HashMap<String, String>();
            startupParameterMap1.put("-DportOffset", System.getProperty(PORT_OFFSET_KEY));
            startupParameterMap1.put("-Dprofile", DEFAULT_PROFILE);
            CarbonTestServerManager ppaasServer = new CarbonTestServerManager(this.ppaasAutomationCtx, System.getProperty(CARBON_ZIP_KEY), startupParameterMap1);
            this.setSystemproperties();
            log.info((Object)("PPaaS server port offset: " + System.getProperty(PORT_OFFSET_KEY)));
            log.info((Object)("PPaaS backend URL: " + this.ppaasBackendURL));
            long time3 = System.currentTimeMillis();
            this.manager.startServers(new TestServerManager[]{ppaasServer});
            String carbonHome = System.getProperty("carbon.home");
            Assert.assertNotNull((Object)carbonHome, (String)"CARBON_HOME is null");
            System.setProperty("carbon.home", carbonHome);
            while (!this.serverStarted()) {
                log.info((Object)"Waiting for topology to be initialized...");
                Thread.sleep(5000L);
            }
            while (!this.mockServiceStarted()) {
                log.info((Object)"Waiting for mock service to be initialized...");
                Thread.sleep(1000L);
            }
            long time4 = System.currentTimeMillis();
            log.info((Object)String.format("PPaaS server started in %d sec", (time4 - time3) / 1000L));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start PPaaS server", e);
        }
    }

    public void cleanup() {
        try {
            this.manager.stopAllServers();
            log.info((Object)"Stopped PPaaS servers");
        }
        catch (AutomationFrameworkException e) {
            log.error((Object)"Could not stop PPaaS servers", (Throwable)e);
        }
        try {
            this.broker.stop();
            log.info((Object)"Stopped ActiveMQ server");
        }
        catch (Exception e) {
            log.error((Object)"Could not stop ActiveMQ server", (Throwable)e);
        }
    }

    private boolean serverStarted() {
        for (String message : this.testLogAppender.getMessages()) {
            if (!message.contains("Topology initialized")) continue;
            return true;
        }
        return false;
    }

    private boolean mockServiceStarted() {
        for (String message : this.testLogAppender.getMessages()) {
            if (!message.contains("Mock IaaS service component activated")) continue;
            return true;
        }
        return false;
    }

    public void setSystemproperties() {
        URL resourceUrl = this.getClass().getResource(File.separator + "keystores" + File.separator + "products" + File.separator + "wso2carbon.jks");
        System.setProperty("javax.net.ssl.trustStore", resourceUrl.getPath());
        System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        log.info((Object)("trustStore set to " + resourceUrl.getPath()));
    }
}

