/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests;

import java.io.File;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.autoscaler.stub.pojo.ApplicationContext;
import org.apache.stratos.common.client.AutoscalerServiceClient;
import org.apache.stratos.common.threading.StratosThreadPool;
import org.apache.stratos.messaging.domain.application.Application;
import org.apache.stratos.messaging.domain.application.ApplicationStatus;
import org.apache.stratos.messaging.domain.application.ClusterDataHolder;
import org.apache.stratos.messaging.domain.application.Group;
import org.apache.stratos.messaging.domain.application.GroupStatus;
import org.apache.stratos.messaging.domain.instance.ClusterInstance;
import org.apache.stratos.messaging.domain.instance.GroupInstance;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Member;
import org.apache.stratos.messaging.domain.topology.MemberStatus;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.application.GroupInstanceActivatedEvent;
import org.apache.stratos.messaging.event.application.GroupInstanceCreatedEvent;
import org.apache.stratos.messaging.event.application.GroupInstanceInactivatedEvent;
import org.apache.stratos.messaging.event.application.GroupInstanceTerminatedEvent;
import org.apache.stratos.messaging.event.application.GroupInstanceTerminatingEvent;
import org.apache.stratos.messaging.event.topology.ClusterInstanceActivatedEvent;
import org.apache.stratos.messaging.event.topology.ClusterInstanceCreatedEvent;
import org.apache.stratos.messaging.event.topology.ClusterInstanceInactivateEvent;
import org.apache.stratos.messaging.event.topology.ClusterInstanceTerminatedEvent;
import org.apache.stratos.messaging.event.topology.ClusterInstanceTerminatingEvent;
import org.apache.stratos.messaging.event.topology.MemberTerminatedEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.application.GroupInstanceActivatedEventListener;
import org.apache.stratos.messaging.listener.application.GroupInstanceCreatedEventListener;
import org.apache.stratos.messaging.listener.application.GroupInstanceInactivateEventListener;
import org.apache.stratos.messaging.listener.application.GroupInstanceTerminatedEventListener;
import org.apache.stratos.messaging.listener.application.GroupInstanceTerminatingEventListener;
import org.apache.stratos.messaging.listener.topology.ClusterInstanceActivatedEventListener;
import org.apache.stratos.messaging.listener.topology.ClusterInstanceCreatedEventListener;
import org.apache.stratos.messaging.listener.topology.ClusterInstanceInactivateEventListener;
import org.apache.stratos.messaging.listener.topology.ClusterInstanceTerminatedEventListener;
import org.apache.stratos.messaging.listener.topology.ClusterInstanceTerminatingEventListener;
import org.apache.stratos.messaging.listener.topology.MemberTerminatedEventListener;
import org.apache.stratos.messaging.message.receiver.application.ApplicationManager;
import org.apache.stratos.messaging.message.receiver.application.ApplicationsEventReceiver;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventReceiver;
import org.apache.stratos.messaging.message.receiver.topology.TopologyManager;
import org.wso2.ppaas.integration.tests.rest.IntegrationMockClient;

public class TopologyHandler {
    private static final Log log = LogFactory.getLog(TopologyHandler.class);
    public static final int APPLICATION_ACTIVATION_TIMEOUT = 360000;
    public static final int APPLICATION_UNDEPLOYMENT_TIMEOUT = 120000;
    public static final int MEMBER_TERMINATION_TIMEOUT = 120000;
    public static final int APPLICATION_TOPOLOGY_TIMEOUT = 90000;
    public static final String APPLICATION_STATUS_CREATED = "Created";
    public static final String APPLICATION_STATUS_UNDEPLOYING = "Undeploying";
    private ApplicationsEventReceiver applicationsEventReceiver;
    private TopologyEventReceiver topologyEventReceiver;
    public static TopologyHandler topologyHandler;
    private Map<String, Long> terminatedMembers = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> terminatingMembers = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> createdMembers = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> inActiveMembers = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> activateddMembers = new ConcurrentHashMap<String, Long>();

    private TopologyHandler() {
        System.setProperty("jndi.properties.dir", this.getResourcesFolderPath());
        System.setProperty("autoscaler.service.url", "https://localhost:9443/services/AutoscalerService");
        this.initializeApplicationEventReceiver();
        this.initializeTopologyEventReceiver();
        this.assertApplicationTopologyInitialized();
        this.assertTopologyInitialized();
        this.addTopologyEventListeners();
        this.addApplicationEventListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TopologyHandler getInstance() {
        if (topologyHandler != null) return topologyHandler;
        Class<TopologyHandler> clazz = TopologyHandler.class;
        synchronized (TopologyHandler.class) {
            if (topologyHandler != null) return topologyHandler;
            topologyHandler = new TopologyHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return topologyHandler;
        }
    }

    private void initializeApplicationEventReceiver() {
        if (this.applicationsEventReceiver == null) {
            this.applicationsEventReceiver = new ApplicationsEventReceiver();
            ExecutorService executorService = StratosThreadPool.getExecutorService((String)"STRATOS_TEST_SERVER", (int)1);
            this.applicationsEventReceiver.setExecutorService(executorService);
            this.applicationsEventReceiver.execute();
        }
    }

    private void initializeTopologyEventReceiver() {
        if (this.topologyEventReceiver == null) {
            this.topologyEventReceiver = new TopologyEventReceiver();
            ExecutorService executorService = StratosThreadPool.getExecutorService((String)"STRATOS_TEST_SERVER1", (int)1);
            this.topologyEventReceiver.setExecutorService(executorService);
            this.topologyEventReceiver.execute();
        }
    }

    private void assertApplicationTopologyInitialized() {
        long startTime = System.currentTimeMillis();
        boolean applicationTopologyInitialized = ApplicationManager.getApplications().isInitialized();
        while (!applicationTopologyInitialized) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            applicationTopologyInitialized = ApplicationManager.getApplications().isInitialized();
            if (System.currentTimeMillis() - startTime <= 90000L) continue;
        }
        Assert.assertEquals((String)String.format("Application Topology didn't get initialized ", new Object[0]), (boolean)applicationTopologyInitialized, (boolean)true);
    }

    private void assertTopologyInitialized() {
        long startTime = System.currentTimeMillis();
        boolean topologyInitialized = TopologyManager.getTopology().isInitialized();
        while (!topologyInitialized) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            topologyInitialized = TopologyManager.getTopology().isInitialized();
            if (System.currentTimeMillis() - startTime <= 90000L) continue;
        }
        Assert.assertEquals((String)String.format("Topology didn't get initialized ", new Object[0]), (boolean)topologyInitialized, (boolean)true);
    }

    public void assertApplicationStatus(String applicationName, ApplicationStatus status) {
        long startTime = System.currentTimeMillis();
        Application application = ApplicationManager.getApplications().getApplication(applicationName);
        while (application == null || application.getStatus() != status) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            application = ApplicationManager.getApplications().getApplication(applicationName);
            if (System.currentTimeMillis() - startTime <= 360000L) continue;
        }
        Assert.assertNotNull((String)String.format("Application is not found: [application-id] %s", applicationName), (Object)application);
        Assert.assertEquals((String)String.format("Application status did not change to %s: [application-id] %s", status.toString(), applicationName), (Object)status, (Object)application.getStatus());
    }

    public void assertGroupActivation(String applicationName) {
        Application application = ApplicationManager.getApplications().getApplication(applicationName);
        Assert.assertNotNull((String)String.format("Application is not found: [application-id] %s", applicationName), (Object)application);
        Set groups = application.getAllGroupsRecursively();
        for (Group group : groups) {
            Assert.assertEquals((group.getInstanceContextCount() >= group.getGroupMinInstances() ? 1 : 0) != 0, (boolean)true);
        }
    }

    public void assertClusterActivation(String applicationName) {
        Application application = ApplicationManager.getApplications().getApplication(applicationName);
        Assert.assertNotNull((String)String.format("Application is not found: [application-id] %s", applicationName), (Object)application);
        Set clusterDataHolderSet = application.getClusterDataRecursively();
        for (ClusterDataHolder clusterDataHolder : clusterDataHolderSet) {
            String serviceName = clusterDataHolder.getServiceType();
            String clusterId = clusterDataHolder.getClusterId();
            Service service = TopologyManager.getTopology().getService(serviceName);
            Assert.assertNotNull((String)String.format("Service is not found: [application-id] %s [service] %s", applicationName, serviceName), (Object)service);
            Cluster cluster = service.getCluster(clusterId);
            Assert.assertNotNull((String)String.format("Cluster is not found: [application-id] %s [service] %s [cluster-id] %s", applicationName, serviceName, clusterId), (Object)cluster);
            for (Member member : cluster.getMembers()) {
                log.info((Object)String.format("Member [member-id] %s found in cluster instance [cluster-instance] %s of cluster [cluster-id] %s", member.getMemberId(), member.getClusterInstanceId(), member.getClusterId()));
            }
            boolean clusterActive = false;
            for (ClusterInstance instance : cluster.getInstanceIdToInstanceContextMap().values()) {
                log.info((Object)("Checking for active members in cluster instance: " + instance.getInstanceId()));
                int activeInstances = 0;
                for (Member member : cluster.getMembers()) {
                    if (!member.getClusterInstanceId().equals(instance.getInstanceId()) || !member.getStatus().equals((Object)MemberStatus.Active)) continue;
                    ++activeInstances;
                }
                clusterActive = activeInstances >= clusterDataHolder.getMinInstances();
                Assert.assertTrue((String)String.format("Cluster status did not change to active: [cluster-id] %s", clusterId), (boolean)clusterActive);
            }
        }
    }

    public Map<String, Member> getMembersForCluster(String cartridgeName, String applicationName) {
        Application application = ApplicationManager.getApplications().getApplication(applicationName);
        Assert.assertNotNull((String)String.format("Application is not found: [application-id] %s", applicationName), (Object)application);
        Set clusterDataHolderSet = application.getClusterDataRecursively();
        HashMap<String, Member> memberMap = new HashMap<String, Member>();
        for (ClusterDataHolder clusterDataHolder : clusterDataHolderSet) {
            String serviceName = clusterDataHolder.getServiceType();
            if (!cartridgeName.equals(serviceName)) continue;
            String clusterId = clusterDataHolder.getClusterId();
            Service service = TopologyManager.getTopology().getService(serviceName);
            Assert.assertNotNull((String)String.format("Service is not found: [application-id] %s [service] %s", applicationName, serviceName), (Object)service);
            Cluster cluster = service.getCluster(clusterId);
            Assert.assertNotNull((String)String.format("Cluster is not found: [application-id] %s [service] %s [cluster-id] %s", applicationName, serviceName, clusterId), (Object)cluster);
            for (ClusterInstance instance : cluster.getInstanceIdToInstanceContextMap().values()) {
                for (Member member : cluster.getMembers()) {
                    memberMap.put(member.getMemberId(), member);
                }
            }
        }
        return memberMap;
    }

    public void terminateMemberInMockIaas(String memberId, IntegrationMockClient mockIaasApiClient) {
        boolean memberTerminated = false;
        memberTerminated = mockIaasApiClient.terminateInstance(memberId);
        Assert.assertTrue((String)String.format("Member [member-id] %s couldn't be terminated from the mock IaaS", memberId), (boolean)memberTerminated);
    }

    public void assertMemberTermination(String memberId) {
        long startTime = System.currentTimeMillis();
        Assert.assertNotNull((Object)String.format("Member id is not found: [member-id] %s", memberId));
        boolean hasMemberRemoved = false;
        while (!hasMemberRemoved) {
            if (this.getTerminatingMembers().get(memberId) == null && this.getInActiveMembers().get(memberId) == null && this.getActivateddMembers().get(memberId) == null && this.getCreatedMembers().get(memberId) == null) {
                this.getTerminatedMembers().remove(memberId);
                hasMemberRemoved = true;
            } else if (this.getTerminatedMembers().get(memberId) - startTime > 120000L) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error((Object)"Could not sleep", (Throwable)e);
            }
        }
        Assert.assertTrue((String)String.format("Member [member-id] %s did not get removed from the topology", memberId), (boolean)hasMemberRemoved);
    }

    public void assertClusterMinMemberCount(String applicationName, int minMembers) {
        long startTime = System.currentTimeMillis();
        Application application = ApplicationManager.getApplications().getApplication(applicationName);
        Assert.assertNotNull((String)String.format("Application is not found: [application-id] %s", applicationName), (Object)application);
        Set clusterDataHolderSet = application.getClusterDataRecursively();
        for (ClusterDataHolder clusterDataHolder : clusterDataHolderSet) {
            String serviceName = clusterDataHolder.getServiceType();
            String clusterId = clusterDataHolder.getClusterId();
            Service service = TopologyManager.getTopology().getService(serviceName);
            Assert.assertNotNull((String)String.format("Service is not found: [application-id] %s [service] %s", applicationName, serviceName), (Object)service);
            Cluster cluster = service.getCluster(clusterId);
            Assert.assertNotNull((String)String.format("Cluster is not found: [application-id] %s [service] %s [cluster-id] %s", applicationName, serviceName, clusterId), (Object)cluster);
            boolean clusterActive = false;
            block3: for (ClusterInstance instance : cluster.getInstanceIdToInstanceContextMap().values()) {
                int activeInstances = 0;
                for (Member member : cluster.getMembers()) {
                    if (!member.getClusterInstanceId().equals(instance.getInstanceId()) || !member.getStatus().equals((Object)MemberStatus.Active)) continue;
                    ++activeInstances;
                }
                boolean bl = clusterActive = activeInstances >= minMembers;
                while (!clusterActive) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    service = TopologyManager.getTopology().getService(serviceName);
                    Assert.assertNotNull((String)String.format("Service is not found: [application-id] %s [service] %s", applicationName, serviceName), (Object)service);
                    cluster = service.getCluster(clusterId);
                    activeInstances = 0;
                    for (Member member : cluster.getMembers()) {
                        if (!member.getClusterInstanceId().equals(instance.getInstanceId()) || !member.getStatus().equals((Object)MemberStatus.Active)) continue;
                        ++activeInstances;
                    }
                    clusterActive = activeInstances >= minMembers;
                    Assert.assertNotNull((String)String.format("Cluster is not found: [application-id] %s [service] %s [cluster-id] %s", applicationName, serviceName, clusterId), (Object)cluster);
                    if (System.currentTimeMillis() - startTime <= 360000L) continue;
                    continue block3;
                }
            }
            Assert.assertEquals((String)String.format("Cluster status did not change to active: [cluster-id] %s", clusterId), (boolean)clusterActive, (boolean)true);
        }
    }

    public boolean assertApplicationUndeploy(String applicationName) {
        long startTime = System.currentTimeMillis();
        Application application = ApplicationManager.getApplications().getApplication(applicationName);
        ApplicationContext applicationContext = null;
        try {
            applicationContext = AutoscalerServiceClient.getInstance().getApplication(applicationName);
        }
        catch (RemoteException e) {
            log.error((Object)("Error while getting the application context for [application] " + applicationName));
        }
        while (application != null && application.getInstanceContextCount() > 0 || applicationContext == null || applicationContext.getStatus().equals(APPLICATION_STATUS_UNDEPLOYING)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            application = ApplicationManager.getApplications().getApplication(applicationName);
            try {
                applicationContext = AutoscalerServiceClient.getInstance().getApplication(applicationName);
            }
            catch (RemoteException e) {
                log.error((Object)("Error while getting the application context for [application] " + applicationName));
            }
            if (System.currentTimeMillis() - startTime <= 120000L) continue;
        }
        Assert.assertNotNull((String)String.format("Application is not found: [application-id] %s", applicationName), (Object)application);
        Assert.assertNotNull((String)String.format("Application Context is not found: [application-id] %s", applicationName), (Object)applicationContext);
        if (application.getInstanceContextCount() > 0 || applicationContext.getStatus().equals(APPLICATION_STATUS_UNDEPLOYING)) {
            return false;
        }
        Assert.assertEquals((String)String.format("Application status did not change to Created: [application-id] %s", applicationName), (String)APPLICATION_STATUS_CREATED, (String)applicationContext.getStatus());
        return true;
    }

    public void assertGroupInstanceCount(String applicationName, String groupAlias, int count) {
        long startTime = System.currentTimeMillis();
        Application application = ApplicationManager.getApplications().getApplication(applicationName);
        if (application != null) {
            Group group = application.getGroupRecursively(groupAlias);
            while (group.getInstanceContextCount() != count) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - startTime <= 360000L) continue;
            }
            block5: for (GroupInstance instance : group.getInstanceIdToInstanceContextMap().values()) {
                while (!instance.getStatus().equals((Object)GroupStatus.Active)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - startTime <= 360000L) continue;
                    continue block5;
                }
            }
            Assert.assertEquals((String)String.format("Application status did not change to active: [application-id] %s", applicationName), (int)group.getInstanceContextCount(), (int)count);
        }
        Assert.assertNotNull((String)String.format("Application is not found: [application-id] %s", applicationName), (Object)application);
    }

    public void assertApplicationNotExists(String applicationName) {
        Application application = ApplicationManager.getApplications().getApplication(applicationName);
        Assert.assertNull((String)String.format("Application is found in the topology : [application-id] %s", applicationName), (Object)application);
    }

    private String getResourcesFolderPath() {
        String path = this.getClass().getResource("/").getPath();
        return StringUtils.removeEnd((String)path, (String)File.separator);
    }

    private void addTopologyEventListeners() {
        this.topologyEventReceiver.addEventListener((EventListener)new MemberTerminatedEventListener(){

            protected void onEvent(Event event) {
                MemberTerminatedEvent memberTerminatedEvent = (MemberTerminatedEvent)event;
                TopologyHandler.this.getTerminatedMembers().put(memberTerminatedEvent.getMemberId(), System.currentTimeMillis());
                TopologyHandler.this.getActivateddMembers().remove(((MemberTerminatedEvent)event).getMemberId());
                TopologyHandler.this.getCreatedMembers().remove(((MemberTerminatedEvent)event).getMemberId());
                TopologyHandler.this.getInActiveMembers().remove(((MemberTerminatedEvent)event).getMemberId());
                TopologyHandler.this.getTerminatingMembers().remove(((MemberTerminatedEvent)event).getMemberId());
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new ClusterInstanceCreatedEventListener(){

            protected void onEvent(Event event) {
                ClusterInstanceCreatedEvent event1 = (ClusterInstanceCreatedEvent)event;
                String clusterId = event1.getClusterId();
                TopologyHandler.this.getCreatedMembers().put(clusterId, System.currentTimeMillis());
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new ClusterInstanceActivatedEventListener(){

            protected void onEvent(Event event) {
                ClusterInstanceActivatedEvent event1 = (ClusterInstanceActivatedEvent)event;
                String clusterId = event1.getClusterId();
                TopologyHandler.this.getActivateddMembers().put(clusterId, System.currentTimeMillis());
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new ClusterInstanceInactivateEventListener(){

            protected void onEvent(Event event) {
                ClusterInstanceInactivateEvent event1 = (ClusterInstanceInactivateEvent)event;
                String clusterId = event1.getClusterId();
                TopologyHandler.this.getInActiveMembers().put(clusterId, System.currentTimeMillis());
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new ClusterInstanceTerminatedEventListener(){

            protected void onEvent(Event event) {
                ClusterInstanceTerminatedEvent event1 = (ClusterInstanceTerminatedEvent)event;
                String clusterId = event1.getClusterId();
                TopologyHandler.this.getTerminatedMembers().put(clusterId, System.currentTimeMillis());
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new ClusterInstanceTerminatingEventListener(){

            protected void onEvent(Event event) {
                ClusterInstanceTerminatingEvent event1 = (ClusterInstanceTerminatingEvent)event;
                String clusterId = event1.getClusterId();
                TopologyHandler.this.getTerminatingMembers().put(clusterId, System.currentTimeMillis());
            }
        });
    }

    private void addApplicationEventListeners() {
        this.applicationsEventReceiver.addEventListener((EventListener)new GroupInstanceCreatedEventListener(){

            protected void onEvent(Event event) {
                GroupInstanceCreatedEvent event1 = (GroupInstanceCreatedEvent)event;
                String appId = event1.getAppId();
                String groupId = event1.getGroupId();
                String instanceId = event1.getGroupInstance().getInstanceId();
                String id = TopologyHandler.this.generateId(appId, groupId, instanceId);
                TopologyHandler.this.getCreatedMembers().put(id, System.currentTimeMillis());
            }
        });
        this.applicationsEventReceiver.addEventListener((EventListener)new GroupInstanceActivatedEventListener(){

            protected void onEvent(Event event) {
                GroupInstanceActivatedEvent event1 = (GroupInstanceActivatedEvent)event;
                String appId = event1.getAppId();
                String groupId = event1.getGroupId();
                String instanceId = event1.getInstanceId();
                String id = TopologyHandler.this.generateId(appId, groupId, instanceId);
                TopologyHandler.this.getActivateddMembers().put(id, System.currentTimeMillis());
            }
        });
        this.applicationsEventReceiver.addEventListener((EventListener)new GroupInstanceInactivateEventListener(){

            protected void onEvent(Event event) {
                GroupInstanceInactivatedEvent event1 = (GroupInstanceInactivatedEvent)event;
                String appId = event1.getAppId();
                String groupId = event1.getGroupId();
                String instanceId = event1.getInstanceId();
                String id = TopologyHandler.this.generateId(appId, groupId, instanceId);
                TopologyHandler.this.getInActiveMembers().put(id, System.currentTimeMillis());
            }
        });
        this.applicationsEventReceiver.addEventListener((EventListener)new GroupInstanceTerminatedEventListener(){

            protected void onEvent(Event event) {
                GroupInstanceTerminatedEvent event1 = (GroupInstanceTerminatedEvent)event;
                String appId = event1.getAppId();
                String groupId = event1.getGroupId();
                String instanceId = event1.getInstanceId();
                String id = TopologyHandler.this.generateId(appId, groupId, instanceId);
                TopologyHandler.this.getTerminatedMembers().put(id, System.currentTimeMillis());
            }
        });
        this.applicationsEventReceiver.addEventListener((EventListener)new GroupInstanceTerminatingEventListener(){

            protected void onEvent(Event event) {
                GroupInstanceTerminatingEvent event1 = (GroupInstanceTerminatingEvent)event;
                String appId = event1.getAppId();
                String groupId = event1.getGroupId();
                String instanceId = event1.getInstanceId();
                String id = TopologyHandler.this.generateId(appId, groupId, instanceId);
                TopologyHandler.this.getTerminatingMembers().put(id, System.currentTimeMillis());
            }
        });
    }

    public String generateId(String appId, String groupId, String instanceId) {
        return appId + "-" + groupId + "-" + instanceId;
    }

    public String getClusterIdFromAlias(String applicationId, String alias) {
        Application application = ApplicationManager.getApplications().getApplication(applicationId);
        Assert.assertNotNull((Object)application);
        ClusterDataHolder dataHolder = application.getClusterDataHolderRecursivelyByAlias(alias);
        Assert.assertNotNull((Object)dataHolder);
        return dataHolder.getClusterId();
    }

    public void removeMembersFromMaps(String applicationId) {
        for (Map.Entry<String, Long> entry : this.getActivateddMembers().entrySet()) {
            if (!entry.getKey().contains(applicationId)) continue;
            this.getActivateddMembers().remove(entry.getKey());
        }
        for (Map.Entry<String, Long> entry : this.getTerminatedMembers().entrySet()) {
            if (!entry.getKey().contains(applicationId)) continue;
            this.getTerminatedMembers().remove(entry.getKey());
        }
    }

    public Map<String, Long> getTerminatedMembers() {
        return this.terminatedMembers;
    }

    public void setTerminatedMembers(Map<String, Long> terminatedMembers) {
        this.terminatedMembers = terminatedMembers;
    }

    public Map<String, Long> getTerminatingMembers() {
        return this.terminatingMembers;
    }

    public void setTerminatingMembers(Map<String, Long> terminatingMembers) {
        this.terminatingMembers = terminatingMembers;
    }

    public Map<String, Long> getCreatedMembers() {
        return this.createdMembers;
    }

    public void setCreatedMembers(Map<String, Long> createdMembers) {
        this.createdMembers = createdMembers;
    }

    public Map<String, Long> getInActiveMembers() {
        return this.inActiveMembers;
    }

    public void setInActiveMembers(Map<String, Long> inActiveMembers) {
        this.inActiveMembers = inActiveMembers;
    }

    public Map<String, Long> getActivateddMembers() {
        return this.activateddMembers;
    }

    public void setActivateddMembers(Map<String, Long> activateddMembers) {
        this.activateddMembers = activateddMembers;
    }
}

