/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests.application;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.beans.application.ApplicationBean;
import org.apache.stratos.common.beans.cartridge.CartridgeGroupBean;
import org.apache.stratos.common.beans.cartridge.CartridgeGroupReferenceBean;
import org.apache.stratos.common.beans.cartridge.CartridgeReferenceBean;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.ppaas.integration.tests.PPaaSTestServerManager;

public class SampleApplicationsTest
extends PPaaSTestServerManager {
    private static final Log log = LogFactory.getLog(SampleApplicationsTest.class);
    private static final String RESOURCES_PATH = "/sample-applications-test";

    @BeforeClass(alwaysRun=true)
    public void testInit() throws Exception {
        super.init();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanup();
    }

    @Test(alwaysRun=true, description="Deploy sample application", priority=1, timeOut=300000L)
    @SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
    public void testApplication() {
        log.info((Object)"-------------------------------Started application test case-------------------------------");
        try {
            String autoscalingPolicyId = "autoscaling-policy-sample-applications-test";
            boolean addedScalingPolicy = this.restClient.addEntity("/sample-applications-test/autoscaling-policies//" + autoscalingPolicyId + ".json", "/api/autoscalingPolicies", "autoscalingPolicy");
            Assert.assertEquals((boolean)addedScalingPolicy, (boolean)true);
            boolean addedC1 = this.restClient.addEntity("/sample-applications-test/cartridges/mock//c1-sample-applications-test.json", "/api/cartridges", "cartridge");
            Assert.assertEquals((boolean)addedC1, (boolean)true);
            boolean addedC2 = this.restClient.addEntity("/sample-applications-test/cartridges/mock//c2-sample-applications-test.json", "/api/cartridges", "cartridge");
            Assert.assertEquals((boolean)addedC2, (boolean)true);
            boolean addedC3 = this.restClient.addEntity("/sample-applications-test/cartridges/mock//c3-sample-applications-test.json", "/api/cartridges", "cartridge");
            Assert.assertEquals((boolean)addedC3, (boolean)true);
            boolean addedG1 = this.restClient.addEntity("/sample-applications-test/cartridges-groups//cartrdige-nested-sample-applications-test.json", "/api/cartridgeGroups", "cartridgeGroup");
            Assert.assertEquals((boolean)addedG1, (boolean)true);
            CartridgeGroupBean beanG1 = (CartridgeGroupBean)this.restClient.getEntity("/api/cartridgeGroups", "G1-sample-applications-test", CartridgeGroupBean.class, "cartridgeGroup");
            Assert.assertEquals((String)beanG1.getName(), (String)"G1-sample-applications-test");
            boolean addedN1 = this.restClient.addEntity("/sample-applications-test/network-partitions/mock//network-partition-sample-applications-test-1.json", "/api/networkPartitions", "networkPartition");
            Assert.assertEquals((boolean)addedN1, (boolean)true);
            boolean addedN2 = this.restClient.addEntity("/sample-applications-test/network-partitions/mock//network-partition-sample-applications-test-2.json", "/api/networkPartitions", "networkPartition");
            Assert.assertEquals((boolean)addedN2, (boolean)true);
            boolean addedDep = this.restClient.addEntity("/sample-applications-test/deployment-policies//deployment-policy-sample-applications-test.json", "/api/deploymentPolicies", "deploymentPolicy");
            Assert.assertEquals((boolean)addedDep, (boolean)true);
            boolean added = this.restClient.addEntity("/sample-applications-test/applications//g-sc-G123-1-sample-applications-test.json", "/api/applications", "application");
            Assert.assertEquals((boolean)added, (boolean)true);
            ApplicationBean bean = (ApplicationBean)this.restClient.getEntity("/api/applications", "g-sc-G123-1-sample-applications-test", ApplicationBean.class, "application");
            Assert.assertEquals((String)bean.getApplicationId(), (String)"g-sc-G123-1-sample-applications-test");
            CartridgeGroupReferenceBean group1 = (CartridgeGroupReferenceBean)bean.getComponents().getGroups().get(0);
            CartridgeGroupReferenceBean group2 = (CartridgeGroupReferenceBean)group1.getGroups().get(0);
            CartridgeGroupReferenceBean group3 = (CartridgeGroupReferenceBean)group2.getGroups().get(0);
            CartridgeReferenceBean c1 = (CartridgeReferenceBean)group1.getCartridges().get(0);
            CartridgeReferenceBean c2 = (CartridgeReferenceBean)group2.getCartridges().get(0);
            CartridgeReferenceBean c3 = (CartridgeReferenceBean)group3.getCartridges().get(0);
            Assert.assertEquals((String)group1.getName(), (String)"G1-sample-applications-test");
            Assert.assertEquals((String)group1.getAlias(), (String)"group1-sample-applications-test");
            Assert.assertEquals((int)group1.getGroupMaxInstances(), (int)1);
            Assert.assertEquals((int)group1.getGroupMinInstances(), (int)1);
            Assert.assertEquals((String)c1.getType(), (String)"c1-sample-applications-test");
            Assert.assertEquals((int)c1.getCartridgeMin(), (int)1);
            Assert.assertEquals((int)c1.getCartridgeMax(), (int)2);
            Assert.assertEquals((String)group2.getAlias(), (String)"group2-sample-applications-test");
            Assert.assertEquals((String)group2.getName(), (String)"G2-sample-applications-test");
            Assert.assertEquals((int)group2.getGroupMaxInstances(), (int)1);
            Assert.assertEquals((int)group2.getGroupMinInstances(), (int)1);
            Assert.assertEquals((String)c2.getType(), (String)"c2-sample-applications-test");
            Assert.assertEquals((int)c2.getCartridgeMin(), (int)1);
            Assert.assertEquals((int)c2.getCartridgeMax(), (int)2);
            Assert.assertEquals((String)group3.getAlias(), (String)"group3-sample-applications-test");
            Assert.assertEquals((String)group3.getName(), (String)"G3-sample-applications-test");
            Assert.assertEquals((int)group3.getGroupMaxInstances(), (int)2);
            Assert.assertEquals((int)group3.getGroupMinInstances(), (int)1);
            Assert.assertEquals((String)c3.getType(), (String)"c3-sample-applications-test");
            Assert.assertEquals((int)c3.getCartridgeMin(), (int)1);
            Assert.assertEquals((int)c3.getCartridgeMax(), (int)2);
            boolean updated = this.restClient.updateEntity("/sample-applications-test/applications//g-sc-G123-1-sample-applications-test-v1.json", "/api/applications", "application");
            Assert.assertEquals((boolean)updated, (boolean)true);
            ApplicationBean updatedBean = (ApplicationBean)this.restClient.getEntity("/api/applications", "g-sc-G123-1-sample-applications-test", ApplicationBean.class, "application");
            Assert.assertEquals((String)bean.getApplicationId(), (String)"g-sc-G123-1-sample-applications-test");
            group1 = (CartridgeGroupReferenceBean)updatedBean.getComponents().getGroups().get(0);
            group2 = (CartridgeGroupReferenceBean)group1.getGroups().get(0);
            group3 = (CartridgeGroupReferenceBean)group2.getGroups().get(0);
            c1 = (CartridgeReferenceBean)group1.getCartridges().get(0);
            c2 = (CartridgeReferenceBean)group2.getCartridges().get(0);
            c3 = (CartridgeReferenceBean)group3.getCartridges().get(0);
            Assert.assertEquals((String)group1.getName(), (String)"G1-sample-applications-test");
            Assert.assertEquals((String)group1.getAlias(), (String)"group1-sample-applications-test");
            Assert.assertEquals((int)group1.getGroupMaxInstances(), (int)1);
            Assert.assertEquals((int)group1.getGroupMinInstances(), (int)1);
            Assert.assertEquals((String)c1.getType(), (String)"c1-sample-applications-test");
            Assert.assertEquals((int)c1.getCartridgeMin(), (int)2);
            Assert.assertEquals((int)c1.getCartridgeMax(), (int)3);
            Assert.assertEquals((String)group2.getAlias(), (String)"group2-sample-applications-test");
            Assert.assertEquals((String)group2.getName(), (String)"G2-sample-applications-test");
            Assert.assertEquals((int)group2.getGroupMaxInstances(), (int)1);
            Assert.assertEquals((int)group2.getGroupMinInstances(), (int)1);
            Assert.assertEquals((String)c2.getType(), (String)"c2-sample-applications-test");
            Assert.assertEquals((int)c2.getCartridgeMin(), (int)2);
            Assert.assertEquals((int)c2.getCartridgeMax(), (int)4);
            Assert.assertEquals((String)group3.getAlias(), (String)"group3-sample-applications-test");
            Assert.assertEquals((String)group3.getName(), (String)"G3-sample-applications-test");
            Assert.assertEquals((int)group3.getGroupMaxInstances(), (int)3);
            Assert.assertEquals((int)group3.getGroupMinInstances(), (int)2);
            Assert.assertEquals((String)c3.getType(), (String)"c3-sample-applications-test");
            Assert.assertEquals((int)c3.getCartridgeMin(), (int)2);
            Assert.assertEquals((int)c3.getCartridgeMax(), (int)3);
            boolean removedGroup = this.restClient.removeEntity("/api/cartridgeGroups", "G1-sample-applications-test", "cartridgeGroup");
            Assert.assertFalse((boolean)removedGroup);
            boolean removedAuto = this.restClient.removeEntity("/api/autoscalingPolicies", autoscalingPolicyId, "autoscalingPolicy");
            Assert.assertFalse((boolean)removedAuto);
            boolean removedNet = this.restClient.removeEntity("/api/networkPartitions", "network-partition-sample-applications-test-1", "networkPartition");
            Assert.assertFalse((boolean)removedNet);
            boolean removedDep = this.restClient.removeEntity("/api/deploymentPolicies", "deployment-policy-sample-applications-test", "deploymentPolicy");
            Assert.assertFalse((boolean)removedDep);
            boolean removed = this.restClient.removeEntity("/api/applications", "g-sc-G123-1-sample-applications-test", "application");
            Assert.assertTrue((boolean)removed);
            ApplicationBean beanRemoved = (ApplicationBean)this.restClient.getEntity("/api/applications", "g-sc-G123-1-sample-applications-test", ApplicationBean.class, "application");
            Assert.assertNull((Object)beanRemoved);
            removedGroup = this.restClient.removeEntity("/api/cartridgeGroups", "G1-sample-applications-test", "cartridgeGroup");
            Assert.assertEquals((boolean)removedGroup, (boolean)true);
            boolean removedC1 = this.restClient.removeEntity("/api/cartridges", "c1-sample-applications-test", "cartridge");
            Assert.assertEquals((boolean)removedC1, (boolean)true);
            boolean removedC2 = this.restClient.removeEntity("/api/cartridges", "c2-sample-applications-test", "cartridge");
            Assert.assertEquals((boolean)removedC2, (boolean)true);
            boolean removedC3 = this.restClient.removeEntity("/api/cartridges", "c3-sample-applications-test", "cartridge");
            Assert.assertEquals((boolean)removedC3, (boolean)true);
            removedAuto = this.restClient.removeEntity("/api/autoscalingPolicies", autoscalingPolicyId, "autoscalingPolicy");
            Assert.assertEquals((boolean)removedAuto, (boolean)true);
            removedDep = this.restClient.removeEntity("/api/deploymentPolicies", "deployment-policy-sample-applications-test", "deploymentPolicy");
            Assert.assertEquals((boolean)removedDep, (boolean)true);
            removedNet = this.restClient.removeEntity("/api/networkPartitions", "network-partition-sample-applications-test-1", "networkPartition");
            Assert.assertEquals((boolean)removedNet, (boolean)true);
            boolean removedN2 = this.restClient.removeEntity("/api/networkPartitions", "network-partition-sample-applications-test-2", "networkPartition");
            Assert.assertEquals((String)String.format("[Network partition] network-partition-sample-applications-test-2 could not be removed for [application] g-sc-G123-1-sample-applications-test", new Object[0]), (boolean)removedN2, (boolean)true);
            log.info((Object)"-------------------------------Ended application test case-------------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling application test case", (Throwable)e);
            Assert.assertTrue((String)"An error occurred while handling application test case", (boolean)false);
        }
    }

    @Test(alwaysRun=true, description="List applications")
    public void testApplicationList() {
        log.info((Object)"-------------------------------Started application list test case-------------------------------");
        try {
            String autoscalingPolicyId = "autoscaling-policy-sample-applications-test";
            boolean addedScalingPolicy = this.restClient.addEntity("/sample-applications-test/autoscaling-policies//" + autoscalingPolicyId + ".json", "/api/autoscalingPolicies", "autoscalingPolicy");
            Assert.assertEquals((boolean)addedScalingPolicy, (boolean)true);
            boolean addedC1 = this.restClient.addEntity("/sample-applications-test/cartridges/mock//c1-sample-applications-test.json", "/api/cartridges", "cartridge");
            Assert.assertEquals((boolean)addedC1, (boolean)true);
            boolean addedC2 = this.restClient.addEntity("/sample-applications-test/cartridges/mock//c2-sample-applications-test.json", "/api/cartridges", "cartridge");
            Assert.assertEquals((boolean)addedC2, (boolean)true);
            boolean addedC3 = this.restClient.addEntity("/sample-applications-test/cartridges/mock//c3-sample-applications-test.json", "/api/cartridges", "cartridge");
            Assert.assertEquals((boolean)addedC3, (boolean)true);
            boolean addedG1 = this.restClient.addEntity("/sample-applications-test/cartridges-groups//cartrdige-nested-sample-applications-test.json", "/api/cartridgeGroups", "cartridgeGroup");
            Assert.assertEquals((boolean)addedG1, (boolean)true);
            CartridgeGroupBean beanG1 = (CartridgeGroupBean)this.restClient.getEntity("/api/cartridgeGroups", "G1-sample-applications-test", CartridgeGroupBean.class, "cartridgeGroup");
            Assert.assertEquals((String)beanG1.getName(), (String)"G1-sample-applications-test");
            boolean addedN1 = this.restClient.addEntity("/sample-applications-test/network-partitions/mock//network-partition-sample-applications-test-1.json", "/api/networkPartitions", "networkPartition");
            Assert.assertEquals((boolean)addedN1, (boolean)true);
            boolean addedN2 = this.restClient.addEntity("/sample-applications-test/network-partitions/mock//network-partition-sample-applications-test-2.json", "/api/networkPartitions", "networkPartition");
            Assert.assertEquals((boolean)addedN2, (boolean)true);
            boolean addedDep = this.restClient.addEntity("/sample-applications-test/deployment-policies//deployment-policy-sample-applications-test.json", "/api/deploymentPolicies", "deploymentPolicy");
            Assert.assertEquals((boolean)addedDep, (boolean)true);
            String app1 = "sample-applications-test-1";
            String app2 = "sample-applications-test-2";
            boolean added = this.restClient.addEntity("/sample-applications-test/applications//" + app1 + ".json", "/api/applications", "application");
            Assert.assertEquals((boolean)added, (boolean)true);
            added = this.restClient.addEntity("/sample-applications-test/applications//" + app2 + ".json", "/api/applications", "application");
            Assert.assertEquals((boolean)added, (boolean)true);
            Type listType = new TypeToken<ArrayList<ApplicationBean>>(){}.getType();
            List applicationList = (List)this.restClient.listEntity("/api/applications", listType, "application");
            Assert.assertTrue((applicationList.size() >= 2 ? 1 : 0) != 0);
            ApplicationBean bean1 = null;
            for (ApplicationBean applicationBean : applicationList) {
                if (!applicationBean.getApplicationId().equals(app1)) continue;
                bean1 = applicationBean;
            }
            Assert.assertNotNull(bean1);
            ApplicationBean bean2 = null;
            for (ApplicationBean applicationBean : applicationList) {
                if (!applicationBean.getApplicationId().equals(app2)) continue;
                bean2 = applicationBean;
            }
            Assert.assertNotNull(bean2);
            boolean removed = this.restClient.removeEntity("/api/applications", app1, "application");
            Assert.assertTrue((boolean)removed);
            ApplicationBean beanRemoved = (ApplicationBean)this.restClient.getEntity("/api/applications", app1, ApplicationBean.class, "application");
            Assert.assertNull((Object)beanRemoved);
            boolean removedGroup = this.restClient.removeEntity("/api/cartridgeGroups", "G1-sample-applications-test", "cartridgeGroup");
            Assert.assertFalse((boolean)removedGroup);
            boolean removedAuto = this.restClient.removeEntity("/api/autoscalingPolicies", autoscalingPolicyId, "autoscalingPolicy");
            Assert.assertFalse((boolean)removedAuto);
            boolean removedNet = this.restClient.removeEntity("/api/networkPartitions", "network-partition-sample-applications-test-1", "networkPartition");
            Assert.assertFalse((boolean)removedNet);
            boolean removedDep = this.restClient.removeEntity("/api/deploymentPolicies", "deployment-policy-sample-applications-test", "deploymentPolicy");
            Assert.assertFalse((boolean)removedDep);
            removed = this.restClient.removeEntity("/api/applications", app2, "application");
            Assert.assertTrue((boolean)removed);
            beanRemoved = (ApplicationBean)this.restClient.getEntity("/api/applications", app2, ApplicationBean.class, "application");
            Assert.assertNull((Object)beanRemoved);
            removedGroup = this.restClient.removeEntity("/api/cartridgeGroups", "G1-sample-applications-test", "cartridgeGroup");
            Assert.assertEquals((boolean)removedGroup, (boolean)true);
            boolean removedC1 = this.restClient.removeEntity("/api/cartridges", "c1-sample-applications-test", "cartridge");
            Assert.assertEquals((boolean)removedC1, (boolean)true);
            boolean removedC2 = this.restClient.removeEntity("/api/cartridges", "c2-sample-applications-test", "cartridge");
            Assert.assertEquals((boolean)removedC2, (boolean)true);
            boolean removedC3 = this.restClient.removeEntity("/api/cartridges", "c3-sample-applications-test", "cartridge");
            Assert.assertEquals((boolean)removedC3, (boolean)true);
            removedAuto = this.restClient.removeEntity("/api/autoscalingPolicies", autoscalingPolicyId, "autoscalingPolicy");
            Assert.assertEquals((boolean)removedAuto, (boolean)true);
            removedDep = this.restClient.removeEntity("/api/deploymentPolicies", "deployment-policy-sample-applications-test", "deploymentPolicy");
            Assert.assertEquals((boolean)removedDep, (boolean)true);
            removedNet = this.restClient.removeEntity("/api/networkPartitions", "network-partition-sample-applications-test-1", "networkPartition");
            Assert.assertEquals((boolean)removedNet, (boolean)true);
            boolean removedN2 = this.restClient.removeEntity("/api/networkPartitions", "network-partition-sample-applications-test-2", "networkPartition");
            Assert.assertEquals((String)"[Network partition] network-partition-sample-applications-test-2 could not be removed for [application] g-sc-G123-1-sample-applications-test", (boolean)removedN2, (boolean)true);
            log.info((Object)"-------------------------------Ended application test case-------------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling application test case", (Throwable)e);
            Assert.assertTrue((String)"An error occurred while handling application test case", (boolean)false);
        }
    }
}

