/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests.group;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.beans.cartridge.CartridgeGroupBean;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.ppaas.integration.tests.PPaaSTestServerManager;

public class CartridgeGroupTest
extends PPaaSTestServerManager {
    private static final Log log = LogFactory.getLog(CartridgeGroupTest.class);
    private static final String RESOURCES_PATH = "/cartridge-group-test";

    @BeforeClass(alwaysRun=true)
    public void testInit() throws Exception {
        super.init();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanup();
    }

    @Test(alwaysRun=true, description="Deploy cartridge group", priority=1, timeOut=300000L)
    public void testCartridgeGroup() {
        try {
            log.info((Object)"-------------------------Started Cartridge group test case-------------------------");
            boolean addedC1 = this.restClient.addEntity("/cartridge-group-test/cartridges/mock//c4-cartridge-group-test.json", "/api/cartridges", "cartridge");
            Assert.assertTrue((String)String.format("Cartridge did not added: [cartridge-name] %s", "c4-cartridge-group-test"), (boolean)addedC1);
            boolean addedC2 = this.restClient.addEntity("/cartridge-group-test/cartridges/mock//c5-cartridge-group-test.json", "/api/cartridges", "cartridge");
            Assert.assertTrue((String)String.format("Cartridge did not added: [cartridge-name] %s", "c5-cartridge-group-test"), (boolean)addedC2);
            boolean addedC3 = this.restClient.addEntity("/cartridge-group-test/cartridges/mock//c6-cartridge-group-test.json", "/api/cartridges", "cartridge");
            Assert.assertTrue((String)String.format("Cartridge did not added: [cartridge-name] %s", "c6-cartridge-group-test"), (boolean)addedC3);
            boolean added = this.restClient.addEntity("/cartridge-group-test/cartridges-groups//g4-g5-g6-cartridge-group-test.json", "/api/cartridgeGroups", "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge Group did not added: [cartridge-group-name] %s", "g4-g5-g6-cartridge-group-test"), (boolean)added);
            CartridgeGroupBean bean = (CartridgeGroupBean)this.restClient.getEntity("/api/cartridgeGroups", "G4-cartridge-group-test", CartridgeGroupBean.class, "cartridgeGroup");
            Assert.assertEquals((String)String.format("Cartridge Group name did not match: [cartridge-group-name] %s", "g4-g5-g6-cartridge-group-test.json"), (String)bean.getName(), (String)"G4-cartridge-group-test");
            boolean updated = this.restClient.updateEntity("/cartridge-group-test/cartridges-groups//g4-g5-g6-cartridge-group-test-v1.json", "/api/cartridgeGroups", "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge Group did not updated: [cartridge-group-name] %s", "g4-g5-g6-cartridge-group-test"), (boolean)updated);
            CartridgeGroupBean updatedBean = (CartridgeGroupBean)this.restClient.getEntity("/api/cartridgeGroups", "G4-cartridge-group-test", CartridgeGroupBean.class, "cartridgeGroup");
            Assert.assertEquals((String)String.format("Updated Cartridge Group didn't match: [cartridge-group-name] %s", "g4-g5-g6-cartridge-group-test"), (String)updatedBean.getName(), (String)"G4-cartridge-group-test");
            boolean removedC1 = this.restClient.removeEntity("/api/cartridges", "c4-cartridge-group-test", "cartridgeGroup");
            Assert.assertFalse((String)String.format("Cartridge can be removed while it is used in cartridge group: [cartridge-name] %s", "c4-cartridge-group-test"), (boolean)removedC1);
            boolean removedC2 = this.restClient.removeEntity("/api/cartridges", "c5-cartridge-group-test", "cartridgeGroup");
            Assert.assertFalse((String)String.format("Cartridge can be removed while it is used in cartridge group: [cartridge-name] %s", "c5-cartridge-group-test"), (boolean)removedC2);
            boolean removedC3 = this.restClient.removeEntity("/api/cartridges", "c6-cartridge-group-test", "cartridgeGroup");
            Assert.assertFalse((String)String.format("Cartridge can be removed while it is used in cartridge group: [cartridge-name] %s", "c6-cartridge-group-test"), (boolean)removedC3);
            boolean removed = this.restClient.removeEntity("/api/cartridgeGroups", "G4-cartridge-group-test", "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge Group did not removed: [cartridge-group-name] %s", "g4-g5-g6-cartridge-group-test"), (boolean)removed);
            CartridgeGroupBean beanRemoved = (CartridgeGroupBean)this.restClient.getEntity("/api/cartridgeGroups", "G4-cartridge-group-test", CartridgeGroupBean.class, "cartridgeGroup");
            Assert.assertEquals((String)String.format("Cartridge Group did not removed completely: [cartridge-group-name] %s", "g4-g5-g6-cartridge-group-test"), (Object)beanRemoved, null);
            removedC1 = this.restClient.removeEntity("/api/cartridges", "c4-cartridge-group-test", "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge can not be removed : [cartridge-name] %s", "c4-cartridge-group-test"), (boolean)removedC1);
            removedC2 = this.restClient.removeEntity("/api/cartridges", "c5-cartridge-group-test", "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge can not be removed : [cartridge-name] %s", "c5-cartridge-group-test"), (boolean)removedC2);
            removedC3 = this.restClient.removeEntity("/api/cartridges", "c6-cartridge-group-test", "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge can not be removed : [cartridge-name] %s", "c6-cartridge-group-test"), (boolean)removedC3);
            log.info((Object)"-------------------------Ended Cartridge group test case-------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling Cartridge group test case", (Throwable)e);
            Assert.assertFalse((String)"An error occurred while handling Cartridge group test case", (boolean)false);
        }
    }

    @Test(alwaysRun=true, description="Deploy cartridge group 2", priority=1, timeOut=300000L)
    public void testCartridgeGroupList() {
        try {
            log.info((Object)"-------------------------Started Cartridge group list test case-------------------------");
            boolean addedC1 = this.restClient.addEntity("/cartridge-group-test/cartridges/mock//c4-cartridge-group-test.json", "/api/cartridges", "cartridge");
            Assert.assertTrue((String)String.format("Cartridge did not added: [cartridge-name] %s", "c4-cartridge-group-test"), (boolean)addedC1);
            boolean addedC2 = this.restClient.addEntity("/cartridge-group-test/cartridges/mock//c5-cartridge-group-test.json", "/api/cartridges", "cartridge");
            Assert.assertTrue((String)String.format("Cartridge did not added: [cartridge-name] %s", "c5-cartridge-group-test"), (boolean)addedC2);
            boolean addedC3 = this.restClient.addEntity("/cartridge-group-test/cartridges/mock//c6-cartridge-group-test.json", "/api/cartridges", "cartridge");
            Assert.assertTrue((String)String.format("Cartridge did not added: [cartridge-name] %s", "c6-cartridge-group-test"), (boolean)addedC3);
            String group1 = "group-1-cartridge-group-test";
            String group2 = "group-2-cartridge-group-test";
            boolean added = this.restClient.addEntity("/cartridge-group-test/cartridges-groups//" + group1 + ".json", "/api/cartridgeGroups", "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge Group did not added: [cartridge-group-name] %s", group1), (boolean)added);
            added = this.restClient.addEntity("/cartridge-group-test/cartridges-groups//" + group2 + ".json", "/api/cartridgeGroups", "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge Group did not added: [cartridge-group-name] %s", group1), (boolean)added);
            Type listType = new TypeToken<ArrayList<CartridgeGroupBean>>(){}.getType();
            List cartridgeGroupList = (List)this.restClient.listEntity("/api/cartridgeGroups", listType, "cartridgeGroup");
            Assert.assertTrue((cartridgeGroupList.size() >= 2 ? 1 : 0) != 0);
            CartridgeGroupBean bean1 = null;
            for (CartridgeGroupBean cartridgeGroupBean : cartridgeGroupList) {
                if (!cartridgeGroupBean.getName().equals(group1)) continue;
                bean1 = cartridgeGroupBean;
            }
            Assert.assertNotNull(bean1);
            CartridgeGroupBean bean2 = null;
            for (CartridgeGroupBean cartridgeGroupBean : cartridgeGroupList) {
                if (!cartridgeGroupBean.getName().equals(group2)) continue;
                bean2 = cartridgeGroupBean;
            }
            Assert.assertNotNull(bean2);
            boolean removed = this.restClient.removeEntity("/api/cartridgeGroups", group1, "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge Group did not removed: [cartridge-group-name] %s", group1), (boolean)removed);
            CartridgeGroupBean beanRemoved = (CartridgeGroupBean)this.restClient.getEntity("/api/cartridgeGroups", group1, CartridgeGroupBean.class, "cartridgeGroup");
            Assert.assertNull((String)String.format("Cartridge Group did not removed completely: [cartridge-group-name] %s", group1), (Object)beanRemoved);
            boolean removedC1 = this.restClient.removeEntity("/api/cartridges", "c4-cartridge-group-test", "cartridgeGroup");
            Assert.assertFalse((String)String.format("Cartridge can be removed while it is used in cartridge group: [cartridge-name] %s", "c4-cartridge-group-test"), (boolean)removedC1);
            boolean removedC2 = this.restClient.removeEntity("/api/cartridges", "c5-cartridge-group-test", "cartridgeGroup");
            Assert.assertFalse((String)String.format("Cartridge can be removed while it is used in cartridge group: [cartridge-name] %s", "c5-cartridge-group-test"), (boolean)removedC2);
            boolean removedC3 = this.restClient.removeEntity("/api/cartridges", "c6-cartridge-group-test", "cartridgeGroup");
            Assert.assertFalse((String)String.format("Cartridge can be removed while it is used in cartridge group: [cartridge-name] %s", "c6-cartridge-group-test"), (boolean)removedC3);
            removed = this.restClient.removeEntity("/api/cartridgeGroups", group2, "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge Group did not removed: [cartridge-group-name] %s", group2), (boolean)removed);
            beanRemoved = (CartridgeGroupBean)this.restClient.getEntity("/api/cartridgeGroups", group2, CartridgeGroupBean.class, "cartridgeGroup");
            Assert.assertNull((String)String.format("Cartridge Group did not removed completely: [cartridge-group-name] %s", group2), (Object)beanRemoved);
            removedC1 = this.restClient.removeEntity("/api/cartridges", "c4-cartridge-group-test", "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge can not be removed : [cartridge-name] %s", "c4-cartridge-group-test"), (boolean)removedC1);
            removedC2 = this.restClient.removeEntity("/api/cartridges", "c5-cartridge-group-test", "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge can not be removed : [cartridge-name] %s", "c5-cartridge-group-test"), (boolean)removedC2);
            removedC3 = this.restClient.removeEntity("/api/cartridges", "c6-cartridge-group-test", "cartridgeGroup");
            Assert.assertTrue((String)String.format("Cartridge can not be removed : [cartridge-name] %s", "c6-cartridge-group-test"), (boolean)removedC3);
            log.info((Object)"-------------------------Ended Cartridge group list test case-------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling Cartridge list group test case", (Throwable)e);
            Assert.assertFalse((String)"An error occurred while handling Cartridge list group test case", (boolean)false);
        }
    }
}

