/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests.group;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.beans.PropertyBean;
import org.apache.stratos.common.beans.cartridge.CartridgeBean;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.ppaas.integration.tests.PPaaSTestServerManager;

public class CartridgeTest
extends PPaaSTestServerManager {
    private static final Log log = LogFactory.getLog(CartridgeTest.class);
    private static final String RESOURCES_PATH = "/cartridge-test";

    @BeforeClass(alwaysRun=true)
    public void testInit() throws Exception {
        super.init();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanup();
    }

    @Test(alwaysRun=true, description="Deploy cartridge", priority=1, timeOut=300000L)
    public void testCartridge() {
        log.info((Object)"--------------------Started Cartridge test case-----------------------------");
        try {
            String cartridgeType = "c0-cartridge-test";
            boolean added = this.restClient.addEntity("/cartridge-test/cartridges/mock//" + cartridgeType + ".json", "/api/cartridges", "cartridge");
            Assert.assertTrue((boolean)added);
            CartridgeBean bean = (CartridgeBean)this.restClient.getEntity("/api/cartridges", cartridgeType, CartridgeBean.class, "cartridge");
            Assert.assertEquals((String)bean.getCategory(), (String)"Application");
            Assert.assertEquals((String)bean.getHost(), (String)"qmog.cisco.com");
            for (PropertyBean property : bean.getProperty()) {
                if (property.getName().equals("payload_parameter.CEP_IP")) {
                    Assert.assertEquals((String)property.getValue(), (String)"octl.qmog.cisco.com");
                    continue;
                }
                if (property.getName().equals("payload_parameter.CEP_ADMIN_PASSWORD")) {
                    Assert.assertEquals((String)property.getValue(), (String)"admin");
                    continue;
                }
                if (property.getName().equals("payload_parameter.MONITORING_SERVER_IP")) {
                    Assert.assertEquals((String)property.getValue(), (String)"octl.qmog.cisco.com");
                    continue;
                }
                if (property.getName().equals("payload_parameter.QTCM_NETWORK_COUNT")) {
                    Assert.assertEquals((String)property.getValue(), (String)"1");
                    continue;
                }
                if (property.getName().equals("payload_parameter.MONITORING_SERVER_ADMIN_PASSWORD")) {
                    Assert.assertEquals((String)property.getValue(), (String)"admin");
                    continue;
                }
                if (property.getName().equals("payload_parameter.QTCM_DNS_SEGMENT")) {
                    Assert.assertEquals((String)property.getValue(), (String)"test");
                    continue;
                }
                if (property.getName().equals("payload_parameter.MONITORING_SERVER_SECURE_PORT")) {
                    Assert.assertEquals((String)property.getValue(), (String)"7711");
                    continue;
                }
                if (property.getName().equals("payload_parameter.MONITORING_SERVER_PORT")) {
                    Assert.assertEquals((String)property.getValue(), (String)"7611");
                    continue;
                }
                if (property.getName().equals("payload_parameter.CEP_PORT")) {
                    Assert.assertEquals((String)property.getValue(), (String)"7611");
                    continue;
                }
                if (!property.getName().equals("payload_parameter.MB_PORT")) continue;
                Assert.assertEquals((String)property.getValue(), (String)"61616");
            }
            boolean updated = this.restClient.updateEntity("/cartridge-test/cartridges/mock//" + cartridgeType + "-v1.json", "/api/cartridges", "cartridge");
            Assert.assertTrue((boolean)updated);
            CartridgeBean updatedBean = (CartridgeBean)this.restClient.getEntity("/api/cartridges", cartridgeType, CartridgeBean.class, "cartridge");
            Assert.assertEquals((String)updatedBean.getType(), (String)"c0-cartridge-test");
            Assert.assertEquals((String)updatedBean.getCategory(), (String)"Data");
            Assert.assertEquals((String)updatedBean.getHost(), (String)"qmog.cisco.com12");
            for (PropertyBean property : updatedBean.getProperty()) {
                if (property.getName().equals("payload_parameter.CEP_IP")) {
                    Assert.assertEquals((String)property.getValue(), (String)"octl.qmog.cisco.com123");
                    continue;
                }
                if (property.getName().equals("payload_parameter.CEP_ADMIN_PASSWORD")) {
                    Assert.assertEquals((String)property.getValue(), (String)"admin123");
                    continue;
                }
                if (property.getName().equals("payload_parameter.MONITORING_SERVER_IP")) {
                    Assert.assertEquals((String)property.getValue(), (String)"octl.qmog.cisco.com123");
                    continue;
                }
                if (property.getName().equals("payload_parameter.QTCM_NETWORK_COUNT")) {
                    Assert.assertEquals((String)property.getValue(), (String)"3");
                    continue;
                }
                if (property.getName().equals("payload_parameter.MONITORING_SERVER_ADMIN_PASSWORD")) {
                    Assert.assertEquals((String)property.getValue(), (String)"admin123");
                    continue;
                }
                if (property.getName().equals("payload_parameter.QTCM_DNS_SEGMENT")) {
                    Assert.assertEquals((String)property.getValue(), (String)"test123");
                    continue;
                }
                if (property.getName().equals("payload_parameter.MONITORING_SERVER_SECURE_PORT")) {
                    Assert.assertEquals((String)property.getValue(), (String)"7712");
                    continue;
                }
                if (property.getName().equals("payload_parameter.MONITORING_SERVER_PORT")) {
                    Assert.assertEquals((String)property.getValue(), (String)"7612");
                    continue;
                }
                if (property.getName().equals("payload_parameter.CEP_PORT")) {
                    Assert.assertEquals((String)property.getValue(), (String)"7612");
                    continue;
                }
                if (!property.getName().equals("payload_parameter.MB_PORT")) continue;
                Assert.assertEquals((String)property.getValue(), (String)"61617");
            }
            boolean removed = this.restClient.removeEntity("/api/cartridges", cartridgeType, "cartridge");
            Assert.assertTrue((boolean)removed);
            CartridgeBean beanRemoved = (CartridgeBean)this.restClient.getEntity("/api/cartridges", cartridgeType, CartridgeBean.class, "cartridge");
            Assert.assertNull((Object)beanRemoved);
            log.info((Object)"---------------------------Ended Cartridge test case-------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling RESTConstants.CARTRIDGES_PATH", (Throwable)e);
            Assert.assertTrue((String)"An error occurred while handling RESTConstants.CARTRIDGES_PATH", (boolean)false);
        }
    }

    @Test(alwaysRun=true, description="Cartridge list", priority=1, timeOut=300000L)
    public void testCartridgeList() {
        log.info((Object)"--------------------Started Cartridge list test case-----------------------------");
        try {
            String cartridgeType1 = "c1-cartridge-test";
            String cartridgeType2 = "c2-cartridge-test";
            boolean added1 = this.restClient.addEntity("/cartridge-test/cartridges/mock//" + cartridgeType1 + ".json", "/api/cartridges", "cartridge");
            Assert.assertTrue((boolean)added1);
            boolean added2 = this.restClient.addEntity("/cartridge-test/cartridges/mock//" + cartridgeType2 + ".json", "/api/cartridges", "cartridge");
            Assert.assertTrue((boolean)added2);
            Type listType = new TypeToken<ArrayList<CartridgeBean>>(){}.getType();
            List cartridgeList = (List)this.restClient.listEntity("/api/cartridges", listType, "cartridge");
            Assert.assertTrue((cartridgeList.size() >= 2 ? 1 : 0) != 0);
            CartridgeBean bean1 = null;
            for (CartridgeBean cartridgeBean : cartridgeList) {
                if (!cartridgeBean.getType().equals(cartridgeType1)) continue;
                bean1 = cartridgeBean;
            }
            Assert.assertNotNull(bean1);
            CartridgeBean bean2 = null;
            for (CartridgeBean cartridgeBean : cartridgeList) {
                if (!cartridgeBean.getType().equals(cartridgeType1)) continue;
                bean2 = cartridgeBean;
            }
            Assert.assertNotNull(bean2);
            boolean removed = this.restClient.removeEntity("/api/cartridges", cartridgeType1, "cartridge");
            Assert.assertTrue((boolean)removed);
            CartridgeBean beanRemoved = (CartridgeBean)this.restClient.getEntity("/api/cartridges", cartridgeType1, CartridgeBean.class, "cartridge");
            Assert.assertEquals((Object)beanRemoved, null);
            removed = this.restClient.removeEntity("/api/cartridges", cartridgeType2, "cartridge");
            Assert.assertTrue((boolean)removed);
            beanRemoved = (CartridgeBean)this.restClient.getEntity("/api/cartridges", cartridgeType2, CartridgeBean.class, "cartridge");
            Assert.assertNull((Object)beanRemoved);
            log.info((Object)"---------------------------Ended Cartridge list test case-------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling Cartridges list", (Throwable)e);
            Assert.assertTrue((String)"An error occurred while handling Cartridges list", (boolean)false);
        }
    }
}

