/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests.policies;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.beans.PropertyBean;
import org.apache.stratos.common.beans.partition.NetworkPartitionBean;
import org.apache.stratos.common.beans.policy.deployment.ApplicationPolicyBean;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.ppaas.integration.tests.PPaaSTestServerManager;

public class ApplicationPolicyTest
extends PPaaSTestServerManager {
    private static final Log log = LogFactory.getLog(ApplicationPolicyTest.class);
    private static final String RESOURCES_PATH = "/application-policy-test";

    @BeforeClass(alwaysRun=true)
    public void testInit() throws Exception {
        super.init();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanup();
    }

    @Test(alwaysRun=true, description="Deploy application policy", priority=1, timeOut=300000L)
    public void testApplicationPolicy() {
        try {
            String applicationPolicyId = "application-policy-application-policy-test";
            log.info((Object)"-------------------------Started Application policy test case-------------------------");
            boolean addedN1 = this.restClient.addEntity("/application-policy-test/network-partitions/mock//network-partition-application-policy-test-1.json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)addedN1);
            boolean addedN2 = this.restClient.addEntity("/application-policy-test/network-partitions/mock//network-partition-application-policy-test-2.json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)addedN2);
            boolean addedDep = this.restClient.addEntity("/application-policy-test/application-policies//" + applicationPolicyId + ".json", "/api/applicationPolicies", "applicationPolicy");
            Assert.assertTrue((boolean)addedDep);
            ApplicationPolicyBean bean = (ApplicationPolicyBean)this.restClient.getEntity("/api/applicationPolicies", applicationPolicyId, ApplicationPolicyBean.class, "applicationPolicy");
            Assert.assertEquals((String)bean.getId(), (String)applicationPolicyId);
            Assert.assertEquals((String)String.format("The expected algorithm %s is not found in %s", "one-after-another", applicationPolicyId), (String)bean.getAlgorithm(), (String)"one-after-another");
            Assert.assertEquals((String)String.format("The expected id %s is not found", applicationPolicyId), (String)bean.getId(), (String)applicationPolicyId);
            Assert.assertEquals((String)String.format("The expected networkpartitions size %s is not found in %s", 2, applicationPolicyId), (int)bean.getNetworkPartitions().length, (int)2);
            Assert.assertEquals((String)String.format("The first network partition is not %s in %s", "network-partition-application-policy-test-1", applicationPolicyId), (String)bean.getNetworkPartitions()[0], (String)"network-partition-application-policy-test-1");
            Assert.assertEquals((String)String.format("The Second network partition is not %s in %s", "network-partition-application-policy-test-2", applicationPolicyId), (String)bean.getNetworkPartitions()[1], (String)"network-partition-application-policy-test-2");
            boolean algoFound = false;
            for (PropertyBean propertyBean : bean.getProperties()) {
                if (!propertyBean.getName().equals("networkPartitionGroups")) continue;
                Assert.assertEquals((String)String.format("The networkPartitionGroups algorithm %s is not found in %s", "network-partition-application-policy-test-1,network-partition-application-policy-test-2", applicationPolicyId), (String)propertyBean.getValue(), (String)"network-partition-application-policy-test-1,network-partition-application-policy-test-2");
                algoFound = true;
            }
            if (!algoFound) {
                Assert.assertNull((Object)String.format("The networkPartitionGroups property is not found in %s", applicationPolicyId));
            }
            boolean removedNet = this.restClient.removeEntity("/api/networkPartitions", "network-partition-application-policy-test-1", "networkPartition");
            Assert.assertFalse((boolean)removedNet);
            boolean removedDep = this.restClient.removeEntity("/api/applicationPolicies", applicationPolicyId, "applicationPolicy");
            Assert.assertTrue((boolean)removedDep);
            ApplicationPolicyBean beanRemovedDep = (ApplicationPolicyBean)this.restClient.getEntity("/api/applicationPolicies", applicationPolicyId, ApplicationPolicyBean.class, "applicationPolicy");
            Assert.assertNull((Object)beanRemovedDep);
            boolean removedN1 = this.restClient.removeEntity("/api/networkPartitions", "network-partition-application-policy-test-1", "networkPartition");
            Assert.assertTrue((boolean)removedN1);
            NetworkPartitionBean beanRemovedN1 = (NetworkPartitionBean)this.restClient.getEntity("/api/networkPartitions", "network-partition-application-policy-test-1", NetworkPartitionBean.class, "networkPartition");
            Assert.assertNull((Object)beanRemovedN1);
            boolean removedN2 = this.restClient.removeEntity("/api/networkPartitions", "network-partition-application-policy-test-2", "networkPartition");
            Assert.assertTrue((boolean)removedN2);
            NetworkPartitionBean beanRemovedN2 = (NetworkPartitionBean)this.restClient.getEntity("/api/networkPartitions", "network-partition-application-policy-test-2", NetworkPartitionBean.class, "networkPartition");
            Assert.assertNull((Object)beanRemovedN2);
            log.info((Object)"-------------------------Ended deployment policy test case-------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling deployment policy", (Throwable)e);
            Assert.assertTrue((String)"An error occurred while handling deployment policy", (boolean)false);
        }
    }

    @Test(alwaysRun=true, description="Deploy application policy 2", timeOut=300000L)
    public void testApplicationPolicyList() {
        try {
            String applicationPolicyId1 = "application-policy-application-policy-test-1";
            String applicationPolicyId2 = "application-policy-application-policy-test-2";
            log.info((Object)"-------------------------Started Application policy list test case-------------------------");
            boolean addedN1 = this.restClient.addEntity("/application-policy-test/network-partitions/mock//network-partition-application-policy-test-1.json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)addedN1);
            boolean addedN2 = this.restClient.addEntity("/application-policy-test/network-partitions/mock//network-partition-application-policy-test-2.json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)addedN2);
            boolean addedDep = this.restClient.addEntity("/application-policy-test/application-policies//" + applicationPolicyId1 + ".json", "/api/applicationPolicies", "applicationPolicy");
            Assert.assertTrue((boolean)addedDep);
            addedDep = this.restClient.addEntity("/application-policy-test/application-policies//" + applicationPolicyId2 + ".json", "/api/applicationPolicies", "applicationPolicy");
            Assert.assertTrue((boolean)addedDep);
            Type listType = new TypeToken<ArrayList<ApplicationPolicyBean>>(){}.getType();
            List applicationPolicyList = (List)this.restClient.listEntity("/api/applicationPolicies", listType, "applicationPolicy");
            Assert.assertTrue((applicationPolicyList.size() >= 2 ? 1 : 0) != 0);
            ApplicationPolicyBean bean1 = null;
            for (ApplicationPolicyBean applicationPolicyBean : applicationPolicyList) {
                if (!applicationPolicyBean.getId().equals(applicationPolicyId1)) continue;
                bean1 = applicationPolicyBean;
            }
            Assert.assertNotNull(bean1);
            ApplicationPolicyBean bean2 = null;
            for (ApplicationPolicyBean applicationPolicyBean : applicationPolicyList) {
                if (!applicationPolicyBean.getId().equals(applicationPolicyId2)) continue;
                bean2 = applicationPolicyBean;
            }
            Assert.assertNotNull(bean2);
            boolean removedDep = this.restClient.removeEntity("/api/applicationPolicies", applicationPolicyId1, "applicationPolicy");
            Assert.assertTrue((boolean)removedDep);
            ApplicationPolicyBean beanRemovedDep = (ApplicationPolicyBean)this.restClient.getEntity("/api/applicationPolicies", applicationPolicyId1, ApplicationPolicyBean.class, "applicationPolicy");
            Assert.assertNull((Object)beanRemovedDep);
            boolean removedNet = this.restClient.removeEntity("/api/networkPartitions", "network-partition-application-policy-test-1", "networkPartition");
            Assert.assertFalse((boolean)removedNet);
            removedDep = this.restClient.removeEntity("/api/applicationPolicies", applicationPolicyId2, "applicationPolicy");
            Assert.assertTrue((boolean)removedDep);
            beanRemovedDep = (ApplicationPolicyBean)this.restClient.getEntity("/api/applicationPolicies", applicationPolicyId2, ApplicationPolicyBean.class, "applicationPolicy");
            Assert.assertNull((Object)beanRemovedDep);
            boolean removedN1 = this.restClient.removeEntity("/api/networkPartitions", "network-partition-application-policy-test-1", "networkPartition");
            Assert.assertTrue((boolean)removedN1);
            NetworkPartitionBean beanRemovedN1 = (NetworkPartitionBean)this.restClient.getEntity("/api/networkPartitions", "network-partition-application-policy-test-1", NetworkPartitionBean.class, "networkPartition");
            Assert.assertNull((Object)beanRemovedN1);
            boolean removedN2 = this.restClient.removeEntity("/api/networkPartitions", "network-partition-application-policy-test-2", "networkPartition");
            Assert.assertTrue((boolean)removedN2);
            NetworkPartitionBean beanRemovedN2 = (NetworkPartitionBean)this.restClient.getEntity("/api/networkPartitions", "network-partition-application-policy-test-2", NetworkPartitionBean.class, "networkPartition");
            Assert.assertNull((Object)beanRemovedN2);
            log.info((Object)"-------------------------Ended deployment policy test case-------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling deployment policy", (Throwable)e);
            Assert.assertTrue((String)"An error occurred while handling deployment policy", (boolean)false);
        }
    }
}

