/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests.policies;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.beans.policy.autoscale.AutoscalePolicyBean;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.ppaas.integration.tests.PPaaSTestServerManager;

public class AutoscalingPolicyTest
extends PPaaSTestServerManager {
    private static final Log log = LogFactory.getLog(AutoscalingPolicyTest.class);
    private static final String RESOURCES_PATH = "/autoscaling-policy-test";

    @BeforeClass(alwaysRun=true)
    public void testInit() throws Exception {
        super.init();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanup();
    }

    @Test(alwaysRun=true, description="Deploy autoscaling policy", priority=1, timeOut=300000L)
    public void testAutoscalingPolicy() {
        log.info((Object)"-------------------------Started autoscaling policy test case-------------------------");
        String policyId = "autoscaling-policy-autoscaling-policy-test";
        try {
            boolean added = this.restClient.addEntity("/autoscaling-policy-test/autoscaling-policies//" + policyId + ".json", "/api/autoscalingPolicies", "autoscalingPolicy");
            Assert.assertTrue((String)String.format("Autoscaling policy did not added: [autoscaling-policy-id] %s", policyId), (boolean)added);
            AutoscalePolicyBean bean = (AutoscalePolicyBean)this.restClient.getEntity("/api/autoscalingPolicies", policyId, AutoscalePolicyBean.class, "autoscalingPolicy");
            Assert.assertEquals((String)String.format("[autoscaling-policy-id] %s is not correct", bean.getId()), (String)bean.getId(), (String)policyId);
            Assert.assertEquals((String)String.format("[autoscaling-policy-id] %s RIF is not correct", policyId), (double)bean.getLoadThresholds().getRequestsInFlight().getThreshold(), (double)35.0, (double)0.0);
            Assert.assertEquals((String)String.format("[autoscaling-policy-id] %s Memory is not correct", policyId), (double)bean.getLoadThresholds().getMemoryConsumption().getThreshold(), (double)45.0, (double)0.0);
            Assert.assertEquals((String)String.format("[autoscaling-policy-id] %s Load is not correct", policyId), (double)bean.getLoadThresholds().getLoadAverage().getThreshold(), (double)25.0, (double)0.0);
            boolean updated = this.restClient.updateEntity("/autoscaling-policy-test/autoscaling-policies//" + policyId + "-v1.json", "/api/autoscalingPolicies", "autoscalingPolicy");
            Assert.assertTrue((String)String.format("[autoscaling-policy-id] %s update failed", policyId), (boolean)updated);
            AutoscalePolicyBean updatedBean = (AutoscalePolicyBean)this.restClient.getEntity("/api/autoscalingPolicies", policyId, AutoscalePolicyBean.class, "autoscalingPolicy");
            Assert.assertEquals((String)String.format("[autoscaling-policy-id] %s RIF is not correct", policyId), (double)updatedBean.getLoadThresholds().getRequestsInFlight().getThreshold(), (double)30.0, (double)0.0);
            Assert.assertEquals((String)String.format("[autoscaling-policy-id] %s Load is not correct", policyId), (double)updatedBean.getLoadThresholds().getMemoryConsumption().getThreshold(), (double)40.0, (double)0.0);
            Assert.assertEquals((String)String.format("[autoscaling-policy-id] %s Memory is not correct", policyId), (double)updatedBean.getLoadThresholds().getLoadAverage().getThreshold(), (double)20.0, (double)0.0);
            boolean removed = this.restClient.removeEntity("/api/autoscalingPolicies", policyId, "autoscalingPolicy");
            Assert.assertTrue((String)String.format("[autoscaling-policy-id] %s couldn't be removed", policyId), (boolean)removed);
            AutoscalePolicyBean beanRemoved = (AutoscalePolicyBean)this.restClient.getEntity("/api/autoscalingPolicies", policyId, AutoscalePolicyBean.class, "autoscalingPolicy");
            Assert.assertNull((String)String.format("[autoscaling-policy-id] %s didn't get removed successfully", policyId), (Object)beanRemoved);
            log.info((Object)"-------------------------Ended autoscaling policy test case---------------------------");
        }
        catch (Exception e) {
            log.error((Object)("An error occurred while handling [autoscaling policy] " + policyId), (Throwable)e);
            Assert.assertTrue((String)("An error occurred while handling [autoscaling policy] " + policyId), (boolean)false);
        }
    }

    @Test(alwaysRun=true, description="Deploy autoscaling policy 2", timeOut=300000L)
    public void testAutoscalingPolicyList() {
        log.info((Object)"-------------------------Started autoscaling policy list test case-------------------------");
        String policyId1 = "autoscaling-policy-autoscaling-policy-test-1";
        String policyId2 = "autoscaling-policy-autoscaling-policy-test-2";
        try {
            boolean added = this.restClient.addEntity("/autoscaling-policy-test/autoscaling-policies//" + policyId1 + ".json", "/api/autoscalingPolicies", "autoscalingPolicy");
            Assert.assertTrue((String)String.format("Autoscaling policy did not added: [autoscaling-policy-id] %s", policyId1), (boolean)added);
            added = this.restClient.addEntity("/autoscaling-policy-test/autoscaling-policies//" + policyId2 + ".json", "/api/autoscalingPolicies", "autoscalingPolicy");
            Assert.assertTrue((String)String.format("Autoscaling policy did not added: [autoscaling-policy-id] %s", policyId2), (boolean)added);
            Type listType = new TypeToken<ArrayList<AutoscalePolicyBean>>(){}.getType();
            List autoscalingPolicyList = (List)this.restClient.listEntity("/api/autoscalingPolicies", listType, "autoscalingPolicy");
            Assert.assertTrue((autoscalingPolicyList.size() >= 2 ? 1 : 0) != 0);
            AutoscalePolicyBean bean1 = null;
            for (AutoscalePolicyBean autoscalePolicyBean : autoscalingPolicyList) {
                if (!autoscalePolicyBean.getId().equals(policyId1)) continue;
                bean1 = autoscalePolicyBean;
            }
            Assert.assertNotNull(bean1);
            AutoscalePolicyBean bean2 = null;
            for (AutoscalePolicyBean autoscalePolicyBean : autoscalingPolicyList) {
                if (!autoscalePolicyBean.getId().equals(policyId2)) continue;
                bean2 = autoscalePolicyBean;
            }
            Assert.assertNotNull(bean2);
            boolean removed = this.restClient.removeEntity("/api/autoscalingPolicies", policyId1, "autoscalingPolicy");
            Assert.assertTrue((String)String.format("[autoscaling-policy-id] %s couldn't be removed", policyId1), (boolean)removed);
            AutoscalePolicyBean beanRemoved = (AutoscalePolicyBean)this.restClient.getEntity("/api/autoscalingPolicies", policyId1, AutoscalePolicyBean.class, "autoscalingPolicy");
            Assert.assertNull((String)String.format("[autoscaling-policy-id] %s didn't get removed successfully", policyId1), (Object)beanRemoved);
            removed = this.restClient.removeEntity("/api/autoscalingPolicies", policyId2, "autoscalingPolicy");
            Assert.assertTrue((String)String.format("[autoscaling-policy-id] %s couldn't be removed", policyId2), (boolean)removed);
            beanRemoved = (AutoscalePolicyBean)this.restClient.getEntity("/api/autoscalingPolicies", policyId2, AutoscalePolicyBean.class, "autoscalingPolicy");
            Assert.assertNull((String)String.format("[autoscaling-policy-id] %s didn't get removed successfully", policyId2), (Object)beanRemoved);
            log.info((Object)"-------------------------Ended autoscaling policy list test case---------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling [autoscaling policy] list", (Throwable)e);
            Assert.assertTrue((String)"An error occurred while handling [autoscaling policy] list", (boolean)false);
        }
    }
}

