/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests.policies;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.beans.partition.NetworkPartitionReferenceBean;
import org.apache.stratos.common.beans.partition.PartitionReferenceBean;
import org.apache.stratos.common.beans.policy.deployment.DeploymentPolicyBean;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.ppaas.integration.tests.PPaaSTestServerManager;

public class DeploymentPolicyTest
extends PPaaSTestServerManager {
    private static final Log log = LogFactory.getLog(DeploymentPolicyTest.class);
    private static final String RESOURCES_PATH = "/deployment-policy-test";

    @BeforeClass(alwaysRun=true)
    public void testInit() throws Exception {
        super.init();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanup();
    }

    @Test(alwaysRun=true, description="Deploy deployment policy", priority=1, timeOut=300000L)
    public void testDeploymentPolicy() {
        try {
            String deploymentPolicyId = "deployment-policy-deployment-policy-test";
            log.info((Object)"-------------------------Started deployment policy test case-------------------------");
            boolean addedN1 = this.restClient.addEntity("/deployment-policy-test/network-partitions/mock//network-partition-deployment-policy-test-1.json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)addedN1);
            boolean addedN2 = this.restClient.addEntity("/deployment-policy-test/network-partitions/mock//network-partition-deployment-policy-test-2.json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)addedN2);
            boolean addedDep = this.restClient.addEntity("/deployment-policy-test/deployment-policies//" + deploymentPolicyId + ".json", "/api/deploymentPolicies", "deploymentPolicy");
            Assert.assertTrue((boolean)addedDep);
            DeploymentPolicyBean bean = (DeploymentPolicyBean)this.restClient.getEntity("/api/deploymentPolicies", deploymentPolicyId, DeploymentPolicyBean.class, "deploymentPolicy");
            NetworkPartitionReferenceBean nw1 = (NetworkPartitionReferenceBean)bean.getNetworkPartitions().get(0);
            NetworkPartitionReferenceBean nw2 = (NetworkPartitionReferenceBean)bean.getNetworkPartitions().get(1);
            PartitionReferenceBean nw1P1 = (PartitionReferenceBean)nw1.getPartitions().get(0);
            PartitionReferenceBean nw2P1 = (PartitionReferenceBean)nw2.getPartitions().get(0);
            PartitionReferenceBean nw2P2 = (PartitionReferenceBean)nw2.getPartitions().get(1);
            Assert.assertEquals((String)bean.getId(), (String)"deployment-policy-deployment-policy-test");
            Assert.assertEquals((int)bean.getNetworkPartitions().size(), (int)2);
            Assert.assertEquals((String)nw1.getId(), (String)"network-partition-deployment-policy-test-1");
            Assert.assertEquals((String)nw1.getPartitionAlgo(), (String)"one-after-another");
            Assert.assertEquals((int)nw1.getPartitions().size(), (int)1);
            Assert.assertEquals((String)nw1P1.getId(), (String)"partition-1");
            Assert.assertEquals((int)nw1P1.getPartitionMax(), (int)20);
            Assert.assertEquals((String)nw2.getId(), (String)"network-partition-deployment-policy-test-2");
            Assert.assertEquals((String)nw2.getPartitionAlgo(), (String)"round-robin");
            Assert.assertEquals((int)nw2.getPartitions().size(), (int)2);
            Assert.assertEquals((String)nw2P1.getId(), (String)"network-partition-6-partition-1");
            Assert.assertEquals((int)nw2P1.getPartitionMax(), (int)10);
            Assert.assertEquals((String)nw2P2.getId(), (String)"network-partition-6-partition-2");
            Assert.assertEquals((int)nw2P2.getPartitionMax(), (int)9);
            boolean updated = this.restClient.updateEntity("/deployment-policy-test/network-partitions/mock//network-partition-deployment-policy-test-1-v1.json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)updated);
            boolean updatedDep = this.restClient.updateEntity("/deployment-policy-test/deployment-policies//" + deploymentPolicyId + "-v1.json", "/api/deploymentPolicies", "deploymentPolicy");
            Assert.assertTrue((boolean)updatedDep);
            DeploymentPolicyBean updatedBean = (DeploymentPolicyBean)this.restClient.getEntity("/api/deploymentPolicies", deploymentPolicyId, DeploymentPolicyBean.class, "deploymentPolicy");
            nw1 = (NetworkPartitionReferenceBean)updatedBean.getNetworkPartitions().get(0);
            nw2 = (NetworkPartitionReferenceBean)updatedBean.getNetworkPartitions().get(1);
            nw1P1 = (PartitionReferenceBean)nw1.getPartitions().get(0);
            PartitionReferenceBean nw1P2 = (PartitionReferenceBean)nw1.getPartitions().get(1);
            nw2P1 = (PartitionReferenceBean)nw2.getPartitions().get(0);
            nw2P2 = (PartitionReferenceBean)nw2.getPartitions().get(1);
            Assert.assertEquals((String)updatedBean.getId(), (String)"deployment-policy-deployment-policy-test");
            Assert.assertEquals((int)updatedBean.getNetworkPartitions().size(), (int)2);
            Assert.assertEquals((String)nw1.getId(), (String)"network-partition-deployment-policy-test-1");
            Assert.assertEquals((String)nw1.getPartitionAlgo(), (String)"one-after-another");
            Assert.assertEquals((int)nw1.getPartitions().size(), (int)2);
            Assert.assertEquals((String)nw1P1.getId(), (String)"partition-1");
            Assert.assertEquals((int)nw1P1.getPartitionMax(), (int)25);
            Assert.assertEquals((String)nw1P2.getId(), (String)"partition-2");
            Assert.assertEquals((int)nw1P2.getPartitionMax(), (int)20);
            Assert.assertEquals((String)nw2.getId(), (String)"network-partition-deployment-policy-test-2");
            Assert.assertEquals((String)nw2.getPartitionAlgo(), (String)"round-robin");
            Assert.assertEquals((int)nw2.getPartitions().size(), (int)2);
            Assert.assertEquals((String)nw2P1.getId(), (String)"network-partition-6-partition-1");
            Assert.assertEquals((int)nw2P1.getPartitionMax(), (int)15);
            Assert.assertEquals((String)nw2P2.getId(), (String)"network-partition-6-partition-2");
            Assert.assertEquals((int)nw2P2.getPartitionMax(), (int)5);
            boolean removedNet = this.restClient.removeEntity("/api/networkPartitions", "network-partition-deployment-policy-test-1", "networkPartition");
            Assert.assertFalse((boolean)removedNet);
            boolean removedDep = this.restClient.removeEntity("/api/deploymentPolicies", deploymentPolicyId, "deploymentPolicy");
            Assert.assertTrue((boolean)removedDep);
            DeploymentPolicyBean beanRemovedDep = (DeploymentPolicyBean)this.restClient.getEntity("/api/deploymentPolicies", deploymentPolicyId, DeploymentPolicyBean.class, "deploymentPolicy");
            Assert.assertNull((Object)beanRemovedDep);
            boolean removedN1 = this.restClient.removeEntity("/api/networkPartitions", "network-partition-deployment-policy-test-1", "networkPartition");
            Assert.assertTrue((boolean)removedN1);
            DeploymentPolicyBean beanRemovedN1 = (DeploymentPolicyBean)this.restClient.getEntity("/api/networkPartitions", "network-partition-deployment-policy-test-1", DeploymentPolicyBean.class, "networkPartition");
            Assert.assertNull((Object)beanRemovedN1);
            boolean removedN2 = this.restClient.removeEntity("/api/networkPartitions", "network-partition-deployment-policy-test-2", "networkPartition");
            Assert.assertTrue((boolean)removedN2);
            DeploymentPolicyBean beanRemovedN2 = (DeploymentPolicyBean)this.restClient.getEntity("/api/networkPartitions", "network-partition-deployment-policy-test-2", DeploymentPolicyBean.class, "networkPartition");
            Assert.assertNull((Object)beanRemovedN2);
            log.info((Object)"-------------------------Ended deployment policy test case-------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling deployment policy", (Throwable)e);
            Assert.assertTrue((String)"An error occurred while handling deployment policy", (boolean)false);
        }
    }

    @Test(alwaysRun=true, description="Deploy deployment policy 2", timeOut=300000L)
    public void testDeploymentPolicyList() {
        try {
            String deploymentPolicyId1 = "deployment-policy-deployment-policy-test-1";
            String deploymentPolicyId2 = "deployment-policy-deployment-policy-test-2";
            log.info((Object)"-------------------------Started deployment policy list test case-------------------------");
            boolean addedN1 = this.restClient.addEntity("/deployment-policy-test/network-partitions/mock//network-partition-deployment-policy-test-1.json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)addedN1);
            boolean addedN2 = this.restClient.addEntity("/deployment-policy-test/network-partitions/mock//network-partition-deployment-policy-test-2.json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)addedN2);
            boolean addedDep = this.restClient.addEntity("/deployment-policy-test/deployment-policies//" + deploymentPolicyId1 + ".json", "/api/deploymentPolicies", "deploymentPolicy");
            Assert.assertTrue((boolean)addedDep);
            addedDep = this.restClient.addEntity("/deployment-policy-test/deployment-policies//" + deploymentPolicyId2 + ".json", "/api/deploymentPolicies", "deploymentPolicy");
            Assert.assertTrue((boolean)addedDep);
            Type listType = new TypeToken<ArrayList<DeploymentPolicyBean>>(){}.getType();
            List cartridgeList = (List)this.restClient.listEntity("/api/deploymentPolicies", listType, "deploymentPolicy");
            Assert.assertTrue((cartridgeList.size() >= 2 ? 1 : 0) != 0);
            DeploymentPolicyBean bean1 = null;
            for (DeploymentPolicyBean deploymentPolicyBean : cartridgeList) {
                if (!deploymentPolicyBean.getId().equals(deploymentPolicyId1)) continue;
                bean1 = deploymentPolicyBean;
            }
            Assert.assertNotNull(bean1);
            DeploymentPolicyBean bean2 = null;
            for (DeploymentPolicyBean deploymentPolicyBean : cartridgeList) {
                if (!deploymentPolicyBean.getId().equals(deploymentPolicyId2)) continue;
                bean2 = deploymentPolicyBean;
            }
            Assert.assertNotNull(bean2);
            boolean removedDep = this.restClient.removeEntity("/api/deploymentPolicies", deploymentPolicyId1, "deploymentPolicy");
            Assert.assertTrue((boolean)removedDep);
            DeploymentPolicyBean beanRemovedDep = (DeploymentPolicyBean)this.restClient.getEntity("/api/deploymentPolicies", deploymentPolicyId1, DeploymentPolicyBean.class, "deploymentPolicy");
            Assert.assertNull((Object)beanRemovedDep);
            boolean removedNet = this.restClient.removeEntity("/api/networkPartitions", "network-partition-deployment-policy-test-1", "networkPartition");
            Assert.assertFalse((boolean)removedNet);
            removedDep = this.restClient.removeEntity("/api/deploymentPolicies", deploymentPolicyId2, "deploymentPolicy");
            Assert.assertTrue((boolean)removedDep);
            beanRemovedDep = (DeploymentPolicyBean)this.restClient.getEntity("/api/deploymentPolicies", deploymentPolicyId2, DeploymentPolicyBean.class, "deploymentPolicy");
            Assert.assertNull((Object)beanRemovedDep);
            boolean removedN1 = this.restClient.removeEntity("/api/networkPartitions", "network-partition-deployment-policy-test-1", "networkPartition");
            Assert.assertTrue((boolean)removedN1);
            DeploymentPolicyBean beanRemovedN1 = (DeploymentPolicyBean)this.restClient.getEntity("/api/networkPartitions", "network-partition-deployment-policy-test-1", DeploymentPolicyBean.class, "networkPartition");
            Assert.assertNull((Object)beanRemovedN1);
            boolean removedN2 = this.restClient.removeEntity("/api/networkPartitions", "network-partition-deployment-policy-test-2", "networkPartition");
            Assert.assertTrue((boolean)removedN2);
            DeploymentPolicyBean beanRemovedN2 = (DeploymentPolicyBean)this.restClient.getEntity("/api/networkPartitions", "network-partition-deployment-policy-test-2", DeploymentPolicyBean.class, "networkPartition");
            Assert.assertNull((Object)beanRemovedN2);
            log.info((Object)"-------------------------Ended deployment policy list test case-------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling deployment policy", (Throwable)e);
            Assert.assertTrue((String)"An error occurred while handling deployment policy", (boolean)false);
        }
    }
}

