/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests.policies;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.beans.PropertyBean;
import org.apache.stratos.common.beans.partition.NetworkPartitionBean;
import org.apache.stratos.common.beans.partition.PartitionBean;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.ppaas.integration.tests.PPaaSTestServerManager;

public class NetworkPartitionTest
extends PPaaSTestServerManager {
    private static final Log log = LogFactory.getLog(NetworkPartitionTest.class);
    private static final String RESOURCES_PATH = "/network-partition-test";

    @BeforeClass(alwaysRun=true)
    public void testInit() throws Exception {
        super.init();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanup();
    }

    @Test(alwaysRun=true, description="Deploy network partition", priority=1, timeOut=300000L)
    public void testNetworkPartition() {
        try {
            String networkPartitionId = "network-partition-network-partition-test";
            log.info((Object)"-------------------------Started network partition test case-------------------------");
            boolean added = this.restClient.addEntity("/network-partition-test/network-partitions/mock//" + networkPartitionId + ".json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)added);
            NetworkPartitionBean bean = (NetworkPartitionBean)this.restClient.getEntity("/api/networkPartitions", networkPartitionId, NetworkPartitionBean.class, "networkPartition");
            PartitionBean p1 = (PartitionBean)bean.getPartitions().get(0);
            Assert.assertEquals((String)bean.getId(), (String)"network-partition-network-partition-test");
            Assert.assertEquals((int)bean.getPartitions().size(), (int)1);
            Assert.assertEquals((String)p1.getId(), (String)"partition-1");
            Assert.assertEquals((String)((PropertyBean)p1.getProperty().get(0)).getName(), (String)"region");
            Assert.assertEquals((String)((PropertyBean)p1.getProperty().get(0)).getValue(), (String)"default");
            boolean updated = this.restClient.updateEntity("/network-partition-test/network-partitions/mock//" + networkPartitionId + "-v1.json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)updated);
            NetworkPartitionBean updatedBean = (NetworkPartitionBean)this.restClient.getEntity("/api/networkPartitions", networkPartitionId, NetworkPartitionBean.class, "networkPartition");
            PartitionBean p2 = (PartitionBean)updatedBean.getPartitions().get(1);
            Assert.assertEquals((String)updatedBean.getId(), (String)"network-partition-network-partition-test");
            Assert.assertEquals((int)updatedBean.getPartitions().size(), (int)2);
            Assert.assertEquals((String)p2.getId(), (String)"partition-2");
            Assert.assertEquals((String)((PropertyBean)p2.getProperty().get(0)).getName(), (String)"region");
            Assert.assertEquals((String)((PropertyBean)p2.getProperty().get(0)).getValue(), (String)"default1");
            Assert.assertEquals((String)((PropertyBean)p2.getProperty().get(1)).getName(), (String)"zone");
            Assert.assertEquals((String)((PropertyBean)p2.getProperty().get(1)).getValue(), (String)"z1");
            boolean removed = this.restClient.removeEntity("/api/networkPartitions", networkPartitionId, "networkPartition");
            Assert.assertTrue((boolean)removed);
            NetworkPartitionBean beanRemoved = (NetworkPartitionBean)this.restClient.getEntity("/api/networkPartitions", networkPartitionId, NetworkPartitionBean.class, "networkPartition");
            Assert.assertNull((Object)beanRemoved);
            log.info((Object)"-------------------------Ended network partition test case-------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling network partitions", (Throwable)e);
            Assert.assertTrue((String)"An error occurred while handling network partitions", (boolean)false);
        }
    }

    @Test(alwaysRun=true, description="Deploy network partition 2", timeOut=300000L)
    public void testNetworkPartitionList() {
        try {
            String networkPartitionId1 = "network-partition-network-partition-test-1";
            String networkPartitionId2 = "network-partition-network-partition-test-2";
            log.info((Object)"-------------------------Started network partition list test case-------------------------");
            boolean added = this.restClient.addEntity("/network-partition-test/network-partitions/mock//" + networkPartitionId1 + ".json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)added);
            added = this.restClient.addEntity("/network-partition-test/network-partitions/mock//" + networkPartitionId2 + ".json", "/api/networkPartitions", "networkPartition");
            Assert.assertTrue((boolean)added);
            Type listType = new TypeToken<ArrayList<NetworkPartitionBean>>(){}.getType();
            List cartridgeList = (List)this.restClient.listEntity("/api/networkPartitions", listType, "networkPartition");
            Assert.assertTrue((cartridgeList.size() >= 2 ? 1 : 0) != 0);
            NetworkPartitionBean bean1 = null;
            for (NetworkPartitionBean networkPartitionBean : cartridgeList) {
                if (!networkPartitionBean.getId().equals(networkPartitionId1)) continue;
                bean1 = networkPartitionBean;
            }
            Assert.assertNotNull(bean1);
            NetworkPartitionBean bean2 = null;
            for (NetworkPartitionBean networkPartitionBean : cartridgeList) {
                if (!networkPartitionBean.getId().equals(networkPartitionId2)) continue;
                bean2 = networkPartitionBean;
            }
            Assert.assertNotNull(bean2);
            boolean removed = this.restClient.removeEntity("/api/networkPartitions", networkPartitionId1, "networkPartition");
            Assert.assertTrue((boolean)removed);
            NetworkPartitionBean beanRemoved = (NetworkPartitionBean)this.restClient.getEntity("/api/networkPartitions", networkPartitionId1, NetworkPartitionBean.class, "networkPartition");
            Assert.assertNull((Object)beanRemoved);
            removed = this.restClient.removeEntity("/api/networkPartitions", networkPartitionId2, "networkPartition");
            Assert.assertTrue((boolean)removed);
            beanRemoved = (NetworkPartitionBean)this.restClient.getEntity("/api/networkPartitions", networkPartitionId2, NetworkPartitionBean.class, "networkPartition");
            Assert.assertNull((Object)beanRemoved);
            log.info((Object)"-------------------------Ended network partition test case-------------------------");
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while handling network partitions", (Throwable)e);
            Assert.assertTrue((String)"An error occurred while handling network partitions", (boolean)false);
        }
    }
}

