/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.wso2.ppaas.integration.tests.rest.HttpResponse;

public class HttpResponseHandler
implements ResponseHandler<HttpResponse> {
    private static final Log log = LogFactory.getLog(HttpResponseHandler.class);

    public HttpResponse handleResponse(org.apache.http.HttpResponse response) throws ClientProtocolException, IOException {
        String output;
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new ClientProtocolException("Response contains no content");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        String result = "";
        while ((output = reader.readLine()) != null) {
            result = result + output;
        }
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatusCode(statusLine.getStatusCode());
        httpResponse.setContent(result);
        httpResponse.setReason(statusLine.getReasonPhrase());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracted Http Response: " + httpResponse.toString()));
        }
        return httpResponse;
    }
}

