/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.stratos.mock.iaas.client.MockIaasApiClient;
import org.apache.stratos.mock.iaas.client.rest.HttpResponse;
import org.apache.stratos.mock.iaas.client.rest.HttpResponseHandler;
import org.apache.stratos.mock.iaas.domain.ErrorResponse;
import org.wso2.ppaas.integration.tests.rest.WebClientWrapper;

public class IntegrationMockClient
extends MockIaasApiClient {
    private static final Log log = LogFactory.getLog(IntegrationMockClient.class);
    private static final String INSTANCES_CONTEXT = "/instances/";
    private DefaultHttpClient httpClient;
    private String endpoint;

    public IntegrationMockClient(String endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(50);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)cm);
        this.httpClient = (DefaultHttpClient)WebClientWrapper.wrapClient((HttpClient)this.httpClient);
    }

    public boolean terminateInstance(String instanceId) {
        try {
            URI uri;
            HttpResponse response;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Terminate instance: [instance-id] %s", instanceId));
            }
            if ((response = this.doDelete(uri = new URIBuilder(this.endpoint + INSTANCES_CONTEXT + instanceId).build())) != null) {
                if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                    return true;
                }
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                ErrorResponse errorResponse = (ErrorResponse)gson.fromJson(response.getContent(), ErrorResponse.class);
                if (errorResponse != null) {
                    throw new RuntimeException(errorResponse.getErrorMessage());
                }
            }
            throw new RuntimeException("An unknown error occurred");
        }
        catch (Exception e) {
            String message = "Could not start mock instance";
            throw new RuntimeException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doDelete(URI resourcePath) throws Exception {
        HttpDelete httpDelete = null;
        try {
            httpDelete = new HttpDelete(resourcePath);
            httpDelete.addHeader("Content-Type", "application/json");
            HttpResponse httpResponse = (HttpResponse)this.httpClient.execute((HttpUriRequest)httpDelete, (ResponseHandler)new HttpResponseHandler());
            return httpResponse;
        }
        finally {
            this.releaseConnection((HttpRequestBase)httpDelete);
        }
    }

    private void releaseConnection(HttpRequestBase request) {
        if (request != null) {
            request.releaseConnection();
        }
    }
}

