/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ppaas.integration.tests.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.wso2.ppaas.integration.tests.rest.ErrorResponse;
import org.wso2.ppaas.integration.tests.rest.HttpResponse;
import org.wso2.ppaas.integration.tests.rest.HttpResponseHandler;
import org.wso2.ppaas.integration.tests.rest.WebClientWrapper;

public class RestClient {
    private static final Log log = LogFactory.getLog(RestClient.class);
    private DefaultHttpClient httpClient;
    private String endPoint;
    private String userName;
    private String password;

    public RestClient() {
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(50);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)cm);
        this.httpClient = (DefaultHttpClient)WebClientWrapper.wrapClient((HttpClient)this.httpClient);
    }

    public RestClient(String endPoint, String userName, String password) {
        this();
        this.endPoint = endPoint;
        this.userName = userName;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doPost(URI resourcePath, String jsonParamString) throws Exception {
        HttpPost postRequest = null;
        try {
            postRequest = new HttpPost(resourcePath);
            StringEntity input = new StringEntity(jsonParamString);
            input.setContentType("application/json");
            postRequest.setEntity((HttpEntity)input);
            String userPass = this.getUsernamePassword();
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
            postRequest.addHeader("Authorization", basicAuth);
            HttpResponse httpResponse = (HttpResponse)this.httpClient.execute((HttpUriRequest)postRequest, (ResponseHandler)new HttpResponseHandler());
            return httpResponse;
        }
        finally {
            this.releaseConnection((HttpRequestBase)postRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doGet(URI resourcePath) throws Exception {
        HttpGet getRequest = null;
        try {
            getRequest = new HttpGet(resourcePath);
            getRequest.addHeader("Content-Type", "application/json");
            String userPass = this.getUsernamePassword();
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
            getRequest.addHeader("Authorization", basicAuth);
            HttpResponse httpResponse = (HttpResponse)this.httpClient.execute((HttpUriRequest)getRequest, (ResponseHandler)new HttpResponseHandler());
            return httpResponse;
        }
        finally {
            this.releaseConnection((HttpRequestBase)getRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doDelete(URI resourcePath) throws Exception {
        HttpDelete httpDelete = null;
        try {
            httpDelete = new HttpDelete(resourcePath);
            httpDelete.addHeader("Content-Type", "application/json");
            String userPass = this.getUsernamePassword();
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
            httpDelete.addHeader("Authorization", basicAuth);
            HttpResponse httpResponse = (HttpResponse)this.httpClient.execute((HttpUriRequest)httpDelete, (ResponseHandler)new HttpResponseHandler());
            return httpResponse;
        }
        finally {
            this.releaseConnection((HttpRequestBase)httpDelete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doPut(URI resourcePath, String jsonParamString) throws Exception {
        HttpPut putRequest = null;
        try {
            putRequest = new HttpPut(resourcePath);
            StringEntity input = new StringEntity(jsonParamString);
            input.setContentType("application/json");
            putRequest.setEntity((HttpEntity)input);
            String userPass = this.getUsernamePassword();
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
            putRequest.addHeader("Authorization", basicAuth);
            HttpResponse httpResponse = (HttpResponse)this.httpClient.execute((HttpUriRequest)putRequest, (ResponseHandler)new HttpResponseHandler());
            return httpResponse;
        }
        finally {
            this.releaseConnection((HttpRequestBase)putRequest);
        }
    }

    private void releaseConnection(HttpRequestBase request) {
        if (request != null) {
            request.releaseConnection();
        }
    }

    public boolean addEntity(String filePath, String resourcePath, String entityName) {
        try {
            String content = this.getJsonStringFromFile(filePath);
            URI uri = new URIBuilder(this.endPoint + resourcePath).build();
            HttpResponse response = this.doPost(uri, content);
            if (response != null) {
                if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                    return true;
                }
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                ErrorResponse errorResponse = (ErrorResponse)gson.fromJson(response.getContent(), ErrorResponse.class);
                if (errorResponse != null) {
                    throw new RuntimeException(errorResponse.getErrorMessage());
                }
            }
            String msg = "An unknown error occurred while trying to add ";
            log.error((Object)(msg + entityName));
            throw new RuntimeException(msg + entityName);
        }
        catch (Exception e) {
            String message = "Could not add " + entityName;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public boolean deployEntity(String resourcePath, String entityName) {
        try {
            URI uri = new URIBuilder(this.endPoint + resourcePath).build();
            HttpResponse response = this.doPost(uri, "");
            if (response != null) {
                if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                    return true;
                }
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                ErrorResponse errorResponse = (ErrorResponse)gson.fromJson(response.getContent(), ErrorResponse.class);
                if (errorResponse != null) {
                    throw new RuntimeException(errorResponse.getErrorMessage());
                }
            }
            String msg = "An unknown error occurred while trying to deploy ";
            log.error((Object)(msg + entityName));
            throw new RuntimeException(msg + entityName);
        }
        catch (Exception e) {
            String message = "Could not deploy  " + entityName;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public boolean undeployEntity(String resourcePath, String entityName) {
        try {
            URI uri = new URIBuilder(this.endPoint + resourcePath).build();
            HttpResponse response = this.doPost(uri, "");
            if (response != null) {
                if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                    return true;
                }
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                ErrorResponse errorResponse = (ErrorResponse)gson.fromJson(response.getContent(), ErrorResponse.class);
                if (errorResponse != null) {
                    throw new RuntimeException(errorResponse.getErrorMessage());
                }
            }
            String msg = "An unknown error occurred while trying to undeploy ";
            log.error((Object)(msg + entityName));
            throw new RuntimeException(msg + entityName);
        }
        catch (Exception e) {
            String message = "Could not deploy  " + entityName;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public Object getEntity(String resourcePath, String identifier, Class responseJsonClass, String entityName) {
        try {
            URI uri = new URIBuilder(this.endPoint + resourcePath + "/" + identifier).build();
            HttpResponse response = this.doGet(uri);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (response != null) {
                if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                    return gson.fromJson(response.getContent(), responseJsonClass);
                }
                if (response.getStatusCode() == 404) {
                    return null;
                }
                ErrorResponse errorResponse = (ErrorResponse)gson.fromJson(response.getContent(), ErrorResponse.class);
                if (errorResponse != null) {
                    throw new RuntimeException(errorResponse.getErrorMessage());
                }
            }
            String msg = "An unknown error occurred while getting the " + entityName;
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            String message = "Could not get " + entityName;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public Object listEntity(String resourcePath, Type type, String entityName) {
        try {
            URI uri = new URIBuilder(this.endPoint + resourcePath).build();
            HttpResponse response = this.doGet(uri);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (response != null) {
                if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                    return gson.fromJson(response.getContent(), type);
                }
                if (response.getStatusCode() == 404) {
                    return null;
                }
                ErrorResponse errorResponse = (ErrorResponse)gson.fromJson(response.getContent(), ErrorResponse.class);
                if (errorResponse != null) {
                    throw new RuntimeException(errorResponse.getErrorMessage());
                }
            }
            String msg = "An unknown error occurred while getting the " + entityName;
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            String message = "Could not get " + entityName;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public boolean removeEntity(String resourcePath, String identifier, String entityName) {
        try {
            URI uri = new URIBuilder(this.endPoint + "/" + resourcePath + "/" + identifier).build();
            HttpResponse response = this.doDelete(uri);
            if (response != null) {
                if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                    return true;
                }
                if (response.getContent().contains("it is used") || response.getContent().contains("in use")) {
                    return false;
                }
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                ErrorResponse errorResponse = (ErrorResponse)gson.fromJson(response.getContent(), ErrorResponse.class);
                if (errorResponse != null) {
                    throw new RuntimeException(errorResponse.getErrorMessage());
                }
            }
            String msg = "An unknown error occurred while removing the " + entityName;
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            String message = "Could not remove  " + entityName;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public boolean updateEntity(String filePath, String resourcePath, String entityName) {
        try {
            String content = this.getJsonStringFromFile(filePath);
            URI uri = new URIBuilder(this.endPoint + resourcePath).build();
            HttpResponse response = this.doPut(uri, content);
            if (response != null) {
                if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                    return true;
                }
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                ErrorResponse errorResponse = (ErrorResponse)gson.fromJson(response.getContent(), ErrorResponse.class);
                if (errorResponse != null) {
                    throw new RuntimeException(errorResponse.getErrorMessage());
                }
            }
            String msg = "An unknown error occurred while trying to update ";
            log.error((Object)(msg + entityName));
            throw new RuntimeException(msg + entityName);
        }
        catch (Exception e) {
            String message = "Could not update " + entityName;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public String getJsonStringFromFile(String filePath) throws FileNotFoundException {
        JsonParser parser = new JsonParser();
        JsonElement object = parser.parse((Reader)new FileReader(this.getResourcesFolderPath() + filePath));
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        return gson.toJson((Object)object);
    }

    private String getResourcesFolderPath() {
        String path = this.getClass().getResource("/").getPath();
        return StringUtils.removeEnd((String)path, (String)File.separator);
    }

    private String getUsernamePassword() {
        return this.userName + ":" + this.password;
    }
}

