/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.validator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class Util {
    private static Log log = LogFactory.getLog((Class)Util.class);

    public static String getFilePathFromFileId(String fileId, ConfigurationContext configCtx) {
        Map fileResMap = (Map)configCtx.getProperty("file.resource.map");
        return (String)fileResMap.get(fileId);
    }

    public static File getOutputFilePath(String xmlfilePath, String xmlFileName) {
        if (File.separatorChar == '\\') {
            xmlfilePath = xmlfilePath.replace('\\', '/');
        }
        int lastIndex = xmlfilePath.lastIndexOf(47);
        String filePath = xmlfilePath.substring(0, lastIndex);
        return new File(filePath, xmlFileName);
    }

    public static String doTransformation(InputStream xmlStream, String inFilePath, String xslValidatorLocation, String xslFormatterLocation, ClassLoader classLoader) throws AxisFault {
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        try {
            InputStream xslStream = classLoader.getResourceAsStream(xslValidatorLocation);
            InputStream xslForamtterStream = classLoader.getResourceAsStream(xslFormatterLocation);
            StreamSource xmlSource = new StreamSource(xmlStream);
            StreamSource xslSource = new StreamSource(xslStream);
            StreamSource xslForamtterSource = new StreamSource(xslForamtterStream);
            String fileName = uuid + ".html";
            File outFile = Util.getOutputFilePath(inFilePath, fileName);
            DocumentBuilder docB = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docB.newDocument();
            DOMResult result = new DOMResult(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
            transformer.transform(xmlSource, result);
            FileOutputStream outFileStream = new FileOutputStream(outFile);
            StreamResult finalResult = new StreamResult(outFileStream);
            transformer = TransformerFactory.newInstance().newTransformer(xslForamtterSource);
            transformer.transform(new DOMSource(doc), finalResult);
            ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
            Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)configCtx.getProperty("file.resource.map");
            if (fileResourcesMap == null) {
                fileResourcesMap = new Hashtable<String, String>();
                configCtx.setProperty("file.resource.map", fileResourcesMap);
            }
            fileResourcesMap.put(uuid, outFile.getAbsolutePath());
        }
        catch (Exception e) {
            String msg = "Error has been encounted while doing the transformation.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        return "/filedownload?id=" + uuid;
    }

    public static void continueProcess(InputStream in) throws AxisFault {
        try {
            StAXOMBuilder builder = new StAXOMBuilder(in);
            OMElement element = builder.getDocumentElement();
            element.build();
        }
        catch (Exception e) {
            String msg = "The XML descriptor file is empty or not well-formed";
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public static InputStream locateXML(String filePath, String extension, String relXMLPath) throws AxisFault {
        try {
            ZipEntry entry;
            if (!filePath.endsWith(extension)) {
                throw new AxisFault("The relevent Axis2 archive should be end with " + extension + " extension.");
            }
            FileInputStream stream = new FileInputStream(filePath);
            ZipInputStream zin = new ZipInputStream(stream);
            boolean xmlFound = false;
            while ((entry = zin.getNextEntry()) != null) {
                if (!entry.getName().equalsIgnoreCase(relXMLPath)) continue;
                xmlFound = true;
                break;
            }
            if (!xmlFound) {
                String msg = relXMLPath + " is not found. Check and upload an valid Axis2 archive.";
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
            return zin;
        }
        catch (IOException e) {
            String msg = "File cannot be found";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }
}

