/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.validator;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.wso2.validator.Util;

public class Module {
    public static final String MODULE_XSL_LOCATION = "org/wso2/validator/module_validator.xsl";
    public static final String MODULE_XSL_FORMATTER_LOCATION = "org/wso2/validator/module_formatter.xsl";

    public String validate(String fileId) throws AxisFault {
        String s;
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        String marFileLocation = Util.getFilePathFromFileId(fileId, configCtx);
        if (marFileLocation == null) {
            throw new AxisFault("Uploaded file is invalid and cannot continue the validation,");
        }
        try {
            InputStream in = Util.locateXML(marFileLocation, ".mar", "META-INF/module.xml");
            Util.continueProcess(in);
            in = Util.locateXML(marFileLocation, ".mar", "META-INF/module.xml");
            s = Util.doTransformation(in, marFileLocation, MODULE_XSL_LOCATION, MODULE_XSL_FORMATTER_LOCATION, Module.class.getClassLoader());
            in.close();
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        return s;
    }

    public String validateModuleXML(String fileId) throws AxisFault {
        String s;
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        try {
            String marFileLocation = Util.getFilePathFromFileId(fileId, configCtx);
            if (marFileLocation == null) {
                throw new AxisFault("Uploaded file is invalid and cannot continue the validation,");
            }
            FileInputStream in = new FileInputStream(marFileLocation);
            Util.continueProcess(in);
            in = new FileInputStream(marFileLocation);
            s = Util.doTransformation(in, marFileLocation, MODULE_XSL_LOCATION, MODULE_XSL_FORMATTER_LOCATION, Module.class.getClassLoader());
            in.close();
        }
        catch (FileNotFoundException e) {
            String msg = "module.xml validation cannot be continued. This might cause due to uploading of invalid module.xml or internal server error. ";
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        return s;
    }
}

