/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.utils.security.CryptoUtil;
import org.wso2.wsas.admin.service.AbstractAdmin;
import org.wso2.wsas.admin.service.TransportAdmin;
import org.wso2.wsas.admin.service.util.KeyStoreSummary;
import org.wso2.wsas.admin.service.util.ServiceKeyStore;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.exception.KeyStoreAlreadyExistsException;
import org.wso2.wsas.util.KeyStoreUtil;

public class CryptoAdmin
extends AbstractAdmin {
    private static Log log = LogFactory.getLog((Class)TransportAdmin.class);
    private PersistenceManager pm = new PersistenceManager();

    public String[] getPrivateKeys(String keyStoreFileId, String storePass, String keyStoreType) throws AxisFault {
        ArrayList<String> pvtKeys = new ArrayList<String>();
        String filePath = this.getFilePathFromFileId(keyStoreFileId);
        FileInputStream in = null;
        BufferedInputStream ksbufin = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            in = new FileInputStream(filePath);
            ksbufin = new BufferedInputStream(in);
            keyStore.load(ksbufin, storePass.toCharArray());
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                pvtKeys.add(alias);
            }
        }
        catch (Exception e) {
            String msg = "Could not read private keys from keystore file. ";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg + e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (ksbufin != null) {
                    ksbufin.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        return pvtKeys.toArray(new String[pvtKeys.size()]);
    }

    public String[] getCertificates(String keyStoreName) throws AxisFault {
        ArrayList<String> certificates = new ArrayList<String>();
        try {
            KeyStore keyStore = KeyStoreUtil.getKeyStore((String)keyStoreName);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                certificates.add(alias);
            }
        }
        catch (Exception e) {
            String msg = "Could not read certificates from keystore file. ";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg + e.getMessage());
        }
        Collections.sort(certificates, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String a = (String)arg0;
                String b = (String)arg1;
                return a.compareToIgnoreCase(b);
            }
        });
        return certificates.toArray(new String[certificates.size()]);
    }

    public String addNewKeyStore(String ksFilePathId, String ksPassword, String pvtKeyAlias, String pvtKeyPassword, String keyStoreType, String provider) throws AxisFault {
        String msg;
        File ksFile;
        String ksFilePath = this.getFilePathFromFileId(ksFilePathId);
        if (ksFilePath == null) {
            return "File path corresponding to " + ksFilePathId + " cannot be found.";
        }
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String keyStoreName = ksFilePath.substring(ksFilePath.lastIndexOf(File.separator) + 1);
        FileInputStream in = null;
        BufferedInputStream ksbufin = null;
        OutputStream os = null;
        try {
            File ksDir = new File(serverConfig.getFirstProperty("Security.KeyStoresDir"));
            if (!ksDir.exists()) {
                ksDir.mkdirs();
            }
            if ((ksFile = new File(ksDir.getAbsolutePath(), keyStoreName)).exists()) {
                throw new AxisFault("Keystore file " + ksFile.getName() + " already exists!");
            }
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            in = new FileInputStream(ksFilePath);
            ksbufin = new BufferedInputStream(in);
            keyStore.load(ksbufin, ksPassword.toCharArray());
            if (!keyStore.isKeyEntry(pvtKeyAlias)) {
                String string = pvtKeyAlias + " is not a key entry";
                return string;
            }
            keyStore.getKey(pvtKeyAlias, pvtKeyPassword.toCharArray());
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                if (!keyStore.isKeyEntry(alias) || alias.equals(pvtKeyAlias)) continue;
                keyStore.deleteEntry(alias);
            }
            os = new FileOutputStream(ksFile);
            keyStore.store(os, ksPassword.toCharArray());
            in.close();
            os.flush();
            os.close();
        }
        catch (UnrecoverableKeyException e) {
            msg = "Cannot retrieve private key. Please verify that the password is correct.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (Exception e) {
            msg = "Could not add new keystore. ";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg + e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (ksbufin != null) {
                    ksbufin.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        try {
            KeyStoreUtil.persistKeyStore((String)ksFile.getAbsolutePath(), (String)ksPassword, (String)keyStoreType, (String)pvtKeyAlias, (String)pvtKeyPassword, (String)provider, (boolean)false);
        }
        catch (KeyStoreAlreadyExistsException e) {
            msg = "Cannot add new keystore. ";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (ServerException e) {
            msg = "Cannot add new keystore. ";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg + e.getMessage());
        }
        return "Keystore " + keyStoreName + " successfully added.";
    }

    public String importCertificate(String keyStoreName, String certificatePathId) throws AxisFault {
        FileInputStream ksIn = null;
        BufferedInputStream ksbufin = null;
        OutputStream os = null;
        try {
            String origCertAlias;
            KeyStoreDO keyStoreDO = this.pm.getKeyStore(keyStoreName);
            KeyStore keyStore = KeyStore.getInstance(keyStoreDO.getKeyStoreType());
            ksIn = new FileInputStream(keyStoreDO.getFilePath());
            ksbufin = new BufferedInputStream(ksIn);
            String storePassword = keyStoreDO.getStorePassword();
            ServerConfiguration config = ServerConfiguration.getInstance();
            String ksFile = config.getFirstProperty("Security.KeyStore.Location");
            if (!new File(ksFile).isAbsolute()) {
                ksFile = System.getProperty("wso2wsas.home") + File.separator + ksFile;
            }
            CryptoUtil cryptoUtil = new CryptoUtil(ksFile, config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
            char[] decryptedStorePass = new String(cryptoUtil.base64DecodeAndDecrypt(storePassword)).toCharArray();
            keyStore.load(ksbufin, decryptedStorePass);
            String certFile = this.getFilePathFromFileId(certificatePathId);
            FileInputStream certIn = new FileInputStream(certFile);
            String fileSeparator = File.separator;
            if (File.separator.equals("\\")) {
                fileSeparator = "\\";
            }
            String certAlias = origCertAlias = certFile.substring(certFile.lastIndexOf(fileSeparator) + 1);
            int seq = 0;
            while (keyStore.containsAlias(certAlias)) {
                certAlias = origCertAlias + "." + ++seq;
            }
            keyStore.setCertificateEntry(certAlias, CertificateFactory.getInstance("X.509").generateCertificate(certIn));
            os = new FileOutputStream(new File(keyStoreDO.getFilePath()));
            keyStore.store(os, decryptedStorePass);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            String msg = "Could not import certificate. Certificate may be invalid. ";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        finally {
            try {
                if (ksIn != null) {
                    ksIn.close();
                }
                if (ksbufin != null) {
                    ksbufin.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        String msg = "Certificate imported successfully";
        return msg;
    }

    public String[] getAllKeyStoreNames() {
        KeyStoreDO[] keyStores = this.pm.getKeyStores();
        String[] ksNames = new String[keyStores.length];
        for (int i = 0; i < keyStores.length; ++i) {
            ksNames[i] = keyStores[i].getKeyStoreName();
        }
        return ksNames;
    }

    public ServiceKeyStore[] getServiceKeyStores(String serviceName) {
        String serviceVersion = "$EMPTY$";
        ServiceDO service = this.pm.getService(serviceName, serviceVersion);
        ArrayList<ServiceKeyStore> list = new ArrayList<ServiceKeyStore>();
        KeyStoreDO[] keyStores = this.pm.getKeyStores();
        KeyStoreDO privateKeyStore = service.getPrivateKeyStore();
        for (int i = 0; i < keyStores.length; ++i) {
            ServiceKeyStore serviceKS = new ServiceKeyStore();
            KeyStoreDO keyStore = keyStores[i];
            serviceKS.setKeyStoreName(keyStore.getKeyStoreName());
            serviceKS.setKeyStoreType(keyStore.getKeyStoreType());
            Iterator iterator = service.getTrustedCertStores().iterator();
            while (iterator.hasNext()) {
                KeyStoreDO trustedKS = (KeyStoreDO)iterator.next();
                if (!trustedKS.getKeyStoreName().equals(keyStore.getKeyStoreName())) continue;
                serviceKS.setSelected(true);
            }
            if (privateKeyStore != null && keyStore.getKeyStoreName().equals(privateKeyStore.getKeyStoreName())) {
                serviceKS.setPrivateKeyStore(true);
            }
            list.add(serviceKS);
        }
        return list.toArray(new ServiceKeyStore[list.size()]);
    }

    public KeyStoreSummary[] getKeyStores() {
        KeyStoreDO[] keyStores = this.pm.getKeyStores();
        KeyStoreSummary[] ksSummaries = new KeyStoreSummary[keyStores.length];
        for (int i = 0; i < keyStores.length; ++i) {
            KeyStoreDO keyStore = keyStores[i];
            KeyStoreSummary ksSummary = new KeyStoreSummary();
            ksSummary.setKeyStoreFilename(keyStore.getFilePath());
            ksSummary.setKeyStoreName(keyStore.getKeyStoreName());
            ksSummary.setKeyStoreType(keyStore.getKeyStoreType());
            ksSummaries[i] = ksSummary;
        }
        return ksSummaries;
    }

    public String deleteKeyStore(String keyStoreName) throws AxisFault {
        KeyStoreDO keyStore = this.pm.getKeyStore(keyStoreName);
        String msg = "Key store " + keyStoreName + " successfully deleted.";
        if (keyStore == null) {
            msg = "Key store " + keyStoreName + " not found!";
            return msg;
        }
        String filePath = keyStore.getFilePath();
        if (keyStore.getIsPrimaryKeyStore()) {
            msg = "Primary keystore " + keyStoreName + " cannot be deleted!";
            throw new AxisFault(msg);
        }
        Set trustStoreServices = keyStore.getTrustStoreServices();
        if (!trustStoreServices.isEmpty()) {
            int i = 1;
            StringBuffer trustedServices = new StringBuffer();
            Iterator iterator = trustStoreServices.iterator();
            while (iterator.hasNext()) {
                ServiceDO s = (ServiceDO)iterator.next();
                trustedServices.append(i).append(". ").append(s.getServiceIdentifierDO().getServiceId()).append("<br/>");
                ++i;
            }
            throw new AxisFault("Cannot delete keystore since the following services have been associated with a security scenario using this keystore as a trusted certificate store:<br/><br/>" + trustedServices + "<br/>" + "You may disable security for these services and retry.");
        }
        Set pkStoreServices = keyStore.getPkStoreServices();
        if (!pkStoreServices.isEmpty()) {
            StringBuffer pkServices = new StringBuffer();
            int i = 1;
            Iterator iterator = pkStoreServices.iterator();
            while (iterator.hasNext()) {
                ServiceDO s = (ServiceDO)iterator.next();
                pkServices.append(i).append(". ").append(s.getServiceIdentifierDO().getServiceId()).append("<br/");
                ++i;
            }
            throw new AxisFault("Cannot delete keystore since the following services have been associated with a security scenario using this keystore as a private key store:<br/><br/>" + pkServices + "<br/>" + "You may disable security for these services and retry.");
        }
        File ksFile = new File(filePath);
        if (!ksFile.delete()) {
            msg = "Could not delete keystore file " + filePath + ". Due to a JVM issue on MS-Windows, files may not be deleted sometimes.";
            throw new AxisFault(msg);
        }
        this.pm.deleteKeyStore(keyStoreName);
        return msg;
    }

    private String getFilePathFromFileId(String fileId) {
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        Map fileResMap = (Map)configCtx.getProperty("file.resource.map");
        return (String)fileResMap.get(fileId);
    }
}

