/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.admin.service.AbstractAdmin;
import org.wso2.wsas.admin.service.util.DBServerData;
import org.wso2.wsas.util.Utils;

public class DataServiceAdmin
extends AbstractAdmin {
    public DataServiceAdmin() {
    }

    public DataServiceAdmin(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
    }

    public OMElement getDataServiceContents(String serviceId) throws AxisFault {
        OMElement returnEle;
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        String fileParth = (String)axisService.getParameter("org.wso2.ws.dataservice.db_service_config_file").getValue();
        StringBuffer fileContents = new StringBuffer();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(fileParth));
            while ((str = in.readLine()) != null) {
                fileContents.append(str);
            }
            in.close();
        }
        catch (IOException e) {
            throw new AxisFault("Error while reading the contents from the service config file for service " + serviceId, (Throwable)e);
        }
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(fileContents.toString().getBytes()));
            returnEle = new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (Exception e) {
            throw new AxisFault("Error while converting the contents of the configuration file into and OMElement for service " + serviceId, (Throwable)e);
        }
        return returnEle;
    }

    public void saveDataServiceContents(String serviceId, String configContents) throws AxisFault {
        String dataServiceFilePath;
        OMElement configEle;
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(configContents.getBytes()));
            configEle = new StAXOMBuilder(xmlSR).getDocumentElement();
            OMAttribute attribute = configEle.getAttribute(new QName("name"));
            serviceId = attribute.getAttributeValue();
        }
        catch (Exception e) {
            throw new AxisFault("Error while converting the contents echoed to an OMElement", (Throwable)e);
        }
        Iterator queries = configEle.getChildrenWithName(new QName("query"));
        while (queries.hasNext()) {
            OMElement query = (OMElement)queries.next();
            Iterator results = query.getChildrenWithName(new QName("result"));
            while (results.hasNext()) {
                OMElement result = (OMElement)results.next();
                OMAttribute rowNameAttribute = result.getAttribute(new QName("rowname"));
                if (rowNameAttribute == null) continue;
                String attValue = rowNameAttribute.getAttributeValue();
                result.removeAttribute(rowNameAttribute);
                result.addAttribute(OMAbstractFactory.getOMFactory().createOMAttribute("rowName", OMAbstractFactory.getOMFactory().createOMNamespace("", ""), attValue));
            }
            Iterator params = query.getChildrenWithName(new QName("param"));
            while (params.hasNext()) {
                OMElement param = (OMElement)params.next();
                OMAttribute sqlTypeAttribute = param.getAttribute(new QName("sqltype"));
                if (sqlTypeAttribute == null) continue;
                String attValue = sqlTypeAttribute.getAttributeValue();
                param.removeAttribute(sqlTypeAttribute);
                param.addAttribute(OMAbstractFactory.getOMFactory().createOMAttribute("sqlType", OMAbstractFactory.getOMFactory().createOMNamespace("", ""), attValue));
            }
        }
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            String axis2RepoDirectory = this.configCtx.getAxisConfiguration().getRepository().getPath();
            String repoDirectory = (String)this.configCtx.getProperty("local_org.wso2.ws.dataservice.db_service_repo");
            String fileExtension = (String)this.configCtx.getProperty("local_org.wso2.ws.dataservice.db_service_extension");
            String dataServiceDirectory = axis2RepoDirectory + File.separator + repoDirectory;
            dataServiceFilePath = dataServiceDirectory + File.separator + serviceId + "." + fileExtension;
            File directory = new File(dataServiceDirectory);
            directory.mkdirs();
            File file = new File(dataServiceFilePath);
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new AxisFault("Error while creating the file for the new service config file for the new service " + serviceId, (Throwable)e);
            }
        } else {
            dataServiceFilePath = (String)axisService.getParameter("org.wso2.ws.dataservice.db_service_config_file").getValue();
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(dataServiceFilePath));
            configEle.serialize((Writer)out);
            out.close();
        }
        catch (IOException e) {
            throw new AxisFault("Error while writing the contents for the service config file for the new service " + serviceId, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new AxisFault("Error while serializing the config OMElement for the service " + serviceId, (Throwable)e);
        }
    }

    public OMElement echoDataElement(String dataElement) throws AxisFault {
        OMElement returnEle;
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        if (Utils.isURL((String)axis2Repo)) {
            throw new AxisFault("WSAS is running from a URL repository " + axis2Repo + ". Can not create Data Services for URL repositories");
        }
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(dataElement.getBytes()));
            returnEle = new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (Exception e) {
            throw new AxisFault("Error while converting the contents echoed to an OMElement", (Throwable)e);
        }
        return returnEle;
    }

    public DBServerData[] getDatabaseUrlDriverList() {
        ArrayList<DBServerData> databaseServers = new ArrayList<DBServerData>();
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        OMElement documentElement = serverConfiguration.getDocumentElement();
        OMElement databaseServersElement = documentElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "DatabaseServers"));
        Iterator serverElementIterator = databaseServersElement.getChildrenWithName(new QName("http://www.wso2.org/products/wsas", "Server"));
        while (serverElementIterator.hasNext()) {
            OMElement serverElement = (OMElement)serverElementIterator.next();
            OMElement serverIdElement = serverElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "Id"));
            OMElement jdbcUrlElement = serverElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "JdbcURL"));
            OMElement driverClassElement = serverElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "DriverClass"));
            DBServerData databaseServerData = new DBServerData();
            databaseServerData.setServerId(serverIdElement.getText());
            databaseServerData.setJdbcUrl(jdbcUrlElement.getText());
            databaseServerData.setDriverClass(driverClassElement.getText());
            databaseServers.add(databaseServerData);
        }
        DBServerData[] databaseServerList = new DBServerData[databaseServers.size()];
        databaseServers.toArray(databaseServerList);
        return databaseServerList;
    }
}

