/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.admin.service.AbstractAdmin;
import org.wso2.wsas.admin.service.util.EJBAppServerData;
import org.wso2.wsas.admin.service.util.EJBProviderData;
import org.wso2.wsas.admin.service.util.ServerData;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.EJBAppServerDO;
import org.wso2.wsas.persistence.dataobject.EJBProviderDO;
import org.wso2.wsas.persistence.exception.EJBAppServerAlreadyExistsException;
import org.wso2.wsas.persistence.exception.EJBConfigurationAlreadyExistsException;

public class EJBProviderAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog((Class)EJBProviderAdmin.class);
    private PersistenceManager pm = new PersistenceManager();

    public ServerData getServerData() throws AxisFault {
        return new ServerData("WSO2 WSAS", this.getAxisConfig().getRepository().toString());
    }

    public void addApplicationServer(String providerURL, String jndiContextClass, String userName, String password, String appServerType) throws AxisFault {
        EJBAppServerDO ejbAppServerDO = new EJBAppServerDO();
        ejbAppServerDO.setAppServerType(appServerType);
        ejbAppServerDO.setJndiContextClass(jndiContextClass);
        ejbAppServerDO.setPassword(password);
        ejbAppServerDO.setUserName(userName);
        ejbAppServerDO.setProviderURL(providerURL);
        try {
            this.pm.addEJBAppServerConfiguration(ejbAppServerDO);
        }
        catch (EJBAppServerAlreadyExistsException e) {
            throw new AxisFault(e.getMessage());
        }
    }

    public void addEJBConfiguration(String providerURL, String jndiContextClass, String userName, String password, String beanJNDIName, String homeInterface, String remoteInterface, String appServerType) throws AxisFault {
        EJBProviderDO ejbProvider = new EJBProviderDO();
        ejbProvider.setBeanJNDIName(beanJNDIName);
        ejbProvider.setHomeInterface(homeInterface);
        ejbProvider.setJndiContextClass(jndiContextClass);
        ejbProvider.setPassword(password);
        ejbProvider.setProviderURL(providerURL);
        ejbProvider.setRemoteInterface(remoteInterface);
        ejbProvider.setUserName(userName);
        ejbProvider.setAppServerType(appServerType);
        try {
            this.pm.addEJBConfiguration(ejbProvider);
        }
        catch (EJBConfigurationAlreadyExistsException e) {
            throw new AxisFault(e.getMessage());
        }
    }

    public EJBProviderData[] getEJBConfigurations() throws AxisFault {
        EJBProviderDO[] ejbProviders = this.pm.getEJBConfigurations();
        if (ejbProviders == null || ejbProviders.length == 0) {
            return new EJBProviderData[0];
        }
        EJBProviderData[] ejbProviderDataObjs = new EJBProviderData[ejbProviders.length];
        for (int i = 0; i < ejbProviders.length; ++i) {
            EJBProviderDO ejbProviderDO = ejbProviders[i];
            EJBProviderData ejbProviderData = new EJBProviderData();
            ejbProviderData.setBeanJNDIName(ejbProviderDO.getBeanJNDIName());
            ejbProviderData.setHomeInterface(ejbProviderDO.getHomeInterface());
            ejbProviderData.setJndiContextClass(ejbProviderDO.getJndiContextClass());
            ejbProviderData.setPassword(ejbProviderDO.getPassword());
            ejbProviderData.setProviderURL(ejbProviderDO.getProviderURL());
            String remoteInterface = ejbProviderDO.getRemoteInterface();
            ejbProviderData.setRemoteInterface(remoteInterface);
            ejbProviderData.setUserName(ejbProviderDO.getUserName());
            ejbProviderData.setServiceName(remoteInterface.substring(remoteInterface.lastIndexOf(46) + 1));
            ejbProviderDataObjs[i] = ejbProviderData;
        }
        return ejbProviderDataObjs;
    }

    public EJBProviderDO getEJBConfiguration(String beanJNDIName, String jnpProviderUrl) throws AxisFault {
        try {
            return this.pm.getEJBConfiguration(beanJNDIName, jnpProviderUrl);
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage());
        }
    }

    public void deleteEJBConfiguration(String beanJNDIName, String jnpProviderUrl) throws AxisFault {
        try {
            this.pm.removeEJBConfiguration(beanJNDIName, jnpProviderUrl);
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage());
        }
    }

    public EJBAppServerData[] getAppServerNameList() {
        ArrayList<EJBAppServerData> ejbAppServers = new ArrayList<EJBAppServerData>();
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        OMElement documentElement = serverConfiguration.getDocumentElement();
        OMElement ejbAppServersElement = documentElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "EJBApplicationServers"));
        Iterator serverElementIterator = ejbAppServersElement.getChildrenWithName(new QName("http://www.wso2.org/products/wsas", "Server"));
        while (serverElementIterator.hasNext()) {
            OMElement serverElement = (OMElement)serverElementIterator.next();
            OMElement serverIdElement = serverElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "Id"));
            OMElement serverNameElement = serverElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "Name"));
            OMElement providerURLElement = serverElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "ProviderURL"));
            OMElement jndiContextClassElement = serverElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wsas", "JNDIContextClass"));
            EJBAppServerData ejbAppServerData = new EJBAppServerData();
            ejbAppServerData.setServerId(serverIdElement.getText());
            ejbAppServerData.setServerName(serverNameElement.getText());
            ejbAppServerData.setProviderURL(providerURLElement.getText());
            ejbAppServerData.setJndiContextClass(jndiContextClassElement.getText());
            ejbAppServers.add(ejbAppServerData);
        }
        EJBAppServerData[] ejbAppServerList = new EJBAppServerData[ejbAppServers.size()];
        ejbAppServers.toArray(ejbAppServerList);
        return ejbAppServerList;
    }

    public EJBAppServerData[] getEJBAppServerConfigurations() {
        EJBAppServerDO[] ejbAppServers = this.pm.getEJBAppServerConfigurations();
        EJBAppServerData[] ejbAppServerConfigurations = new EJBAppServerData[ejbAppServers.length];
        for (int a = 0; a < ejbAppServers.length; ++a) {
            ejbAppServerConfigurations[a] = new EJBAppServerData();
            ejbAppServerConfigurations[a].setAppServerType(ejbAppServers[a].getAppServerType());
            ejbAppServerConfigurations[a].setProviderURL(ejbAppServers[a].getProviderURL());
        }
        return ejbAppServerConfigurations;
    }
}

