/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.wso2.wsas.admin.service.AbstractAdmin;
import org.wso2.wsas.admin.service.util.AdminAuthenticator;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.exception.ServiceUserNotFoundException;
import org.wso2.wsas.util.ParameterUtil;
import org.wso2.wsas.util.PolicyUtil;

public class GlobalAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog((Class)GlobalAdmin.class);
    private PersistenceManager pm = new PersistenceManager();

    public void restoreDefaults() {
        this.pm.restoreDefaults();
    }

    public String[] listGlobalPhaseHandlers(int flow, String phaseName) throws AxisFault {
        String[] handlers = null;
        switch (flow) {
            case 1: {
                ArrayList inflow = this.getAxisConfig().getInFlowPhases();
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    ArrayList hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
            case 2: {
                ArrayList phases = this.getAxisConfig().getOutFlowPhases();
                for (int i = 0; i < phases.size(); ++i) {
                    Phase phase = (Phase)phases.get(i);
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    ArrayList hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
            case 3: {
                ArrayList inflow = this.getAxisConfig().getInFaultFlowPhases();
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    ArrayList hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
            case 4: {
                ArrayList inflow = this.getAxisConfig().getOutFaultFlowPhases();
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    ArrayList hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
        }
        return handlers;
    }

    public OMElement[] getDeclaredSystemParameters() throws AxisFault {
        ArrayList parameters = this.getAxisConfig().getParameters();
        OMElement[] paraElements = new OMElement[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            paraElements[i] = parameter.getParameterElement();
        }
        return paraElements;
    }

    public void setSystemParameter(OMElement parameterElement) throws AxisFault {
        Parameter parameter = ParameterUtil.createParameter((OMElement)parameterElement);
        this.getAxisConfig().addParameter(parameter);
    }

    public String[] listGlobalPhases(int flow) throws AxisFault {
        String[] phaseNames = null;
        switch (flow) {
            case 1: {
                ArrayList inflow = this.getAxisConfig().getInFlowPhases();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
            case 2: {
                ArrayList inflow = this.getAxisConfig().getOutFlowPhases();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
            case 3: {
                ArrayList inflow = this.getAxisConfig().getInFaultFlowPhases();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
            case 4: {
                ArrayList inflow = this.getAxisConfig().getOutFaultFlowPhases();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
        }
        return phaseNames;
    }

    public boolean login(String username, String password) throws AxisFault {
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        ServiceGroupContext sgCtx = msgCtx.getServiceGroupContext();
        if (username == null || password == null || username.trim().equals("") || password.trim().equals("")) {
            sgCtx.setProperty("wso2wsas.admin.logged.in", (Object)"false");
            return false;
        }
        boolean loggedIn = new AdminAuthenticator().authenticate(username, password);
        SimpleDateFormat date = new SimpleDateFormat("'['yyyy-MM-dd HH:mm:ss,SSSS']'");
        Date currentTime = Calendar.getInstance().getTime();
        ServiceUserDO user = this.pm.getUser(username);
        String remoteIP = (String)msgCtx.getProperty("REMOTE_ADDR");
        if (loggedIn) {
            sgCtx.setProperty("wso2wsas.admin.logged.in", (Object)"true");
            log.info((Object)("Administrator '" + username + "' logged in at " + date.format(currentTime) + " from IP address " + remoteIP));
            if (user.getLastLoggedIn() != null) {
                log.info((Object)("Last successful login at " + date.format(user.getLastLoggedIn()) + " from IP Address " + user.getLastLoginIP()));
            }
            if (user.getLastFailedLogIn() != null) {
                log.info((Object)("Last failed login at " + date.format(user.getLastFailedLogIn()) + " from IP Address " + user.getLastFailedLoginIP()));
            }
            user.setLastLoggedIn(currentTime);
            user.setLastLoginIP(remoteIP);
            try {
                this.pm.updateUser(user);
            }
            catch (ServiceUserNotFoundException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            return true;
        }
        sgCtx.removeProperty("wso2wsas.admin.logged.in");
        if (user != null) {
            log.warn((Object)("Failed login attempt by Administrator '" + username + "' at " + date.format(currentTime) + " from IP address " + remoteIP));
            user.setLastFailedLogIn(currentTime);
            user.setLastFailedLoginIP(remoteIP);
            try {
                this.pm.updateUser(user);
            }
            catch (ServiceUserNotFoundException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        } else {
            log.warn((Object)("Failed Administrator login attempt by non-existent Administrator '" + username + "' at " + date.format(currentTime) + " from IP address " + remoteIP));
        }
        return false;
    }

    public void serverRegistered() {
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        configCtx.setProperty("wso2wsas.server.registered", (Object)"true");
        this.pm.updateConfigurationProperty("wso2wsas.server.registered", "true");
    }

    public boolean isServerRegistered() {
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        String serverReg = (String)configCtx.getProperty("wso2wsas.server.registered");
        if (serverReg == null && (serverReg = this.pm.getConfigurationProperty("wso2wsas.server.registered")) == null) {
            serverReg = "false";
            this.pm.updateConfigurationProperty("wso2wsas.server.registered", "false");
            configCtx.setProperty("wso2wsas.server.registered", (Object)"false");
        }
        return serverReg.equals("true");
    }

    public void logout() throws AxisFault {
        MessageContext.getCurrentMessageContext().getServiceGroupContext().getProperties().clear();
    }

    public boolean deployService(OMElement element) throws AxisFault {
        try {
            if (element == null) {
                throw new AxisFault("Element is null");
            }
            String fileName = element.getLocalName();
            OMNode node = element.getFirstOMChild();
            if (node instanceof OMText) {
                OMText txt = (OMText)node;
                String repo = this.getAxisConfig().getRepository().getPath();
                DataHandler expectedDH = (DataHandler)txt.getDataHandler();
                File serviceDir = new File(repo, "services");
                File file = new File(serviceDir, fileName);
                FileOutputStream out = new FileOutputStream(file);
                expectedDH.writeTo((OutputStream)out);
                out.flush();
                ((OutputStream)out).close();
                return true;
            }
            throw new AxisFault("Invalid Message");
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public boolean deployModule(OMElement element) throws AxisFault {
        try {
            if (element == null) {
                throw new AxisFault("Element null");
            }
            String fileName = element.getLocalName();
            OMNode node = element.getFirstOMChild();
            if (node instanceof OMText) {
                OMText txt = (OMText)node;
                String repo = this.getAxisConfig().getRepository().getPath();
                DataHandler expectedDH = (DataHandler)txt.getDataHandler();
                File moduleDir = new File(repo, "modules");
                File file = new File(moduleDir, fileName);
                FileOutputStream out = new FileOutputStream(file);
                expectedDH.writeTo((OutputStream)out);
                out.flush();
                ((OutputStream)out).close();
                AxisModule module = DeploymentEngine.buildModule((File)file, (AxisConfiguration)this.getAxisConfig());
                this.getAxisConfig().addModule(module);
                return true;
            }
            throw new AxisFault("Invalid Message");
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public OMElement getPolicy() throws AxisFault {
        PolicyInclude globalPolicyInclude = this.getAxisConfig().getPolicyInclude();
        Policy globalPolicy = globalPolicyInclude.getPolicy();
        if (globalPolicy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement();
        }
        return PolicyUtil.getPolicyAsOMElement((Policy)globalPolicy);
    }

    public void setPolicy(OMElement policyElement) throws AxisFault {
        Policy globalPolicy;
        try {
            globalPolicy = PolicyUtil.getPolicyFromOMElement((OMElement)policyElement);
        }
        catch (Exception ex) {
            throw new AxisFault("Cannot convert the OMElement to Policy", (Throwable)ex);
        }
        PolicyInclude globalPolicyInclude = this.getAxisConfig().getPolicyInclude();
        globalPolicyInclude.setPolicy(globalPolicy);
    }

    public boolean ping() {
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        ServiceGroupContext serviceGroupContext = msgCtx.getServiceGroupContext();
        Object property = serviceGroupContext.getProperty("wso2wsas.admin.logged.in");
        if (property == null) {
            return false;
        }
        String status = (String)property;
        return JavaUtils.isTrue((String)status);
    }
}

