/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.utils.MemoryAppender;

public class LogViewAdmin {
    private static Log log = LogFactory.getLog((Class)LogViewAdmin.class);

    public String[] getLogs() throws AxisFault {
        int DEFAULT_NO_OF_LOGS = 100;
        Appender appender = Logger.getRootLogger().getAppender("WSO2WSAS_MEMORY");
        if (appender instanceof MemoryAppender) {
            MemoryAppender memoryAppender = (MemoryAppender)appender;
            if (memoryAppender.getCircularQueue() == null) {
                return new String[]{"--- No log entries found. You may try increasing the log level ---"};
            }
            int definedamount = memoryAppender.getBufferSize();
            Object[] objects = definedamount < 1 ? memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS) : memoryAppender.getCircularQueue().getObjects(definedamount);
            if (memoryAppender.getCircularQueue().getObjects(definedamount) == null || memoryAppender.getCircularQueue().getObjects(definedamount).length == 0) {
                return new String[]{"--- No log entries found. You may try increasing the log level ---"};
            }
            String[] resp = new String[objects.length];
            Layout layout = memoryAppender.getLayout();
            for (int i = 0; i < objects.length; ++i) {
                LoggingEvent logEvt = (LoggingEvent)objects[i];
                if (logEvt == null) continue;
                resp[i] = layout.format(logEvt);
            }
            return resp;
        }
        return new String[]{"The log must be configured to use the org.wso2.utils.MemoryAppender to view entries on the admin console"};
    }

    public String[] getLogsForSingleLogLevel(String type) throws AxisFault {
        if (type == null) {
            log.info((Object)"Type can not be null");
        }
        if ("ALL".equals(type)) {
            return this.getLogs();
        }
        return this.getLogsForType(type);
    }

    public String[] searchLog(String type, String keyword) throws AxisFault {
        if (keyword == null) {
            log.info((Object)"Key word can not be null");
        }
        if (type == null) {
            log.info((Object)"Type can not be null");
        }
        if ("ALL".equals(type)) {
            if ("".equals(keyword)) {
                return this.getLogs();
            }
            return this.getLogsForKey(keyword);
        }
        String[] filerByType = this.getLogsForType(type);
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < filerByType.length; ++i) {
            if (filerByType[i] == null || filerByType[i].indexOf(keyword) <= -1) continue;
            resultList.add(filerByType[i]);
        }
        if (resultList.isEmpty()) {
            return new String[]{"--- No log entries found for the keyword " + keyword + " and the log level " + type + "---"};
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    private String[] getLogsForKey(String keyword) {
        int DEFAULT_NO_OF_LOGS = 100;
        Appender appender = Logger.getRootLogger().getAppender("WSO2WSAS_MEMORY");
        if (appender instanceof MemoryAppender) {
            MemoryAppender memoryAppender = (MemoryAppender)appender;
            if (memoryAppender.getCircularQueue() == null) {
                return new String[]{"--- No log entries found for the  " + keyword + " ---"};
            }
            int definedAmount = memoryAppender.getBufferSize();
            Object[] objects = definedAmount < 1 ? memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS) : memoryAppender.getCircularQueue().getObjects(definedAmount);
            if (memoryAppender.getCircularQueue().getObjects(definedAmount) == null || memoryAppender.getCircularQueue().getObjects(definedAmount).length == 0) {
                return new String[]{"--- No log entries found for the  " + keyword + " ---"};
            }
            Layout layout = memoryAppender.getLayout();
            ArrayList<String> resultList = new ArrayList<String>();
            for (int i = 0; i < objects.length; ++i) {
                String result;
                LoggingEvent logEvt = (LoggingEvent)objects[i];
                if (logEvt == null || (result = layout.format(logEvt)) == null || result.indexOf(keyword) <= -1) continue;
                resultList.add(result);
            }
            if (resultList.isEmpty()) {
                return new String[]{"--- No log entries found for the " + keyword + " ---"};
            }
            return resultList.toArray(new String[resultList.size()]);
        }
        return new String[]{"The log must be configured to use the org.wso2.utils.MemoryAppender to view entries on the admin console"};
    }

    private String[] getLogsForType(String type) {
        int DEFAULT_NO_OF_LOGS = 100;
        Appender appender = Logger.getRootLogger().getAppender("WSO2WSAS_MEMORY");
        if (appender instanceof MemoryAppender) {
            MemoryAppender memoryAppender = (MemoryAppender)appender;
            if (memoryAppender.getCircularQueue() == null) {
                return new String[]{"--- No log entries found for the  " + type + " ---"};
            }
            int definedAmount = memoryAppender.getBufferSize();
            Object[] objects = definedAmount < 1 ? memoryAppender.getCircularQueue().getObjects(DEFAULT_NO_OF_LOGS) : memoryAppender.getCircularQueue().getObjects(definedAmount);
            if (memoryAppender.getCircularQueue().getObjects(definedAmount) == null || memoryAppender.getCircularQueue().getObjects(definedAmount).length == 0) {
                return new String[]{"--- No log entries found for the  " + type + " ---"};
            }
            Layout layout = memoryAppender.getLayout();
            ArrayList<String> resultList = new ArrayList<String>();
            for (int i = 0; i < objects.length; ++i) {
                String result;
                LoggingEvent logEvt = (LoggingEvent)objects[i];
                if (logEvt == null || (result = layout.format(logEvt)) == null || result.indexOf(type) <= -1 || result.indexOf(type) >= 4) continue;
                resultList.add(result);
            }
            if (resultList.isEmpty()) {
                return new String[]{"--- No log entries found for the " + type + " ---"};
            }
            return resultList.toArray(new String[resultList.size()]);
        }
        return new String[]{"The log must be configured to use the org.wso2.utils.MemoryAppender to view entries through the admin console"};
    }

    public boolean clearLogs() {
        Appender appender = Logger.getRootLogger().getAppender("WSO2WSAS_MEMORY");
        if (appender instanceof MemoryAppender) {
            try {
                MemoryAppender memoryAppender = (MemoryAppender)appender;
                if (memoryAppender.getCircularQueue() != null) {
                    memoryAppender.getCircularQueue().clear();
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

