/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyRegistry;
import org.apache.rahas.impl.SCTIssuerConfig;
import org.apache.rahas.impl.TokenCancelerConfig;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.wsas.admin.service.AbstractAdmin;
import org.wso2.wsas.admin.service.ServiceAdmin;
import org.wso2.wsas.admin.service.util.ModuleMetaData;
import org.wso2.wsas.admin.service.util.PolicyData;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.AbstractDataObject;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.persistence.dataobject.ModuleDO;
import org.wso2.wsas.persistence.dataobject.ModuleIdentifierDO;
import org.wso2.wsas.persistence.dataobject.ModuleParameterDO;
import org.wso2.wsas.persistence.dataobject.ModulePolicyDO;
import org.wso2.wsas.persistence.dataobject.SecurityScenarioDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;
import org.wso2.wsas.persistence.exception.ModuleNotFoundException;
import org.wso2.wsas.persistence.exception.ModulePolicyNotFoundException;
import org.wso2.wsas.security.RahasUtil;
import org.wso2.wsas.security.ServerCrypto;
import org.wso2.wsas.util.AdminFilter;
import org.wso2.wsas.util.ParameterUtil;
import org.wso2.wsas.util.PolicyUtil;

public class ModuleAdmin
extends AbstractAdmin {
    private static final String RAHAS = "rahas";
    private static final String RAMPART = "rampart";
    private static Log log = LogFactory.getLog((Class)ModuleAdmin.class);
    private PersistenceManager pm = new PersistenceManager();

    public ModuleAdmin() {
    }

    public ModuleAdmin(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
    }

    public ModuleMetaData[] listModules() throws AxisFault {
        ArrayList<ModuleMetaData> moduleList = new ArrayList<ModuleMetaData>();
        Iterator moduleIter = this.getAxisConfig().getModules().values().iterator();
        while (moduleIter.hasNext()) {
            AxisModule axisModule = (AxisModule)moduleIter.next();
            if (AdminFilter.isFilteredOutModule((String)axisModule.getName())) continue;
            ModuleMetaData md = new ModuleMetaData();
            md.setModulename(axisModule.getName());
            md.setModuleId(axisModule.getName());
            md.setEngaged("" + this.getAxisConfig().isEngaged(axisModule));
            String description = axisModule.getModuleDescription();
            if (description != null) {
                md.setDescription(description);
            } else {
                md.setDescription("No description found");
            }
            String moduleVersion = axisModule.getVersion();
            if (moduleVersion != null) {
                md.setModuleVersion(moduleVersion);
            } else {
                md.setModuleVersion("");
            }
            moduleList.add(md);
        }
        return moduleList.toArray(new ModuleMetaData[moduleList.size()]);
    }

    public ModuleMetaData[] listGloballyEngagesModules() throws AxisFault {
        ArrayList<ModuleMetaData> emodules = new ArrayList<ModuleMetaData>();
        Iterator engagedModules = this.getAxisConfig().getEngagedModules().iterator();
        while (engagedModules.hasNext()) {
            AxisModule axisModule = (AxisModule)engagedModules.next();
            String name = axisModule.getName();
            if (AdminFilter.isFilteredOutModule((String)name)) continue;
            emodules.add(new ModuleMetaData(name, axisModule.getVersion()));
        }
        return emodules.toArray(new ModuleMetaData[emodules.size()]);
    }

    public ModuleMetaData[] listServiceModules(String serviceName) throws AxisFault {
        AxisService service = this.getAxisConfig().getService(serviceName);
        if (service == null) {
            throw new AxisFault("Service not found or invalid service - " + serviceName);
        }
        ArrayList<ModuleMetaData> engageModules = new ArrayList<ModuleMetaData>();
        Iterator engagedModulesIter = service.getEngagedModules().iterator();
        while (engagedModulesIter.hasNext()) {
            AxisModule module = (AxisModule)engagedModulesIter.next();
            if (this.getAxisConfig().isEngaged(module) || service.getParent().isEngaged(module) || AdminFilter.isFilteredOutModule((String)module.getName())) continue;
            engageModules.add(new ModuleMetaData(module.getName(), module.getVersion()));
        }
        return engageModules.toArray(new ModuleMetaData[engageModules.size()]);
    }

    public ModuleMetaData[] listServiceGroupModules(String serviceGroupId) throws AxisFault {
        AxisServiceGroup asg = this.getAxisConfig().getServiceGroup(serviceGroupId);
        if (asg == null) {
            throw new AxisFault("Service Group " + serviceGroupId + " not found or invalid service group");
        }
        ArrayList<ModuleMetaData> engagedModules = new ArrayList<ModuleMetaData>();
        Iterator iterator = asg.getEngagedModules().iterator();
        while (iterator.hasNext()) {
            AxisModule axisModule = (AxisModule)iterator.next();
            if (this.getAxisConfig().isEngaged(axisModule) || AdminFilter.isFilteredOutModule((String)axisModule.getName())) continue;
            engagedModules.add(new ModuleMetaData(axisModule.getName(), axisModule.getVersion()));
        }
        return engagedModules.toArray(new ModuleMetaData[engagedModules.size()]);
    }

    public ModuleMetaData[] listOperationModules(String serviceName, String operationName) throws AxisFault {
        AxisService service = this.getAxisConfig().getService(serviceName);
        if (service == null) {
            throw new AxisFault("Service not found or invalid service");
        }
        AxisOperation operation = service.getOperation(new QName(operationName));
        if (operation == null) {
            throw new AxisFault("Operation name invalid");
        }
        ArrayList<ModuleMetaData> emodules = new ArrayList<ModuleMetaData>();
        Iterator engagedModules = operation.getEngagedModules().iterator();
        while (engagedModules.hasNext()) {
            AxisModule module = (AxisModule)engagedModules.next();
            if (service.isEngaged(module) || service.getParent().isEngaged(module) || this.getAxisConfig().isEngaged(module) || AdminFilter.isFilteredOutModule((String)module.getName())) continue;
            emodules.add(new ModuleMetaData(module.getName(), module.getVersion()));
        }
        return emodules.toArray(new ModuleMetaData[emodules.size()]);
    }

    public ModuleMetaData getModuleInfo(String moduleId, String moduleVersion) throws AxisFault {
        ModuleMetaData moduleMetaData = new ModuleMetaData();
        AxisModule axisModule = this.getAxisModule(moduleId, moduleVersion);
        moduleMetaData.setModulename(axisModule.getName());
        moduleMetaData.setModuleId(moduleId);
        moduleMetaData.setEngaged(this.getAxisConfig().isEngaged(axisModule) + "");
        String description = axisModule.getModuleDescription();
        if (description != null) {
            moduleMetaData.setDescription(description);
        } else {
            moduleMetaData.setDescription("No description found");
        }
        moduleMetaData.setModuleVersion(moduleVersion);
        return moduleMetaData;
    }

    public Object[] getModuleStatus(String moduleId, String moduleVersion) throws AxisFault {
        throw new AxisFault("Operation not implemented");
    }

    public String engageModuleForSystem(String moduleId, String moduleVersion) throws AxisFault {
        String moduleName;
        AxisConfiguration axisConfig = this.getAxisConfig();
        AxisModule axisModule = axisConfig.getModule(moduleName = Utils.getModuleName((String)moduleId, (String)moduleVersion));
        if (axisModule == null) {
            throw new AxisFault("Invalid module, " + moduleName);
        }
        if (axisConfig.isEngaged(axisModule)) {
            return Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module is already engaged globally.";
        }
        if (moduleId.equalsIgnoreCase(RAHAS)) {
            AxisModule rampartModule = axisConfig.getModule(RAMPART);
            if (rampartModule == null) {
                throw new AxisFault("Rampart module not found! <br/> In order to engage the Rahas module, the Rampart module should be present.");
            }
            if (!axisConfig.isEngaged(rampartModule)) {
                this.engageModuleForSystem(rampartModule.getName(), rampartModule.getVersion());
            }
        }
        try {
            axisConfig.engageModule(axisModule);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error occurred while " + Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module was trying to be engaged to the service"), (Throwable)axisFault);
            return "An error occurred while trying to engage the " + Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module.\n" + "This may be due to either the module being faulty, or the system, service(s) or" + " operations(s) already being engaged to a different version of the " + moduleId + " module. Please disengage this module from the system, service(s) or " + "operation(s) and retry.";
        }
        ModuleDO moduleDO = this.pm.getModule(moduleId, moduleVersion);
        if (moduleDO != null) {
            moduleDO.setIsGloballyEngaged(true);
            try {
                this.pm.updateModule(moduleDO);
            }
            catch (ModuleNotFoundException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        } else {
            log.warn((Object)("Module " + Utils.getModuleName((String)moduleId, (String)moduleVersion) + " not found in database"));
        }
        this.disengageThrottleModuleFromAdminServices(moduleId, axisConfig, axisModule);
        return Utils.getModuleName((String)moduleId, (String)moduleVersion) + " was successfully engaged globally.";
    }

    private void disengageThrottleModuleFromAdminServices(String moduleId, AxisConfiguration axisConfig, AxisModule axisModule) throws AxisFault {
        if (moduleId.equals("wso2throttle")) {
            AxisServiceGroup statSG;
            AxisServiceGroup codegenSG;
            AxisServiceGroup adminSG = axisConfig.getServiceGroup("wso2wsas-administration");
            if (adminSG != null) {
                adminSG.disengageModule(axisModule);
            }
            if ((codegenSG = axisConfig.getServiceGroup("wso2codegen")) != null) {
                codegenSG.disengageModule(axisModule);
            }
            if ((statSG = axisConfig.getServiceGroup("wso2statistics")) != null) {
                statSG.disengageModule(axisModule);
            }
        }
    }

    public boolean disengageModuleFromSystem(String moduleId, String moduleVersion) throws AxisFault {
        block13: {
            if (moduleId.equals("addressing")) {
                throw new AxisFault("addressing cannot be disengaged since this is a core module required by axis2 to support services deployed in the soapsession scope. Services deployed in this scope require the addressing module to be engaged. Also, the sandesha2 module requires addressing.");
            }
            AxisModule module = this.getAxisModule(moduleId, moduleVersion);
            try {
                AxisConfiguration axisConfig = this.getAxisConfig();
                if (!axisConfig.isEngaged(module)) break block13;
                if (moduleId.equalsIgnoreCase(RAHAS)) {
                    HashMap services = axisConfig.getServices();
                    Iterator iter = services.values().iterator();
                    while (iter.hasNext()) {
                        this.checkRahasDisengagingForService((AxisService)iter.next(), moduleId);
                    }
                } else if (moduleId.equalsIgnoreCase(RAMPART)) {
                    AxisModule rahasModule = axisConfig.getModule(RAHAS);
                    if (axisConfig.isEngaged(rahasModule)) {
                        throw new AxisFault("Cannot globally disengage Rampart since Rahas is globally engaged. Disengage Rahas and try again.");
                    }
                    HashMap services = axisConfig.getServices();
                    Iterator iter = services.values().iterator();
                    while (iter.hasNext()) {
                        this.checkRampartDisengagingForService((AxisService)iter.next(), moduleId);
                    }
                }
                axisConfig.disengageModule(module);
            }
            catch (Exception e) {
                log.error((Object)e);
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        ModuleDO moduleDO = this.pm.getModule(moduleId, moduleVersion);
        if (moduleDO != null) {
            moduleDO.setIsGloballyEngaged(false);
            try {
                this.pm.updateModule(moduleDO);
            }
            catch (ModuleNotFoundException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        } else {
            log.warn((Object)("Module " + moduleId + " not found in database"));
        }
        return true;
    }

    private void checkRampartDisengagingForService(AxisService service, String moduleId) throws AxisFault {
        if (moduleId.equalsIgnoreCase(RAMPART)) {
            String serviceName = service.getName();
            ServiceDO serviceDO = this.pm.getService(serviceName, "$EMPTY$");
            if (serviceDO == null) {
                return;
            }
            if (serviceDO.getSecurityScenario() != null) {
                throw new AxisFault("Rampart cannot be disengaged since " + serviceName + " service is associated with a security scenario.");
            }
            AxisModule rahasModule = this.axisConfig.getModule(RAHAS);
            if (rahasModule != null) {
                if (service.isEngaged(rahasModule)) {
                    throw new AxisFault("Rampart cannot be disengaged since Rahas is engaged to " + serviceName + " service");
                }
                Iterator iter = service.getOperations();
                while (iter.hasNext()) {
                    AxisOperation op = (AxisOperation)iter.next();
                    if (!op.isEngaged(rahasModule)) continue;
                    throw new AxisFault("Rampart cannot be disengaged since Rahas is engaged to " + op.getName().getLocalPart() + " operation in " + serviceName + " service");
                }
            }
        }
    }

    private void checkRahasDisengagingForService(AxisService service, String moduleId) throws AxisFault {
        String serviceName;
        ServiceDO serviceDO;
        if (moduleId.equalsIgnoreCase(RAHAS) && (serviceDO = this.pm.getService(serviceName = service.getName(), "$EMPTY$")) != null) {
            SecurityScenarioDO secScenario = serviceDO.getSecurityScenario();
            AxisModule rahasModule = this.axisConfig.getModule(RAHAS);
            ModuleDO moduleDO = this.pm.getModule(rahasModule.getName(), rahasModule.getVersion());
            if (moduleDO != null && secScenario != null && secScenario.modules.contains(moduleDO)) {
                throw new AxisFault("Rahas cannot be disengaged since " + serviceName + " service is associated with a security scenario which " + "requires the Rahas module.");
            }
        }
    }

    public void removeModule(String moduleId, String moduleVersion) throws AxisFault {
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        if (org.wso2.wsas.util.Utils.isURL((String)axis2Repo)) {
            throw new AxisFault("You are not permitted to remove the " + Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module from the URL repository " + axis2Repo);
        }
        ModuleDO moduleDO = this.pm.getModule(moduleId, moduleVersion);
        if (moduleDO != null && !moduleDO.getSecurityScenarios().isEmpty()) {
            throw new AxisFault("The " + Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module cannot be removed since it is " + "associated with at least one security scenario." + " These security scenarios can be applied to services. " + "Removing " + moduleId + " will make the system inconsistent.");
        }
        if (moduleId.equals("addressing")) {
            throw new AxisFault("addressing cannot be removed since this is a core module required by axis2 to support services deployed in the soapsession scope. Services deployed in this scope require the addressing module to be engaged. Also, the sandesha2 module requires addressing.");
        }
        String fileName = this.getAxisConfig().getModule(moduleId, moduleVersion).getFileName().getPath();
        File file = new File(fileName);
        if (!file.canWrite()) {
            throw new AxisFault("Module file deletion failed. Due to a JVM issue on MS-Windows, module files cannot be deleted!");
        }
        this.disengageModuleFromSystem(moduleId, moduleVersion);
        if (file.exists()) {
            if (!(file.isDirectory() && new FileManipulator().deleteDir(file) || file.delete())) {
                throw new AxisFault("Module file deletion failed. Due to a JVM issue on MS-Windows, module files cannot be deleted!");
            }
        } else {
            throw new AxisFault("Module file " + file.getAbsolutePath() + " not found! ");
        }
        this.pm.deleteModule(moduleId, moduleVersion);
        this.getAxisConfig().removeModule(moduleId, moduleVersion);
    }

    public String engageModuleForServiceGroup(String moduleId, String moduleVersion, String serviceGroupId) throws AxisFault {
        AxisConfiguration axisConfig = this.getAxisConfig();
        AxisServiceGroup asg = axisConfig.getServiceGroup(serviceGroupId);
        if (asg == null) {
            throw new AxisFault("Service group not found");
        }
        AxisModule axisModule = this.getAxisModule(moduleId, moduleVersion);
        if (asg.isEngaged(axisModule)) {
            return "Module " + Utils.getModuleName((String)moduleId, (String)moduleVersion) + " has already been engaged to service group " + serviceGroupId;
        }
        if (moduleId.equalsIgnoreCase(RAHAS)) {
            AxisModule rampartModule = axisConfig.getModule(RAMPART);
            if (rampartModule == null) {
                throw new AxisFault("Rampart module not found! <br/> In order to engage the Rahas module, the Rampart module should be present.");
            }
            if (!asg.isEngaged(rampartModule)) {
                this.engageModuleForServiceGroup(rampartModule.getName(), rampartModule.getVersion(), serviceGroupId);
            }
        }
        Iterator serviceIter = asg.getServices();
        while (serviceIter.hasNext()) {
            AxisService service = (AxisService)serviceIter.next();
            if (!service.isEngaged(axisModule)) continue;
            service.disengageModule(axisModule);
            ServiceDO serviceDO = this.pm.getService(service.getName(), "$EMPTY$");
            this.pm.removeEngagedServiceFromModule(moduleId, moduleVersion, serviceDO);
        }
        asg.engageModule(axisModule);
        this.pm.addEngagedServiceGroupToModule(moduleId, moduleVersion, this.pm.getServiceGroup(serviceGroupId));
        return "Module " + Utils.getModuleName((String)moduleId, (String)moduleVersion) + " successfully engaged to service group " + serviceGroupId;
    }

    public void disengageModuleFromServiceGroup(String moduleId, String moduleVersion, String serviceGroupId) throws AxisFault {
        AxisServiceGroup serviceGrp = this.getAxisConfig().getServiceGroup(serviceGroupId);
        if (serviceGrp == null) {
            throw new AxisFault("Service group " + serviceGroupId + " not found ");
        }
        AxisModule module = this.getAxisModule(moduleId, moduleVersion);
        if (serviceGrp.isEngaged(module)) {
            if (moduleId.equalsIgnoreCase(RAHAS)) {
                Iterator iter = serviceGrp.getServices();
                while (iter.hasNext()) {
                    this.checkRahasDisengagingForService((AxisService)iter.next(), moduleId);
                }
            } else if (moduleId.equalsIgnoreCase(RAMPART)) {
                Iterator iter = serviceGrp.getServices();
                while (iter.hasNext()) {
                    this.checkRampartDisengagingForService((AxisService)iter.next(), moduleId);
                }
            }
            serviceGrp.disengageModule(module);
            this.pm.removeEngagedServiceGroupFromModule(moduleId, moduleVersion, this.pm.getServiceGroup(serviceGroupId));
        }
    }

    public String engageModuleForService(String moduleId, String moduleVersion, String serviceId, String serviceVersion) throws AxisFault {
        AxisConfiguration axisConfig = this.getAxisConfig();
        AxisService axisService = axisConfig.getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("Service not found");
        }
        AxisModule axisModule = this.getAxisModule(moduleId, moduleVersion);
        if (axisConfig.isEngaged(axisModule)) {
            return Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module is globally engaged. You need not engage it to this service.";
        }
        if (axisService.isEngaged(axisModule)) {
            return Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module is already engaged to the " + serviceId + " service";
        }
        if (moduleId.equalsIgnoreCase(RAHAS)) {
            AxisModule rampartModule = axisConfig.getModule(RAMPART);
            if (rampartModule == null) {
                throw new AxisFault("Rampart module not found! <br/> In order to engage the Rahas module, the Rampart module should be present.");
            }
            if (!axisService.isEngaged(rampartModule)) {
                this.engageModuleForService(rampartModule.getName(), rampartModule.getVersion(), serviceId, serviceVersion);
            }
            this.setRahasParameters(serviceId, serviceVersion);
        }
        try {
            axisService.engageModule(axisModule);
        }
        catch (AxisFault e) {
            String msg = "Cannot engage module " + moduleId + (moduleVersion != null ? "-" + moduleVersion : "") + ". You may be trying to engage an older version of an already engaged " + "module. Please disengage the newer version of the module and retry. ";
            log.warn((Object)msg, (Throwable)e);
            return msg;
        }
        ServiceDO serviceDO = this.pm.getService(serviceId, serviceVersion);
        if (serviceDO != null) {
            Iterator iter = serviceDO.getEngagedModules().iterator();
            while (iter.hasNext()) {
                ModuleDO oldModuleDO = (ModuleDO)iter.next();
                if (!oldModuleDO.getModuleIdentifierDO().getName().equals(moduleId)) continue;
                serviceDO.getEngagedModules().remove(oldModuleDO);
                try {
                    this.pm.updateService(serviceDO);
                    this.pm.updateModule(oldModuleDO);
                }
                catch (Exception e) {
                    throw AxisFault.makeFault((Throwable)e);
                }
            }
            this.pm.addEngagedServiceToModule(moduleId, moduleVersion, serviceDO);
            return Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module was successfully engaged to service " + serviceId + (serviceVersion != null ? serviceVersion : "");
        }
        return serviceId + (serviceVersion != null ? serviceVersion : "") + " not found!";
    }

    private void setRahasParameters(String serviceId, String serviceVersion) throws AxisFault {
        ServiceDO serviceDO = this.pm.getService(serviceId, serviceVersion);
        if (serviceDO == null) {
            return;
        }
        KeyStoreDO pkStore = serviceDO.getPrivateKeyStore();
        Properties cryptoProps = new Properties();
        if (pkStore != null) {
            cryptoProps.setProperty("org.wso2.wsas.security.wso2wsas.crypto.keystore", pkStore.getFilePath());
            cryptoProps.setProperty("org.wso2.wsas.security.wso2wsas.crypto.alias", pkStore.getPrivateKeyAlias());
        }
        StringBuffer trustStores = new StringBuffer();
        Iterator tsIter = serviceDO.getTrustedCertStores().iterator();
        while (tsIter.hasNext()) {
            KeyStoreDO trustStore = (KeyStoreDO)tsIter.next();
            trustStores.append(trustStore.getFilePath()).append(",");
        }
        ServiceAdmin serviceAdmin = new ServiceAdmin(this.configCtx);
        cryptoProps.setProperty("org.wso2.wsas.security.wso2wsas.crypto.truststores", trustStores.toString());
        try {
            serviceAdmin.setServiceParameter2(serviceId, RahasUtil.getSCTIssuerConfigParameter((String)ServerCrypto.class.getName(), (Properties)cryptoProps, (int)-1, null, (boolean)true, (boolean)true));
        }
        catch (ServerException e) {
            throw new AxisFault("Could not configure Rahas parameters", (Throwable)e);
        }
        serviceAdmin.setServiceParameter2(serviceId, RahasUtil.getTokenCancelerConfigParameter());
    }

    public void disengageModuleFromService(String moduleId, String moduleVersion, String serviceId, String serviceVersion) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("Service not found");
        }
        AxisModule module = this.getAxisModule(moduleId, moduleVersion);
        if (axisService.isEngaged(module)) {
            if (moduleId.equals("addressing") && axisService.getScope().equals("soapsession")) {
                throw new AxisFault("addressing cannot be disengaged since the " + axisService.getName() + " service is deployed in the soapsession scope. Services deployed " + "in this scope require the addressing module to be engaged.");
            }
            this.checkRahasDisengagingForService(axisService, moduleId);
            this.checkRampartDisengagingForService(axisService, moduleId);
            axisService.disengageModule(module);
            ServiceDO serviceDO = this.pm.getService(serviceId, "$EMPTY$");
            if (serviceDO != null) {
                this.pm.removeEngagedServiceFromModule(moduleId, moduleVersion, serviceDO);
                this.removeRahasParameters(moduleId, serviceId);
            }
        }
    }

    public void forceDisengageModuleFromService(String moduleId, String moduleVersion, String serviceId, String serviceVersion) throws AxisFault {
        AxisService service = this.getAxisConfig().getService(serviceId);
        if (service == null) {
            throw new AxisFault("Service not found");
        }
        AxisModule module = this.getAxisModule(moduleId, moduleVersion);
        if (service.isEngaged(module)) {
            service.disengageModule(module);
            ServiceDO serviceDO = this.pm.getService(serviceId, "$EMPTY$");
            if (serviceDO != null) {
                this.pm.removeEngagedServiceFromModule(moduleId, moduleVersion, serviceDO);
                this.removeRahasParameters(moduleId, serviceId);
            }
        }
    }

    private void removeRahasParameters(String moduleId, String serviceId) throws AxisFault {
        if (moduleId.equals(RAHAS)) {
            ServiceAdmin serviceAdmin = new ServiceAdmin(this.configCtx);
            serviceAdmin.removeServiceParameter(serviceId, SCTIssuerConfig.SCT_ISSUER_CONFIG.getLocalPart());
            serviceAdmin.removeServiceParameter(serviceId, TokenCancelerConfig.TOKEN_CANCELER_CONFIG.getLocalPart());
        }
    }

    public String engageModuleForOperation(String moduleId, String moduleVersion, String serviceId, String serviceVersion, String operationId) throws AxisFault {
        AxisConfiguration axisConfig = this.getAxisConfig();
        AxisService service = axisConfig.getService(serviceId);
        if (service == null) {
            throw new AxisFault("Service not found");
        }
        AxisOperation axisOp = service.getOperation(new QName(operationId));
        if (axisOp == null) {
            throw new AxisFault("Operation not found in the service : " + serviceId);
        }
        AxisModule axisModule = this.getAxisModule(moduleId, moduleVersion);
        if (axisConfig.isEngaged(axisModule)) {
            return Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module is globally engaged. You need not engage it to this operation.";
        }
        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)axisOp.getParent().getParent();
        if (axisServiceGroup.isEngaged(axisModule)) {
            return Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module is engaged to service group " + axisServiceGroup.getServiceGroupName() + ". You need not engage it to this operation.";
        }
        AxisService axisService = (AxisService)axisOp.getParent();
        if (axisService.isEngaged(axisModule)) {
            return Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module is engaged to service " + serviceId + ". You need not engage it to this operation.";
        }
        if (axisOp.isEngaged(axisModule)) {
            return Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module is already engaged to operation " + operationId;
        }
        if (moduleId.equalsIgnoreCase(RAHAS)) {
            AxisModule rampartModule = axisConfig.getModule(RAMPART);
            if (rampartModule == null) {
                throw new AxisFault("Rampart module not found! <br/> In order to engage the Rahas module, the Rampart module should be present.");
            }
            if (!axisOp.isEngaged(rampartModule)) {
                this.engageModuleForOperation(rampartModule.getName(), rampartModule.getVersion(), serviceId, serviceVersion, operationId);
            }
        }
        try {
            axisOp.engageModule(this.getAxisConfig().getModule(axisModule.getName(), axisModule.getVersion()));
        }
        catch (AxisFault axisFault) {
            String msg = "Error while trying to engage module  " + moduleId + "-" + moduleVersion + " to axis operation " + serviceId + "#" + operationId;
            log.warn((Object)msg, (Throwable)axisFault);
            return msg;
        }
        this.pm.addEngagedOperationToModule(moduleId, moduleVersion, this.pm.getOperation(serviceId, "$EMPTY$", axisOp.getName().getLocalPart()));
        return Utils.getModuleName((String)moduleId, (String)moduleVersion) + " module has been successfully engaged to operation " + operationId;
    }

    public void disengageModuleFromOperation(String moduleId, String moduleVersion, String serviceId, String serviceVersion, String operationId) throws AxisFault {
        AxisModule rahasModule;
        AxisService service = this.getAxisConfig().getService(serviceId);
        if (service == null) {
            throw new AxisFault("Service not found");
        }
        AxisOperation axisOp = service.getOperation(new QName(operationId));
        if (axisOp == null) {
            throw new AxisFault("Operation not found in the service : " + serviceId);
        }
        if (moduleId.equalsIgnoreCase(RAMPART) && (rahasModule = this.axisConfig.getModule(RAHAS)) != null && axisOp.isEngaged(rahasModule)) {
            throw new AxisFault("Rampart cannot be disengaged since Rahas is engaged to operation " + operationId + ". Disengage Rahas and try again.");
        }
        AxisModule module = this.getAxisModule(moduleId, moduleVersion);
        if (axisOp.isEngaged(module)) {
            this.checkRampartDisengagingForService((AxisService)axisOp.getParent(), moduleId);
            axisOp.disengageModule(module);
            this.pm.removeEngagedOperationFromModule(moduleId, moduleVersion, this.pm.getOperation(serviceId, "$EMPTY$", axisOp.getName().getLocalPart()));
        }
    }

    public void engageModuleForMessage(String moduleId, String moduleVersion, String serviceId, String serviceVersion, String operationId, String messageLabel) throws AxisFault {
        throw new AxisFault("Not implemented");
    }

    public OMElement[] getModuleParameters(String moduleId, String moduleVersion) throws AxisFault {
        AxisModule module = this.getAxisModule(moduleId, moduleVersion);
        ArrayList parameters = module.getParameters();
        OMElement[] paraElements = new OMElement[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            paraElements[i] = parameter.getParameterElement();
        }
        return paraElements;
    }

    public OMElement getPolicy(String moduleId, String moduleVersion) throws AxisFault {
        AxisModule module = this.getAxisModule(moduleId, moduleVersion);
        PolicyInclude modulePolicyInclude = module.getPolicyInclude();
        Policy modulePolicy = modulePolicyInclude.getPolicy();
        if (modulePolicy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement();
        }
        return PolicyUtil.getPolicyAsOMElement((Policy)modulePolicy);
    }

    public void setPolicy(String moduleId, String moduleVersion, String policyString) throws AxisFault {
        Policy modulePolicy;
        OMElement policyElement;
        ByteArrayInputStream bais = new ByteArrayInputStream(policyString.getBytes());
        try {
            policyElement = new StAXOMBuilder((InputStream)bais).getDocumentElement();
            policyElement.build();
        }
        catch (Exception e) {
            throw new AxisFault("Cannot deserialize module policy. The policy may be invalid.", (Throwable)e);
        }
        AxisModule axisModule = this.getAxisModule(moduleId, moduleVersion);
        try {
            modulePolicy = PolicyUtil.getPolicyFromOMElement((OMElement)policyElement);
            ModulePolicyDO modulePolicyDO = new ModulePolicyDO();
            ModuleDO moduleDO = new ModuleDO();
            ModuleIdentifierDO mid = new ModuleIdentifierDO();
            mid.setName(moduleId);
            mid.setVersion(moduleVersion);
            moduleDO.setModuleIdentifierDO(mid);
            modulePolicyDO.setModule(moduleDO);
            OMAttribute attribute = policyElement.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
            if (attribute == null) {
                throw new AxisFault("ID Attribute not found in Policy element. Please verify that the policy XML is valid.");
            }
            modulePolicyDO.setUuid(attribute.getAttributeValue());
            modulePolicyDO.setPolicy(policyElement.toString());
            this.pm.updateModulePolicy(modulePolicyDO);
        }
        catch (ModulePolicyNotFoundException e) {
            throw new AxisFault("Module Policy not found in DB", (Throwable)e);
        }
        axisModule.getPolicyInclude().updatePolicy(modulePolicy);
    }

    public OMElement[] getDeclaredModuleParameters(String moduleId, String moduleVersion) throws AxisFault {
        AxisModule module = this.getAxisModule(moduleId, moduleVersion);
        ArrayList parameters = module.getParameters();
        ArrayList<OMElement> returnValues = new ArrayList<OMElement>();
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            OMElement element = parameter.getParameterElement();
            if (element == null) continue;
            returnValues.add(element);
        }
        return returnValues.toArray(new OMElement[returnValues.size()]);
    }

    public void setModuleParameters(String moduleId, String moduleVersion, OMElement[] paramterElements) throws AxisFault {
        for (int i = 0; i < paramterElements.length; ++i) {
            this.setModuleParameter(moduleId, moduleVersion, paramterElements[i]);
        }
    }

    public void setModuleParameter(String moduleId, String moduleVersion, OMElement paramterElement) throws AxisFault {
        AxisModule axisModule = this.getAxisModule(moduleId, moduleVersion);
        ModuleDO moduleDO = this.pm.getModule(moduleId, moduleVersion);
        Parameter parameter = ParameterUtil.createParameter((OMElement)paramterElement);
        Parameter p = axisModule.getParameter(parameter.getName());
        if (p != null) {
            if (!p.isLocked()) {
                axisModule.addParameter(parameter);
                ModuleParameterDO paramDO = this.pm.getModuleParameter(moduleDO, parameter.getName());
                paramDO.setValue(paramterElement.toString());
                this.pm.updateEntity((AbstractDataObject)paramDO);
            }
        } else {
            axisModule.addParameter(parameter);
            ModuleParameterDO param = new ModuleParameterDO();
            param.setName(parameter.getName());
            param.setValue(paramterElement.toString());
            param.setModule(moduleDO);
            try {
                this.pm.addEntity((AbstractDataObject)param);
            }
            catch (DuplicateEntityException e) {
                log.error((Object)"Module Parameter already exists", (Throwable)e);
            }
        }
    }

    public void removeModuleParameter(String moduleId, String moduleVersion, OMElement paramterElement) throws AxisFault {
        AxisModule axisModule = this.getAxisModule(moduleId, moduleVersion);
        ModuleDO moduleDO = this.pm.getModule(moduleId, moduleVersion);
        Parameter parameter = ParameterUtil.createParameter((OMElement)paramterElement);
        Parameter p = axisModule.getParameter(parameter.getName());
        if (p != null) {
            if (!p.isLocked()) {
                axisModule.removeParameter(parameter);
                ModuleParameterDO paramDO = this.pm.getModuleParameter(moduleDO, parameter.getName());
                this.pm.deleteEntity((AbstractDataObject)paramDO);
            }
        } else {
            axisModule.removeParameter(parameter);
        }
    }

    public void setAs(String moduleName, String version) throws AxisFault {
        this.getAxisConfig().addDefaultModuleVersion(moduleName, version);
    }

    public PolicyData[] getPolicies(String moduleId, String moduleVersion) throws AxisFault {
        AxisModule axisModule = this.getAxisConfig().getModule(moduleId, moduleVersion);
        if (axisModule == null) {
            throw new AxisFault("Invalid module name");
        }
        ArrayList<PolicyData> policyDataArray = new ArrayList<PolicyData>();
        PolicyInclude policyInclude = axisModule.getPolicyInclude();
        PolicyRegistry registry = policyInclude.getPolicyRegistry();
        ArrayList policyList = policyInclude.getPolicyElements(2);
        if (!policyList.isEmpty()) {
            PolicyData policyData = new PolicyData();
            policyData.setWrapper("Policies in module.xml");
            policyData.setPolycies(PolicyUtil.processPolicyElements(policyList.iterator(), (PolicyRegistry)registry));
            policyDataArray.add(policyData);
        }
        return policyDataArray.toArray(new PolicyData[policyDataArray.size()]);
    }

    private AxisModule getAxisModule(String moduleId, String moduleVersion) throws AxisFault {
        AxisModule module = this.getAxisConfig().getModule(moduleId, moduleVersion);
        if (module == null) {
            throw new AxisFault("Invalid module name : " + Utils.getModuleName((String)moduleId, (String)moduleVersion));
        }
        return module;
    }

    public ModuleMetaData[] listServicesParentEngagedModules(String serviceName) throws AxisFault {
        AxisService service = this.getAxisConfig().getService(serviceName);
        if (service == null) {
            throw new AxisFault("Service not found or invalid service");
        }
        ArrayList<ModuleMetaData> emodules = new ArrayList<ModuleMetaData>();
        Iterator engagedModules = service.getEngagedModules().iterator();
        while (engagedModules.hasNext()) {
            AxisModule module = (AxisModule)engagedModules.next();
            if (this.getAxisConfig().isEngaged(module) || !service.getParent().isEngaged(module) || AdminFilter.isFilteredOutModule((String)module.getName())) continue;
            emodules.add(new ModuleMetaData(module.getName(), module.getVersion()));
        }
        return emodules.toArray(new ModuleMetaData[emodules.size()]);
    }

    public ModuleMetaData[] listOperationsParentParentEngagedModules(String serviceName, String operationName) throws AxisFault {
        AxisService service = this.getAxisConfig().getService(serviceName);
        if (service == null) {
            throw new AxisFault("Service not found or invalid service");
        }
        AxisOperation operation = service.getOperation(new QName(operationName));
        if (operation == null) {
            throw new AxisFault("Operation name invalid");
        }
        ArrayList<ModuleMetaData> emodules = new ArrayList<ModuleMetaData>();
        Iterator engagedModules = operation.getEngagedModules().iterator();
        while (engagedModules.hasNext()) {
            AxisModule module = (AxisModule)engagedModules.next();
            if (!service.getParent().isEngaged(module) || this.getAxisConfig().isEngaged(module) || AdminFilter.isFilteredOutModule((String)module.getName())) continue;
            emodules.add(new ModuleMetaData(module.getName(), module.getVersion()));
        }
        return emodules.toArray(new ModuleMetaData[emodules.size()]);
    }
}

