/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.wso2.wsas.admin.service.AbstractAdmin;
import org.wso2.wsas.admin.service.StatisticsClient;
import org.wso2.wsas.admin.service.util.OperationMetaData;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.AbstractDataObject;
import org.wso2.wsas.persistence.dataobject.OperationDO;
import org.wso2.wsas.persistence.dataobject.OperationParameterDO;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;
import org.wso2.wsas.util.ParameterUtil;
import org.wso2.wsas.util.PolicyUtil;

public class OperationAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog((Class)OperationAdmin.class);

    public OperationMetaData[] listAllOperations(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        ArrayList<OperationMetaData> opList = new ArrayList<OperationMetaData>();
        Iterator operations = axisService.getOperations();
        while (operations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.getName() == null) continue;
            opList.add(this.getOperationMetaData(serviceName, axisOperation.getName().getLocalPart()));
        }
        Collections.sort(opList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                OperationMetaData a = (OperationMetaData)arg0;
                OperationMetaData b = (OperationMetaData)arg1;
                return a.getName().compareToIgnoreCase(b.getName());
            }
        });
        return opList.toArray(new OperationMetaData[opList.size()]);
    }

    public OperationMetaData[] listControlOperations(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        ArrayList<OperationMetaData> opMetaDataList = new ArrayList<OperationMetaData>();
        Iterator operations = axisService.getControlOperations().iterator();
        while (operations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operations.next();
            opMetaDataList.add(this.getOperationMetaData(serviceName, axisOperation.getName().getLocalPart()));
        }
        return opMetaDataList.toArray(new OperationMetaData[opMetaDataList.size()]);
    }

    public OperationMetaData[] listPublishedOperations(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        ArrayList<OperationMetaData> opList = new ArrayList<OperationMetaData>();
        Iterator operations = axisService.getPublishedOperations().iterator();
        while (operations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operations.next();
            opList.add(this.getOperationMetaData(serviceName, axisOperation.getName().getLocalPart()));
        }
        return opList.toArray(new OperationMetaData[opList.size()]);
    }

    public Object[] getOperationInfo(String serviceId, String serviceVersion, String operationId) throws AxisFault {
        throw new AxisFault("Operation not yet implemented");
    }

    public OperationMetaData getOperationStatistics(String serviceName, String operationName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        if (axisService != null) {
            return this.getOperationMetaData(serviceName, operationName);
        }
        return null;
    }

    public void configureMTOM(String flag, String serviceName, String operationName) throws AxisFault {
        PersistenceManager pm;
        OperationParameterDO paramDO;
        Parameter parameter;
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        if (axisService == null) {
            throw new AxisFault("Service cannot be found");
        }
        AxisOperation operation = axisService.getOperation(new QName(operationName));
        if (operation == null) {
            throw new AxisFault("Operation cannot be found");
        }
        ArrayList parameters = operation.getParameters();
        boolean found = false;
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter2 = (Parameter)iterator.next();
            if (parameter2.getParameterType() != 1 || !parameter2.getValue().toString().equals("enableMTOM")) continue;
            parameter2.setValue((Object)flag.trim());
            found = true;
            break;
        }
        if (!found) {
            parameter = ParameterUtil.createParameter((String)"enableMTOM", (String)flag.trim());
            operation.addParameter(parameter);
        }
        if ((paramDO = (pm = new PersistenceManager()).getOperationParameter(serviceName, "$EMPTY$", operationName, (parameter = operation.getParameter("enableMTOM")).getName())) != null) {
            paramDO.setValue(parameter.getParameterElement().toString());
            pm.updateEntity((AbstractDataObject)paramDO);
        } else {
            paramDO = new OperationParameterDO();
            paramDO.setName(parameter.getName());
            paramDO.setValue(parameter.getParameterElement().toString());
            OperationDO opDO = pm.getOperation(serviceName, "$EMPTY$", operationName);
            paramDO.setOperation(opDO);
            try {
                pm.addEntity((AbstractDataObject)paramDO);
            }
            catch (DuplicateEntityException e) {
                log.error((Object)"Operation Parameter already exists", (Throwable)e);
            }
        }
    }

    public OMElement[] getOperationParameters(String serviceId, String operationId) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        AxisOperation op = axisService.getOperation(new QName(operationId));
        if (op == null) {
            throw new AxisFault("Invalid operation : " + operationId + " not available in service : " + serviceId);
        }
        ArrayList<OMElement> allParameter = new ArrayList<OMElement>();
        ArrayList globalParameters = this.getAxisConfig().getParameters();
        for (int i = 0; i < globalParameters.size(); ++i) {
            Parameter parameter = (Parameter)globalParameters.get(i);
            allParameter.add(parameter.getParameterElement());
        }
        AxisService service = this.getAxisConfig().getService(serviceId);
        if (service == null) {
            throw new AxisFault("invalid service name");
        }
        ArrayList serviceParams = service.getParameters();
        for (int i = 0; i < serviceParams.size(); ++i) {
            Parameter parameter = (Parameter)serviceParams.get(i);
            allParameter.add(parameter.getParameterElement());
        }
        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)service.getParent();
        ArrayList serviceGroupParams = axisServiceGroup.getParameters();
        for (int i = 0; i < serviceGroupParams.size(); ++i) {
            Parameter parameter = (Parameter)serviceGroupParams.get(i);
            allParameter.add(parameter.getParameterElement());
        }
        ArrayList opParams = op.getParameters();
        for (int i = 0; i < opParams.size(); ++i) {
            Parameter parameter = (Parameter)opParams.get(i);
            allParameter.add(parameter.getParameterElement());
        }
        return allParameter.toArray(new OMElement[allParameter.size()]);
    }

    public OMElement[] getDeclaredOperationParameters(String serviceName, String operationName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        AxisOperation op = axisService.getOperation(new QName(operationName));
        if (op == null) {
            throw new AxisFault("Invalid operation : " + operationName + " not available in service : " + serviceName);
        }
        ArrayList<OMElement> allParameter = new ArrayList<OMElement>();
        ArrayList opParams = op.getParameters();
        for (int i = 0; i < opParams.size(); ++i) {
            Parameter parameter = (Parameter)opParams.get(i);
            OMElement element = parameter.getParameterElement();
            if (element == null) continue;
            allParameter.add(element);
        }
        return allParameter.toArray(new OMElement[allParameter.size()]);
    }

    public void setOperationParameters(String serviceId, String operationId, String groupVersion, OMElement[] parameterElements) throws AxisFault {
        for (int i = 0; i < parameterElements.length; ++i) {
            this.setOperationParameter(serviceId, operationId, groupVersion, parameterElements[i]);
        }
    }

    public void removeOperationParameters(String serviceId, String operationId, String groupVersion, OMElement[] parameterElements) throws AxisFault {
        for (int i = 0; i < parameterElements.length; ++i) {
            this.removeOperationParameter(serviceId, operationId, groupVersion, parameterElements[i]);
        }
    }

    public void setOperationParameter(String serviceId, String operationId, String groupVersion, OMElement parameterElement) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("invalid service name service not found : " + serviceId);
        }
        AxisOperation axisOp = axisService.getOperation(new QName(operationId));
        if (axisOp == null) {
            throw new AxisFault("Invalid operation : " + operationId + " not available in service : " + serviceId);
        }
        Parameter parameter = ParameterUtil.createParameter((OMElement)parameterElement);
        PersistenceManager pm = new PersistenceManager();
        Parameter p = axisOp.getParameter(parameter.getName());
        OperationParameterDO paramDO = pm.getOperationParameter(serviceId, "$EMPTY$", operationId, parameter.getName());
        if (p != null && paramDO != null) {
            if (!p.isLocked()) {
                axisOp.addParameter(parameter);
                paramDO.setValue(parameterElement.toString());
                pm.updateEntity((AbstractDataObject)paramDO);
            }
        } else if (p == null || !p.isLocked()) {
            axisOp.addParameter(parameter);
            paramDO = new OperationParameterDO();
            paramDO.setName(parameter.getName());
            paramDO.setValue(parameterElement.toString());
            OperationDO opDO = pm.getOperation(serviceId, "$EMPTY$", operationId);
            paramDO.setOperation(opDO);
            try {
                pm.addEntity((AbstractDataObject)paramDO);
            }
            catch (DuplicateEntityException e) {
                log.error((Object)"Operation Parameter already exists", (Throwable)e);
            }
        }
    }

    public void removeOperationParameter(String serviceId, String operationId, String groupVersion, OMElement parameterElement) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("invalid service name service not found : " + serviceId);
        }
        AxisOperation axisOp = axisService.getOperation(new QName(operationId));
        if (axisOp == null) {
            throw new AxisFault("Invalid operation : " + operationId + " not available in service : " + serviceId);
        }
        Parameter parameter = ParameterUtil.createParameter((OMElement)parameterElement);
        PersistenceManager pm = new PersistenceManager();
        Parameter p = axisOp.getParameter(parameter.getName());
        OperationParameterDO paramDO = pm.getOperationParameter(serviceId, "$EMPTY$", operationId, parameter.getName());
        if (p != null && paramDO != null) {
            if (!p.isLocked()) {
                axisOp.removeParameter(parameter);
                pm.deleteEntity((AbstractDataObject)paramDO);
            }
        } else if (p == null || !p.isLocked()) {
            axisOp.removeParameter(parameter);
        }
    }

    public String[] listOperationPhases(String serviceName, String operationName, int flow) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        AxisOperation op = axisService.getOperation(new QName(operationName));
        if (op == null) {
            throw new AxisFault("Invalid operation : " + operationName + " not available in service : " + serviceName);
        }
        String[] phaseNames = null;
        switch (flow) {
            case 1: {
                ArrayList inflow = op.getRemainingPhasesInFlow();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
            case 2: {
                ArrayList inflow = op.getPhasesOutFlow();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
            case 3: {
                ArrayList inflow = op.getPhasesInFaultFlow();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
            case 4: {
                ArrayList inflow = op.getPhasesOutFaultFlow();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
        }
        return phaseNames;
    }

    public String[] listOperationPhaseHandlers(String serviceName, String operationName, int flow, String phaseName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        AxisOperation op = axisService.getOperation(new QName(operationName));
        if (op == null) {
            throw new AxisFault("Invalid operation : " + operationName + " not available in service : " + serviceName);
        }
        String[] handlers = null;
        switch (flow) {
            case 1: {
                ArrayList inflow = op.getRemainingPhasesInFlow();
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    ArrayList hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
            case 2: {
                ArrayList inflow = op.getPhasesOutFlow();
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    ArrayList hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
            case 3: {
                ArrayList inflow = op.getPhasesInFaultFlow();
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    ArrayList hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
            case 4: {
                ArrayList inflow = op.getPhasesOutFaultFlow();
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    ArrayList hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
        }
        return handlers;
    }

    public OMElement getPolicy(String serviceId, String operationId) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("Invalid service : " + serviceId);
        }
        AxisOperation axisOperation = axisService.getOperation(new QName(operationId));
        if (axisOperation == null) {
            throw new AxisFault("Invalid operation : " + operationId + " not available in service : " + serviceId);
        }
        PolicyInclude operationPolicyInclude = axisOperation.getPolicyInclude();
        Policy operationPolicy = operationPolicyInclude.getPolicy();
        if (operationPolicy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement();
        }
        return PolicyUtil.getPolicyAsOMElement((Policy)operationPolicy);
    }

    public void setPolicy(String serviceId, String operationId, OMElement policyElement) throws AxisFault {
        Policy operationPolicy;
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("Invalid service : " + serviceId);
        }
        AxisOperation axisOperation = axisService.getOperation(new QName(operationId));
        if (axisOperation == null) {
            throw new AxisFault("Invalid operation : " + operationId + " not available in service : " + serviceId);
        }
        try {
            operationPolicy = PolicyUtil.getPolicyFromOMElement((OMElement)policyElement);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Cannot convert the OMElement to Policy", ex);
        }
        PolicyInclude operationPolicyInclude = axisOperation.getPolicyInclude();
        operationPolicyInclude.setPolicy(operationPolicy);
    }

    private OperationMetaData getOperationMetaData(String serviceName, String operationName) throws AxisFault {
        AxisService axisService = this.configCtx.getAxisConfiguration().getService(serviceName);
        AxisOperation axisOperation = null;
        if (axisService != null) {
            axisOperation = axisService.getOperation(new QName(operationName));
        }
        if (axisOperation == null) {
            return null;
        }
        OperationMetaData opMetaData = new OperationMetaData();
        opMetaData.setName(axisOperation.getName().getLocalPart());
        opMetaData.setControlOperation(axisOperation.isControlOperation());
        Parameter parameter = axisOperation.getParameter("enableMTOM");
        if (parameter != null) {
            opMetaData.setEnableMTOM((String)parameter.getValue());
        } else {
            opMetaData.setEnableMTOM("false");
        }
        try {
            StatisticsClient statClient = new StatisticsClient();
            opMetaData.setOpRequestCount(statClient.getOperationRequestCount(serviceName, operationName));
            opMetaData.setOpResponseCount(statClient.getOperationResponseCount(serviceName, operationName));
            opMetaData.setOpFaultCount(statClient.getOperationFaultCount(serviceName, operationName));
            opMetaData.setMaxResponseTime(statClient.getMaxOperationResponseTime(serviceName, operationName));
            opMetaData.setMinResponseTime(statClient.getMinOperationResponseTime(serviceName, operationName));
            opMetaData.setAvgResponseTime(statClient.getAvgOperationResponseTime(serviceName, operationName));
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        return opMetaData;
    }
}

