/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.wso2.wsas.admin.service.AbstractAdmin;
import org.wso2.wsas.admin.service.ServiceAdmin;
import org.wso2.wsas.admin.service.util.TrustedServiceData;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.util.KeyStoreUtil;

public class STSAdmin
extends AbstractAdmin {
    private static Log log = LogFactory.getLog((Class)STSAdmin.class);

    public void addTrustedService(String serviceAddress, String certAlias) throws AxisFault {
        try {
            MessageContext msgCtx = MessageContext.getCurrentMessageContext();
            AxisConfiguration config = msgCtx.getConfigurationContext().getAxisConfiguration();
            AxisService stsService = config.getService("wso2wsas-sts");
            Parameter origParam = stsService.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            if (origParam == null) {
                throw new AxisFault("missing parameter : " + SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            }
            OMElement samlConfigElem = origParam.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG);
            SAMLTokenIssuerConfig samlConfig = new SAMLTokenIssuerConfig(samlConfigElem);
            samlConfig.addTrustedServiceEndpointAddress(serviceAddress, certAlias);
            this.setSTSParameter(samlConfig);
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public void setProofKeyType(String keyType) throws AxisFault {
        try {
            MessageContext msgCtx = MessageContext.getCurrentMessageContext();
            AxisConfiguration config = msgCtx.getConfigurationContext().getAxisConfiguration();
            AxisService service = config.getService("wso2wsas-sts");
            Parameter origParam = service.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            if (origParam == null) {
                throw new AxisFault("missing parameter : " + SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            }
            OMElement samlConfigElem = origParam.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG);
            SAMLTokenIssuerConfig samlConfig = new SAMLTokenIssuerConfig(samlConfigElem);
            samlConfig.setProofKeyType(keyType);
            this.setSTSParameter(samlConfig);
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public TrustedServiceData[] getTrustedServices() throws AxisFault {
        try {
            MessageContext msgCtx = MessageContext.getCurrentMessageContext();
            AxisConfiguration config = msgCtx.getConfigurationContext().getAxisConfiguration();
            AxisService service = config.getService("wso2wsas-sts");
            Parameter origParam = service.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            if (origParam != null) {
                OMElement samlConfigElem = origParam.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG);
                SAMLTokenIssuerConfig samlConfig = new SAMLTokenIssuerConfig(samlConfigElem);
                Map trustedServicesMap = samlConfig.getTrustedServices();
                Set addresses = trustedServicesMap.keySet();
                ArrayList<TrustedServiceData> serviceBag = new ArrayList<TrustedServiceData>();
                Iterator iterator = addresses.iterator();
                while (iterator.hasNext()) {
                    String address = (String)iterator.next();
                    String alias = (String)trustedServicesMap.get(address);
                    TrustedServiceData data = new TrustedServiceData(address, alias);
                    serviceBag.add(data);
                }
                return serviceBag.toArray(new TrustedServiceData[serviceBag.size()]);
            }
            throw new AxisFault("missing parameter : " + SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public String getProofKeyType() throws AxisFault {
        try {
            MessageContext msgCtx = MessageContext.getCurrentMessageContext();
            AxisConfiguration config = msgCtx.getConfigurationContext().getAxisConfiguration();
            AxisService service = config.getService("wso2wsas-sts");
            Parameter origParam = service.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            if (origParam != null) {
                OMElement samlConfigElem = origParam.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG);
                SAMLTokenIssuerConfig samlConfig = new SAMLTokenIssuerConfig(samlConfigElem);
                return samlConfig.getProofKeyType();
            }
            throw new AxisFault("missing parameter : " + SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public String[] getCertAliasOfPrimaryKeyStore() throws AxisFault {
        PersistenceManager pm = new PersistenceManager();
        KeyStoreDO[] keyStores = pm.getKeyStores();
        KeyStoreDO primaryKeystoe = null;
        for (int i = 0; i < keyStores.length; ++i) {
            if (!keyStores[i].getIsPrimaryKeyStore()) continue;
            primaryKeystoe = keyStores[i];
            break;
        }
        if (primaryKeystoe != null) {
            String keysoteName = primaryKeystoe.getKeyStoreName();
            ArrayList<String> aliases = new ArrayList<String>();
            try {
                KeyStore keyStore = KeyStoreUtil.getKeyStore((String)keysoteName);
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String alias = enumeration.nextElement();
                    aliases.add(alias);
                }
            }
            catch (Exception e) {
                String msg = "Could not read certificates from keystore file. ";
                log.error((Object)msg, (Throwable)e);
                throw new AxisFault(msg + e.getMessage());
            }
            return aliases.toArray(new String[aliases.size()]);
        }
        throw new AxisFault("Primary Keystore cannot be found.");
    }

    private void setSTSParameter(SAMLTokenIssuerConfig samlConfig) throws AxisFault {
        new ServiceAdmin(this.configCtx).setServiceParameter3("wso2wsas-sts", samlConfig.getParameter());
    }
}

