/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rampart.policy.RampartPolicyBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.Token;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.wso2.wsas.admin.service.AbstractAdmin;
import org.wso2.wsas.admin.service.CryptoAdmin;
import org.wso2.wsas.admin.service.ModuleAdmin;
import org.wso2.wsas.admin.service.ServiceAdmin;
import org.wso2.wsas.admin.service.util.SecurityAssignment;
import org.wso2.wsas.admin.service.util.SelectableString;
import org.wso2.wsas.admin.service.util.UtKeystoreSecurityAssignment;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.AbstractDataObject;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.persistence.dataobject.ModuleDO;
import org.wso2.wsas.persistence.dataobject.SecurityScenarioDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceIdentifierDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;
import org.wso2.wsas.persistence.exception.ServiceNotFoundException;
import org.wso2.wsas.security.ServerCrypto;
import org.wso2.wsas.security.WSS4JUtil;
import org.wso2.wsas.security.util.RampartConfigUtil;
import org.wso2.wsas.trust.SecurityTokenStore;

public class SecurityScenarioConfigAdmin
extends AbstractAdmin {
    public static final String USER = "rampart.config.user";
    public static final String ENCRYPTION_USER = "rampart.config.encryption.user";
    public static final Log log = LogFactory.getLog((Class)SecurityScenarioConfigAdmin.class);
    private PersistenceManager pm = new PersistenceManager();
    private String scenarioDir = System.getProperty("wso2wsas.home") + File.separator + "conf" + File.separator + "rampart" + File.separator;
    private static final String WS_SEC_UTILITY_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private static final QName ID = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    private static final String WS_POLICY_NS = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    private static final String SCENARIO_DISABLE_SECURITY = "DisableSecurity";
    public static final int DEFAULT_TS_TTL = 300;
    public static final int DEFAULT_TS_MAX_SKEW = 300;

    public SecurityScenarioDO[] getScenarios(String serviceName) {
        SecurityScenarioDO scenario;
        int i;
        SecurityScenarioDO[] scenarios = this.pm.getAllSecurityScenarios();
        ServiceDO service = new ServiceDO();
        ServiceIdentifierDO serviceIdentifierDO = new ServiceIdentifierDO();
        serviceIdentifierDO.setServiceId(serviceName);
        service.setServiceIdentifierDO(serviceIdentifierDO);
        boolean isServiceScenarioFound = false;
        for (i = 0; i < scenarios.length; ++i) {
            scenario = scenarios[i];
            if (!scenario.services.contains(service)) continue;
            scenario.setIsCurrentScenario(true);
            isServiceScenarioFound = true;
            break;
        }
        if (!isServiceScenarioFound) {
            for (i = 0; i < scenarios.length; ++i) {
                scenario = scenarios[i];
                if (!scenario.getScenarioId().equalsIgnoreCase(SCENARIO_DISABLE_SECURITY)) continue;
                scenario.setIsCurrentScenario(true);
                break;
            }
        }
        return scenarios;
    }

    private void configureScenario(String serviceName, String scenarioId, Properties props) throws AxisFault {
        this.disengageModules(serviceName, SCENARIO_DISABLE_SECURITY);
        RampartConfig rampartConfig = new RampartConfig();
        rampartConfig.setTokenStoreClass(SecurityTokenStore.class.getName());
        this.populateRampartConfig(rampartConfig, props);
        ServiceAdmin serviceAdmin = new ServiceAdmin(this.configCtx);
        this.removeAllSecurityScenarioPolicies(serviceAdmin, serviceName);
        String scenarioPolicyXml = this.scenarioDir + scenarioId + "-policy.xml";
        try {
            Policy policy = SecurityScenarioConfigAdmin.loadPolicy(scenarioPolicyXml);
            if (rampartConfig != null) {
                policy.addAssertion((Assertion)rampartConfig);
            }
            AxisService axisService = this.getAxisConfig().getService(serviceName);
            axisService.getPolicyInclude().addPolicyElement(3, policy);
            Iterator alternatives = policy.getAlternatives();
            if (alternatives.hasNext()) {
                Token encrToken;
                List it = (List)alternatives.next();
                boolean httpsRequired = false;
                RampartPolicyData rampartPolicyData = RampartPolicyBuilder.build((List)it);
                if (rampartPolicyData.isTransportBinding()) {
                    httpsRequired = true;
                } else if (rampartPolicyData.isSymmetricBinding() && (encrToken = rampartPolicyData.getEncryptionToken()) instanceof SecureConversationToken) {
                    Policy bsPol = ((SecureConversationToken)encrToken).getBootstrapPolicy();
                    Iterator alts = bsPol.getAlternatives();
                    if (alts.hasNext()) {
                        // empty if block
                    }
                    List bsIt = (List)alts.next();
                    RampartPolicyData bsRampartPolicyData = RampartPolicyBuilder.build((List)bsIt);
                    httpsRequired = bsRampartPolicyData.isTransportBinding();
                }
                if (httpsRequired) {
                    ArrayList<String> httpsTransports = new ArrayList<String>();
                    Iterator iter = this.axisConfig.getTransportsIn().keySet().iterator();
                    while (iter.hasNext()) {
                        String transport = (String)iter.next();
                        if (transport.toLowerCase().indexOf("https") == -1) continue;
                        httpsTransports.add(transport);
                    }
                    serviceAdmin.exposeServiceOnlyViaTransports(serviceName, httpsTransports.toArray(new String[httpsTransports.size()]));
                }
            }
            if (axisService.getParameter("passwordCallbackRef") == null) {
                axisService.addParameter(WSS4JUtil.getPasswordCallBackRefParameter((String)serviceName, (String)"$EMPTY$"));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)baos);
            policy.serialize(xmlStreamWriter);
            xmlStreamWriter.flush();
            this.removeAllSecurityScenarioPolicies(serviceAdmin, serviceName);
            serviceAdmin.setPolicy(serviceName, "$EMPTY$", baos.toString());
        }
        catch (Exception e) {
            throw new AxisFault("Could not load security policy", (Throwable)e);
        }
        ServiceDO service = this.pm.getService(serviceName, "$EMPTY$");
        SecurityScenarioDO securityScenario = this.pm.getSecurityScenario(scenarioId);
        if (service != null && securityScenario != null) {
            securityScenario.addService(service);
            this.pm.updateEntity((AbstractDataObject)securityScenario);
            this.pm.updateEntity((AbstractDataObject)service);
        }
    }

    private static Policy loadPolicy(String policyXMLFile) throws FileNotFoundException, XMLStreamException {
        return PolicyEngine.getPolicy((OMElement)new StAXOMBuilder(policyXMLFile).getDocumentElement());
    }

    public void disableSecurity(String serviceName) throws AxisFault {
        ServiceAdmin serviceAdmin = new ServiceAdmin(this.configCtx);
        this.removeAllSecurityScenarioPolicies(serviceAdmin, serviceName);
        ServiceDO serviceDO = this.pm.getService(serviceName, "$EMPTY$");
        serviceDO.setIsUTAuthEnabled(false);
        serviceDO.setIsExposedOnAllTransports(true);
        this.axisConfig.getService(serviceName).setEnableAllTransports(true);
        SecurityScenarioDO securityScenario = serviceDO.getSecurityScenario();
        if (securityScenario != null) {
            securityScenario.removeService(serviceDO);
            serviceDO.removeAllTrustedCertStores();
            serviceDO.setPrivateKeyStore(null);
            Iterator iter = serviceDO.getUsers().iterator();
            while (iter.hasNext()) {
                ServiceUserDO userDO = (ServiceUserDO)iter.next();
                userDO.getServices().remove(serviceDO);
                this.pm.updateEntity((AbstractDataObject)userDO);
            }
            iter = serviceDO.getRoles().iterator();
            while (iter.hasNext()) {
                ServiceUserRoleDO roleDO = (ServiceUserRoleDO)iter.next();
                roleDO.getServices().remove(serviceDO);
                this.pm.updateEntity((AbstractDataObject)roleDO);
            }
            serviceDO.removeAllRoles();
            serviceDO.removeAllUsers();
            this.pm.updateEntity((AbstractDataObject)serviceDO);
            this.disengageModules(serviceName, SCENARIO_DISABLE_SECURITY);
        }
    }

    private void removeAllSecurityScenarioPolicies(ServiceAdmin serviceAdmin, String serviceName) throws AxisFault {
        File scDir = new File(this.scenarioDir);
        File[] policyFiles = scDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith("-policy.xml");
            }
        });
        for (int i = 0; i < policyFiles.length; ++i) {
            File policyFile = policyFiles[i];
            try {
                StAXOMBuilder builder = new StAXOMBuilder(policyFile.getAbsolutePath());
                SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
                nsCtx.addNamespace("wsp", WS_POLICY_NS);
                nsCtx.addNamespace("wsu", WS_SEC_UTILITY_NS);
                AXIOMXPath xp = new AXIOMXPath("//wsp:Policy");
                xp.setNamespaceContext((NamespaceContext)nsCtx);
                OMElement policyEle = (OMElement)xp.selectSingleNode((Object)builder.getDocumentElement());
                OMAttribute idAtt = policyEle.getAttribute(ID);
                if (idAtt == null) {
                    throw new AxisFault("Policy ID attribute is NULL");
                }
                serviceAdmin.removePolicy(serviceName, "$EMPTY$", idAtt.getAttributeValue());
                continue;
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
    }

    private void populateRampartConfig(RampartConfig rampartConfig, Properties props) throws AxisFault {
        if (rampartConfig != null) {
            if (!props.isEmpty()) {
                CryptoConfig encrCryptoConfig = new CryptoConfig();
                encrCryptoConfig.setProvider(ServerCrypto.class.getName());
                encrCryptoConfig.setProp(props);
                rampartConfig.setEncrCryptoConfig(encrCryptoConfig);
                CryptoConfig signatureCryptoConfig = new CryptoConfig();
                signatureCryptoConfig.setProvider(ServerCrypto.class.getName());
                signatureCryptoConfig.setProp(props);
                rampartConfig.setSigCryptoConfig(signatureCryptoConfig);
            }
            rampartConfig.setEncryptionUser("useReqSigCert");
            rampartConfig.setUser(props.getProperty(USER));
            int ttl = 300;
            int timeSkew = 300;
            rampartConfig.setTimestampTTL(Integer.toString(ttl));
            rampartConfig.setTimestampMaxSkew(Integer.toString(timeSkew));
            rampartConfig.setTokenStoreClass(SecurityTokenStore.class.getName());
        }
    }

    public void assignUsersAndRolesAndKeyStores(String serviceName, String serviceVersion, String scenarioId, String[] trustedCertStores, String privateKeyStore, String[] users, String[] roles) throws AxisFault {
        int i;
        ServiceDO serviceDO;
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        if (axisService.getParameter("passwordCallbackRef") == null) {
            axisService.addParameter(WSS4JUtil.getPasswordCallBackRefParameter((String)serviceName, (String)serviceVersion));
        }
        if (serviceVersion == null || serviceVersion.trim().length() == 0) {
            serviceVersion = "$EMPTY$";
        }
        if ((serviceDO = this.pm.getService(serviceName, serviceVersion)) == null) {
            throw new AxisFault("Service " + serviceName + " not found!");
        }
        Iterator iter = serviceDO.getUsers().iterator();
        while (iter.hasNext()) {
            ServiceUserDO userDO = (ServiceUserDO)iter.next();
            userDO.getServices().remove(serviceDO);
            this.pm.updateEntity((AbstractDataObject)userDO);
        }
        iter = serviceDO.getRoles().iterator();
        while (iter.hasNext()) {
            ServiceUserRoleDO roleDO = (ServiceUserRoleDO)iter.next();
            roleDO.getServices().remove(serviceDO);
            this.pm.updateEntity((AbstractDataObject)roleDO);
        }
        serviceDO.removeAllUsers();
        serviceDO.removeAllRoles();
        try {
            this.pm.updateService(serviceDO);
        }
        catch (ServiceNotFoundException e) {
            // empty catch block
        }
        for (i = 0; i < users.length; ++i) {
            String user = users[i];
            if (user == null || user.trim().length() == 0) continue;
            serviceDO.setIsUTAuthEnabled(true);
            ServiceUserDO userDO = this.pm.getUser(user);
            serviceDO.addUser(userDO);
            this.pm.updateEntity((AbstractDataObject)userDO);
        }
        for (i = 0; i < roles.length; ++i) {
            String role = roles[i];
            if (role == null || role.trim().length() == 0) continue;
            serviceDO.setIsUTAuthEnabled(true);
            ServiceUserRoleDO roleDO = this.pm.getRole(role);
            serviceDO.addRole(roleDO);
            this.pm.updateEntity((AbstractDataObject)roleDO);
        }
        try {
            this.pm.updateService(serviceDO);
        }
        catch (ServiceNotFoundException e) {
            // empty catch block
        }
        serviceDO = this.pm.getService(serviceName, serviceVersion);
        this.pm.removeAllTrustedCertStores(serviceDO);
        serviceDO = this.pm.getService(serviceName, serviceVersion);
        for (int i2 = 0; i2 < trustedCertStores.length; ++i2) {
            String ks = trustedCertStores[i2];
            KeyStoreDO keyStore = this.pm.getKeyStore(ks);
            if (keyStore == null) {
                throw new AxisFault("Key Store " + ks + " does not exist");
            }
            serviceDO.addTrustedCertStore(keyStore);
        }
        KeyStoreDO pkKeyStore = this.pm.getKeyStore(privateKeyStore);
        serviceDO.setPrivateKeyStore(pkKeyStore);
        this.pm.updateEntity((AbstractDataObject)serviceDO);
        this.configureScenario(serviceName, scenarioId, this.getServerCryptoProperties(trustedCertStores, privateKeyStore, pkKeyStore.getPrivateKeyAlias()));
        this.engageModules(serviceName, scenarioId);
    }

    public void assignKeyStores(String serviceName, String scenarioId, String[] trustedCertStores, String privateKeyStore) throws AxisFault {
        ServiceDO serviceDO = this.pm.getService(serviceName, "$EMPTY$");
        this.pm.removeAllTrustedCertStores(serviceDO);
        serviceDO = this.pm.getService(serviceName, "$EMPTY$");
        serviceDO.setIsUTAuthEnabled(false);
        serviceDO.setIsExposedOnAllTransports(true);
        this.axisConfig.getService(serviceName).setEnableAllTransports(true);
        for (int i = 0; i < trustedCertStores.length; ++i) {
            String ks = trustedCertStores[i];
            KeyStoreDO keyStore = this.pm.getKeyStore(ks);
            if (keyStore == null) {
                throw new AxisFault("Key Store " + ks + " does not exist");
            }
            serviceDO.addTrustedCertStore(keyStore);
        }
        KeyStoreDO pkKeyStore = this.pm.getKeyStore(privateKeyStore);
        serviceDO.setPrivateKeyStore(pkKeyStore);
        this.pm.updateEntity((AbstractDataObject)serviceDO);
        this.configureScenario(serviceName, scenarioId, this.getServerCryptoProperties(trustedCertStores, privateKeyStore, pkKeyStore.getPrivateKeyAlias()));
        this.engageModules(serviceName, scenarioId);
    }

    public void assignUsersAndRoles(String serviceId, String serviceVersion, String scenarioId, String[] users, String[] roles) throws AxisFault {
        int i;
        ServiceDO serviceDO;
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService.getParameter("passwordCallbackRef") == null) {
            axisService.addParameter(WSS4JUtil.getPasswordCallBackRefParameter((String)serviceId, (String)serviceVersion));
        }
        if (serviceVersion == null || serviceVersion.trim().length() == 0) {
            serviceVersion = "$EMPTY$";
        }
        if ((serviceDO = this.pm.getService(serviceId, serviceVersion)) == null) {
            throw new AxisFault("Service " + serviceId + " not found!");
        }
        Iterator iter = serviceDO.getUsers().iterator();
        while (iter.hasNext()) {
            ServiceUserDO userDO = (ServiceUserDO)iter.next();
            userDO.getServices().remove(serviceDO);
            this.pm.updateEntity((AbstractDataObject)userDO);
        }
        iter = serviceDO.getRoles().iterator();
        while (iter.hasNext()) {
            ServiceUserRoleDO roleDO = (ServiceUserRoleDO)iter.next();
            roleDO.getServices().remove(serviceDO);
            this.pm.updateEntity((AbstractDataObject)roleDO);
        }
        serviceDO.removeAllUsers();
        serviceDO.removeAllRoles();
        try {
            this.pm.updateService(serviceDO);
        }
        catch (ServiceNotFoundException e) {
            // empty catch block
        }
        for (i = 0; i < users.length; ++i) {
            String user = users[i];
            if (user == null || user.trim().length() == 0) continue;
            serviceDO.setIsUTAuthEnabled(true);
            ServiceUserDO userDO = this.pm.getUser(user);
            serviceDO.addUser(userDO);
            this.pm.updateEntity((AbstractDataObject)userDO);
        }
        for (i = 0; i < roles.length; ++i) {
            String role = roles[i];
            if (role == null || role.trim().length() == 0) continue;
            serviceDO.setIsUTAuthEnabled(true);
            ServiceUserRoleDO roleDO = this.pm.getRole(role);
            serviceDO.addRole(roleDO);
            this.pm.updateEntity((AbstractDataObject)roleDO);
        }
        try {
            this.pm.updateService(serviceDO);
        }
        catch (ServiceNotFoundException e) {
            // empty catch block
        }
        this.configureScenario(serviceId, scenarioId, new Properties());
        this.engageModules(serviceId, scenarioId);
    }

    private void engageModules(String serviceId, String scenarioId) throws AxisFault {
        SecurityScenarioDO securityScenario = this.pm.getSecurityScenario(scenarioId);
        AxisService axisService = this.axisConfig.getService(serviceId);
        Iterator modules = securityScenario.modules.iterator();
        while (modules.hasNext()) {
            ModuleDO moduleDO = (ModuleDO)modules.next();
            String moduleName = moduleDO.getModuleIdentifierDO().getName();
            if (axisService.isEngaged(moduleName)) continue;
            AxisModule axisModule = this.axisConfig.getModule(moduleName);
            new ModuleAdmin(this.configCtx).engageModuleForService(axisModule.getName(), axisModule.getVersion(), serviceId, "$EMPTY$");
        }
    }

    private void disengageModules(String serviceId, String scenarioId) throws AxisFault {
        SecurityScenarioDO securityScenario = this.pm.getSecurityScenario(scenarioId);
        AxisService axisService = this.axisConfig.getService(serviceId);
        ModuleAdmin moduleAdmin = new ModuleAdmin(this.configCtx);
        Iterator modules = securityScenario.modules.iterator();
        while (modules.hasNext()) {
            String moduleVersion;
            ModuleDO moduleDO = (ModuleDO)modules.next();
            String moduleName = moduleDO.getModuleIdentifierDO().getName();
            AxisModule axisModule = this.axisConfig.getModule(moduleName, moduleVersion = moduleDO.getModuleIdentifierDO().getVersion());
            if (!axisService.isEngaged(axisModule)) continue;
            moduleAdmin.forceDisengageModuleFromService(axisModule.getName(), axisModule.getVersion(), serviceId, "$EMPTY$");
        }
    }

    public SecurityAssignment getSecurityAssignment(String serviceId, String serviceVersion) throws AxisFault {
        Iterator iterator;
        int i;
        ServiceDO serviceDO;
        SecurityAssignment assignment = new SecurityAssignment();
        if (serviceVersion == null || serviceVersion.trim().length() == 0) {
            serviceVersion = "$EMPTY$";
        }
        if ((serviceDO = this.pm.getService(serviceId, serviceVersion)) == null) {
            throw new AxisFault("Service " + serviceId + " not found!");
        }
        ArrayList<SelectableString> list = new ArrayList<SelectableString>();
        ServiceUserDO[] users = this.pm.getUsers();
        for (i = 0; i < users.length; ++i) {
            SelectableString user = new SelectableString();
            ServiceUserDO userDO = users[i];
            user.setString(userDO.getUsername());
            iterator = serviceDO.getUsers().iterator();
            while (iterator.hasNext()) {
                ServiceUserDO selectedUser = (ServiceUserDO)iterator.next();
                if (!userDO.getUsername().equals(selectedUser.getUsername())) continue;
                user.setSelected(true);
            }
            list.add(user);
        }
        assignment.setUsers(list.toArray(new SelectableString[list.size()]));
        list = new ArrayList();
        ServiceUserRoleDO[] roles = this.pm.getUserRoles();
        for (i = 0; i < roles.length; ++i) {
            SelectableString role = new SelectableString();
            ServiceUserRoleDO roleDO = roles[i];
            role.setString(roleDO.getRole());
            iterator = serviceDO.getRoles().iterator();
            while (iterator.hasNext()) {
                ServiceUserRoleDO selectedRole = (ServiceUserRoleDO)iterator.next();
                if (!roleDO.getRole().equals(selectedRole.getRole())) continue;
                role.setSelected(true);
            }
            list.add(role);
        }
        assignment.setRoles(list.toArray(new SelectableString[list.size()]));
        return assignment;
    }

    public UtKeystoreSecurityAssignment getUtKeystoreSecurityAssignment(String serviceName) throws AxisFault {
        UtKeystoreSecurityAssignment utKeystore = new UtKeystoreSecurityAssignment();
        utKeystore.setUt(this.getSecurityAssignment(serviceName, null));
        CryptoAdmin ca = new CryptoAdmin();
        utKeystore.setKeystore(ca.getServiceKeyStores(serviceName));
        return utKeystore;
    }

    private Properties getServerCryptoProperties(String[] trustedCertStores, String privateKeyStore, String privKeyAlias) {
        Properties props = RampartConfigUtil.getServerCryptoProperties((String[])trustedCertStores, (String)privateKeyStore, (String)privKeyAlias);
        props.setProperty(USER, privKeyAlias);
        return props;
    }
}

