/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.wso2.utils.ArchiveManipulator;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.admin.service.AbstractAdmin;
import org.wso2.wsas.admin.service.EJBProviderAdmin;
import org.wso2.wsas.admin.service.StatisticsClient;
import org.wso2.wsas.admin.service.TransportAdmin;
import org.wso2.wsas.admin.service.util.FaultService;
import org.wso2.wsas.admin.service.util.GenericApplicationContextUtil;
import org.wso2.wsas.admin.service.util.PolicyData;
import org.wso2.wsas.admin.service.util.ServiceMetaData;
import org.wso2.wsas.admin.service.util.ServiceRoleData;
import org.wso2.wsas.admin.service.util.ServiceUserData;
import org.wso2.wsas.admin.service.util.SpringBeansData;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.AbstractDataObject;
import org.wso2.wsas.persistence.dataobject.EJBAppServerDO;
import org.wso2.wsas.persistence.dataobject.EJBProviderDO;
import org.wso2.wsas.persistence.dataobject.OperationDO;
import org.wso2.wsas.persistence.dataobject.OperationParameterDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceParameterDO;
import org.wso2.wsas.persistence.dataobject.ServicePolicyDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;
import org.wso2.wsas.persistence.dataobject.TransportDO;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;
import org.wso2.wsas.persistence.exception.ServiceNotFoundException;
import org.wso2.wsas.persistence.exception.ServicePolicyAlreadyExistsException;
import org.wso2.wsas.persistence.exception.ServicePolicyNotFoundException;
import org.wso2.wsas.transport.util.TransportSummary;
import org.wso2.wsas.util.ParameterUtil;
import org.wso2.wsas.util.PolicyUtil;

public class ServiceAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog((Class)ServiceAdmin.class);
    private static final String SERVICE_MUST_CONTAIN_AT_LEAST_ONE_TRANSPORT = "Cannot remove transport binding. <br/>A service must contain at least one transport binding!";
    private PersistenceManager pm = new PersistenceManager();
    static /* synthetic */ Class class$org$apache$axis2$rpc$receivers$RPCInOnlyMessageReceiver;
    static /* synthetic */ Class class$org$apache$axis2$rpc$receivers$RPCMessageReceiver;
    static /* synthetic */ Class class$org$wso2$wsas$admin$service$spring$GenericApplicationContextSupplier;

    public ServiceAdmin() {
    }

    public ServiceAdmin(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
    }

    public String exposeServiceOnlyViaTransports(String serviceId, String[] transportProtocols) throws AxisFault {
        int i;
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        ArrayList<String> transports = new ArrayList<String>();
        for (int i2 = 0; i2 < transportProtocols.length; ++i2) {
            transports.add(transportProtocols[i2]);
        }
        axisService.setExposedTransports(transports);
        ServiceDO serviceDO = this.pm.getService(axisService.getName(), "$EMPTY$");
        serviceDO.setIsExposedOnAllTransports(false);
        TransportDO[] transportDOs = this.pm.getTransports();
        for (i = 0; i < transportDOs.length; ++i) {
            serviceDO.getTransports().remove(transportDOs[i]);
        }
        for (i = 0; i < transportProtocols.length; ++i) {
            TransportDO transportDO = this.pm.getTransport(transportProtocols[i]);
            serviceDO.addTransport(transportDO);
            this.pm.updateEntity((AbstractDataObject)transportDO);
        }
        try {
            this.pm.updateService(serviceDO);
        }
        catch (ServiceNotFoundException e) {
            String msg = "Service with name " + serviceId + " not found.";
            log.error((Object)msg);
            throw new AxisFault(msg, (Throwable)e);
        }
        return "Successfully add selected transport bindings to service " + serviceId;
    }

    public String addTransportBinding(String serviceId, String transportProtocol) throws AxisFault {
        if (transportProtocol == null || transportProtocol.trim().length() == 0) {
            return "Invalid transport " + transportProtocol;
        }
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService.isExposedTransport(transportProtocol)) {
            return "Service [" + serviceId + "] already contains the " + transportProtocol + " transport binding!";
        }
        ServiceDO serviceDO = this.pm.getService(axisService.getName(), "$EMPTY$");
        if (serviceDO.getIsUTAuthEnabled() && !transportProtocol.equalsIgnoreCase("https")) {
            throw new AxisFault("Cannot add non-HTTPS transport binding for Service [" + serviceId + "] since a security scenario which requires the " + "service to contain only the HTTPS transport binding" + " has been applied to this service.");
        }
        if (axisService.isEnableAllTransports()) {
            return "Service [" + serviceId + "] already contains the " + transportProtocol + " transport binding!";
        }
        axisService.addExposedTransport(transportProtocol);
        TransportDO transportDO = this.pm.getTransport(transportProtocol);
        if (transportDO != null) {
            serviceDO.setIsExposedOnAllTransports(false);
            serviceDO.addTransport(transportDO);
            try {
                this.pm.updateService(serviceDO);
                this.pm.updateEntity((AbstractDataObject)transportDO);
            }
            catch (ServiceNotFoundException e) {
                String msg = "Service with name " + serviceId + " not found.";
                log.error((Object)msg);
                throw new AxisFault(msg, (Throwable)e);
            }
        }
        return "Successfully added " + transportProtocol + " transport binding to service " + serviceId;
    }

    public String removeTransportBinding(String serviceId, String transportProtocol) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        ServiceDO serviceDO = this.pm.getService(axisService.getName(), "$EMPTY$");
        if (serviceDO.getIsUTAuthEnabled() && transportProtocol.equalsIgnoreCase("https")) {
            throw new AxisFault("HTTPS transport binding for Service [" + serviceId + "] cannot be removed since a security scenario which requires" + " HTTPS has been applied to this service.");
        }
        TransportDO transportDO = this.pm.getTransport(transportProtocol);
        if (!axisService.isEnableAllTransports()) {
            if (axisService.getExposedTransports().size() == 1) {
                return SERVICE_MUST_CONTAIN_AT_LEAST_ONE_TRANSPORT;
            }
            serviceDO.getTransports().remove(transportDO);
            transportDO.getServices().remove(serviceDO);
            axisService.removeExposedTransport(transportProtocol);
            this.pm.updateEntity((AbstractDataObject)transportDO);
        } else {
            TransportSummary[] transports = new TransportAdmin().listTransports();
            if (transports.length == 1) {
                return SERVICE_MUST_CONTAIN_AT_LEAST_ONE_TRANSPORT;
            }
            for (int i = 0; i < transports.length; ++i) {
                String protocol = transports[i].getProtocol();
                if (protocol.equals(transportProtocol)) continue;
                axisService.addExposedTransport(protocol);
                TransportDO addTransportDO = this.pm.getTransport(protocol);
                serviceDO.addTransport(addTransportDO);
                this.pm.updateEntity((AbstractDataObject)addTransportDO);
            }
        }
        serviceDO.setIsExposedOnAllTransports(false);
        try {
            this.pm.updateService(serviceDO);
        }
        catch (ServiceNotFoundException e) {
            String msg = "Service with name " + serviceId + " not found.";
            log.error((Object)msg);
            throw new AxisFault(msg, (Throwable)e);
        }
        return "Removed " + transportProtocol + " transport binding for " + serviceId + " service";
    }

    public String[] getExposedTransports(String serviceId) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (!axisService.isEnableAllTransports()) {
            List exposedTransports = axisService.getExposedTransports();
            return exposedTransports.toArray(new String[exposedTransports.size()]);
        }
        HashMap transportsIn = this.getConfigContext().getAxisConfiguration().getTransportsIn();
        String[] transports = new String[transportsIn.size()];
        int i = 0;
        Iterator transportsIter = transportsIn.values().iterator();
        while (transportsIter.hasNext()) {
            TransportInDescription tiDesc = (TransportInDescription)transportsIter.next();
            transports[i++] = tiDesc.getName();
        }
        return transports;
    }

    public void creatService(String serviceName) throws AxisFault {
        AxisService service = AxisService.createService((String)serviceName, (AxisConfiguration)this.getAxisConfig());
        this.getAxisConfig().addService(service);
    }

    public void stopService(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name " + serviceName);
        }
        ServiceDO service = this.pm.getService(serviceName, "$EMPTY$");
        service.setIsActive(false);
        this.pm.updateEntity((AbstractDataObject)service);
        this.getAxisConfig().stopService(serviceName);
    }

    public void startService(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name " + serviceName);
        }
        ServiceDO service = this.pm.getService(serviceName, "$EMPTY$");
        service.setIsActive(true);
        this.pm.updateEntity((AbstractDataObject)service);
        this.getAxisConfig().startService(serviceName);
    }

    private String[] getServiceEPRs(AxisService service) throws AxisFault {
        if (!service.isActive()) {
            return new String[]{"Service is inactive. No valid end point references."};
        }
        return service.getEPRs();
    }

    public ServiceMetaData getServiceData(String serviceName) throws AxisFault {
        AxisService service = this.getAxisConfig().getServiceForActivation(serviceName);
        Parameter serviceTypeParam = service.getParameter("serviceType");
        String serviceType = serviceTypeParam != null ? (String)serviceTypeParam.getValue() : "Normal";
        ArrayList<String> ops = new ArrayList<String>();
        Iterator opIter = service.getOperations();
        while (opIter.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)opIter.next();
            if (axisOperation.getName() == null) continue;
            ops.add(axisOperation.getName().getLocalPart());
        }
        ServiceMetaData smd = new ServiceMetaData();
        try {
            StatisticsClient statClient = new StatisticsClient();
            smd.setServiceRequestCount(statClient.getServiceRequestCount(serviceName));
            smd.setServiceResponseCount(statClient.getServiceResponseCount(serviceName));
            smd.setServiceFaultCount(statClient.getServiceFaultCount(serviceName));
            smd.setMaxResponseTime(statClient.getMaxServiceResponseTime(serviceName));
            smd.setMinResponseTime(statClient.getMinServiceResponseTime(serviceName));
            smd.setAvgResponseTime(statClient.getAvgServiceResponseTime(serviceName));
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        smd.setOperations(ops.toArray(new String[ops.size()]));
        smd.setName(serviceName);
        smd.setServiceId(serviceName);
        smd.setServiceVersion("");
        smd.setActive(service.isActive());
        smd.setEprs(this.getServiceEPRs(service));
        smd.setServiceType(serviceType);
        AxisServiceGroup serviceGroup = (AxisServiceGroup)service.getParent();
        smd.setFoundWebResources(serviceGroup.isFoundWebResources());
        smd.setScope(service.getScope());
        smd.setServiceGroupName(serviceGroup.getServiceGroupName());
        if (service.getDocumentation() != null) {
            smd.setDescription(service.getDocumentation());
        } else {
            smd.setDescription("No service description found");
        }
        Parameter parameter = service.getParameter("enableMTOM");
        if (parameter != null) {
            smd.setEnableMTOM((String)parameter.getValue());
        } else {
            smd.setEnableMTOM("false");
        }
        return smd;
    }

    public void configureMTOM(String flag, String serviceName) throws AxisFault {
        Parameter parameter;
        AxisService service = this.getAxisConfig().getService(serviceName);
        if (service == null) {
            throw new AxisFault("AxisService " + serviceName + " cannot be found.");
        }
        ArrayList parameters = service.getParameters();
        boolean found = false;
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter2 = (Parameter)iterator.next();
            if (parameter2.getParameterType() != 1 || !parameter2.getValue().toString().equals("enableMTOM")) continue;
            parameter2.setValue((Object)flag.trim());
            found = true;
            break;
        }
        if (!found) {
            parameter = ParameterUtil.createParameter((String)"enableMTOM", (String)flag.trim());
            service.addParameter(parameter);
        }
        parameter = service.getParameter("enableMTOM");
        Iterator iterator1 = service.getOperations();
        while (iterator1.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator1.next();
            axisOperation.addParameter(ParameterUtil.createParameter((String)"enableMTOM", (String)((String)parameter.getValue())));
        }
        ServiceDO serviceDO = this.pm.getService(serviceName, "$EMPTY$");
        ServiceParameterDO paramDO = this.pm.getServiceParameter(serviceDO, parameter.getName());
        if (paramDO != null) {
            paramDO.setValue(parameter.getParameterElement().toString());
            this.pm.updateEntity((AbstractDataObject)paramDO);
        } else {
            ServiceParameterDO param = new ServiceParameterDO();
            param.setName(parameter.getName());
            param.setValue(parameter.getParameterElement().toString());
            param.setService(serviceDO);
            try {
                this.pm.addEntity((AbstractDataObject)param);
            }
            catch (DuplicateEntityException e) {
                log.error((Object)"Service Parameter already exists", (Throwable)e);
            }
        }
        OperationDO[] operationDOs = this.pm.getOperations(serviceDO);
        if (operationDOs != null) {
            for (int j = 0; j < operationDOs.length; ++j) {
                OperationDO operationDO = operationDOs[j];
                OperationParameterDO[] operationParameterDOs = this.pm.getOperationParameters(operationDO);
                OperationParameterDO operationParameterDO = null;
                for (int k = 0; k < operationParameterDOs.length; ++k) {
                    if (!operationParameterDOs[k].getName().equals(parameter.getName())) continue;
                    operationParameterDO = operationParameterDOs[k];
                    break;
                }
                if (operationParameterDO != null) {
                    operationParameterDO.setValue(parameter.getParameterElement().toString());
                    this.pm.updateEntity((AbstractDataObject)operationParameterDO);
                    continue;
                }
                operationParameterDO = new OperationParameterDO();
                operationParameterDO.setName(parameter.getName());
                operationParameterDO.setValue(parameter.getParameterElement().toString());
                operationParameterDO.setOperation(operationDO);
                try {
                    this.pm.addEntity((AbstractDataObject)operationParameterDO);
                    continue;
                }
                catch (DuplicateEntityException e) {
                    log.error((Object)"Service Parameter already exists", (Throwable)e);
                }
            }
        }
    }

    public ServiceMetaData[] listServices(String serviceGroupId, String serviceGroupVersion) throws AxisFault {
        AxisServiceGroup asg = this.getAxisConfig().getServiceGroup(serviceGroupId);
        ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
        if (asg == null) {
            throw new AxisFault("Invalid service group name");
        }
        Iterator serviceIter = asg.getServices();
        while (serviceIter.hasNext()) {
            AxisService axisService = (AxisService)serviceIter.next();
            Parameter serviceTypeParam = axisService.getParameter("serviceType");
            String serviceType = serviceTypeParam != null ? (String)serviceTypeParam.getValue() : "Normal";
            ArrayList<String> ops = new ArrayList<String>();
            Iterator opIter = axisService.getOperations();
            while (opIter.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)opIter.next();
                ops.add(axisOperation.getName().getLocalPart());
            }
            ServiceMetaData smd = new ServiceMetaData();
            String serviceName = axisService.getName();
            try {
                StatisticsClient statClient = new StatisticsClient();
                smd.setServiceRequestCount(statClient.getServiceRequestCount(serviceName));
                smd.setServiceResponseCount(statClient.getServiceResponseCount(serviceName));
                smd.setServiceFaultCount(statClient.getServiceFaultCount(serviceName));
                smd.setMaxResponseTime(statClient.getMaxServiceResponseTime(serviceName));
                smd.setMinResponseTime(statClient.getMinServiceResponseTime(serviceName));
                smd.setAvgResponseTime(statClient.getAvgServiceResponseTime(serviceName));
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            smd.setOperations(ops.toArray(new String[ops.size()]));
            smd.setName(serviceName);
            smd.setServiceId(serviceName);
            smd.setEprs(this.getServiceEPRs(axisService));
            smd.setServiceVersion("");
            smd.setActive(axisService.isActive());
            smd.setServiceType(serviceType);
            smd.setDescription(axisService.getDocumentation());
            services.add(smd);
        }
        Collections.sort(services, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ServiceMetaData a = (ServiceMetaData)arg0;
                ServiceMetaData b = (ServiceMetaData)arg1;
                return a.getName().compareToIgnoreCase(b.getName());
            }
        });
        return services.toArray(new ServiceMetaData[services.size()]);
    }

    public Object[] getServiceInfo(String serviceId, String serviceVersion) throws AxisFault {
        throw new AxisFault("Operation not yet implemented");
    }

    public Object[] getServiceStatus(String serviceId, String serviceVersion) throws AxisFault {
        throw new AxisFault("Operation not yet implemented");
    }

    public OMElement[] getServiceParameters(String serviceId, String serviceVersion) throws AxisFault {
        ArrayList<OMElement> allParameter = new ArrayList<OMElement>();
        ArrayList globalParameters = this.getAxisConfig().getParameters();
        for (int i = 0; i < globalParameters.size(); ++i) {
            Parameter parameter = (Parameter)globalParameters.get(i);
            allParameter.add(parameter.getParameterElement());
        }
        AxisService service = this.getAxisConfig().getService(serviceId);
        if (service == null) {
            throw new AxisFault("Invalid service name");
        }
        ArrayList serviceParams = service.getParameters();
        for (int i = 0; i < serviceParams.size(); ++i) {
            Parameter parameter = (Parameter)serviceParams.get(i);
            if (parameter.getName() == null || parameter.getName().trim().length() == 0 || parameter.getParameterElement() == null) continue;
            allParameter.add(parameter.getParameterElement());
        }
        return allParameter.toArray(new OMElement[allParameter.size()]);
    }

    public OMElement[] getDeclaredServiceParameters(String serviceId, String serviceVersion) throws AxisFault {
        ArrayList<OMElement> allParameter = new ArrayList<OMElement>();
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("invalid service name " + serviceId);
        }
        ArrayList params = axisService.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            Parameter parameter = (Parameter)params.get(i);
            OMElement element = parameter.getParameterElement();
            if (element == null) continue;
            allParameter.add(element);
        }
        return allParameter.toArray(new OMElement[allParameter.size()]);
    }

    public void setServiceParameters(String serviceId, String serviceVersion, OMElement[] paramterElements) throws AxisFault {
        for (int i = 0; i < paramterElements.length; ++i) {
            this.setServiceParameter(serviceId, serviceVersion, paramterElements[i]);
        }
    }

    public void setServiceParameter3(String serviceId, Parameter parameter) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("Invalid service name '" + serviceId + "'");
        }
        ServiceDO serviceDO = this.pm.getService(serviceId, "$EMPTY$");
        Parameter p = axisService.getParameter(parameter.getName());
        ServiceParameterDO paramDO = this.pm.getServiceParameter(serviceDO, parameter.getName());
        if (p != null && paramDO != null) {
            if (!p.isLocked()) {
                axisService.addParameter(parameter);
                paramDO.setValue(parameter.getParameterElement().toString());
                this.pm.updateEntity((AbstractDataObject)paramDO);
            }
        } else if (p == null || !p.isLocked()) {
            axisService.addParameter(parameter);
            ServiceParameterDO param = new ServiceParameterDO();
            param.setName(parameter.getName());
            param.setValue(parameter.getParameterElement().toString());
            param.setService(serviceDO);
            try {
                this.pm.addEntity((AbstractDataObject)param);
            }
            catch (DuplicateEntityException e) {
                log.error((Object)"Service Parameter already exists", (Throwable)e);
            }
        }
    }

    public void setServiceParameter(String serviceId, String serviceVersion, OMElement paramterElement) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("Invalid service name '" + serviceId + "'");
        }
        ServiceDO serviceDO = this.pm.getService(serviceId, "$EMPTY$");
        Parameter parameter = ParameterUtil.createParameter((OMElement)paramterElement);
        Parameter p = axisService.getParameter(parameter.getName());
        ServiceParameterDO paramDO = this.pm.getServiceParameter(serviceDO, parameter.getName());
        if (p != null && paramDO != null) {
            if (!p.isLocked()) {
                axisService.addParameter(parameter);
                paramDO.setValue(paramterElement.toString());
                this.pm.updateEntity((AbstractDataObject)paramDO);
            }
        } else if (p == null || !p.isLocked()) {
            axisService.addParameter(parameter);
            ServiceParameterDO param = new ServiceParameterDO();
            param.setName(parameter.getName());
            param.setValue(paramterElement.toString());
            param.setService(serviceDO);
            try {
                this.pm.addEntity((AbstractDataObject)param);
            }
            catch (DuplicateEntityException e) {
                log.error((Object)"Service Parameter already exists", (Throwable)e);
            }
        }
    }

    public void removeServiceSpecificParameter(String serviceId, String serviceVersion, OMElement paramterElement) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("Invalid service name '" + serviceId + "'");
        }
        ServiceDO serviceDO = this.pm.getService(serviceId, "$EMPTY$");
        Parameter parameter = ParameterUtil.createParameter((OMElement)paramterElement);
        Parameter p = axisService.getParameter(parameter.getName());
        ServiceParameterDO paramDO = this.pm.getServiceParameter(serviceDO, parameter.getName());
        if (p != null && paramDO != null) {
            if (!p.isLocked()) {
                axisService.removeParameter(parameter);
                this.pm.deleteEntity((AbstractDataObject)paramDO);
            }
        } else if (p == null || !p.isLocked()) {
            axisService.removeParameter(parameter);
        }
    }

    public void setServiceParameter2(String serviceName, Parameter parameter) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        if (axisService == null) {
            throw new AxisFault("Invalid service name '" + serviceName + "'");
        }
        ServiceDO serviceDO = this.pm.getService(serviceName, "$EMPTY$");
        Parameter p = axisService.getParameter(parameter.getName());
        if (p != null) {
            if (!p.isLocked()) {
                axisService.addParameter(parameter);
                ServiceParameterDO paramDO = this.pm.getServiceParameter(serviceDO, parameter.getName());
                paramDO.setValue(p.getParameterElement().toString());
                this.pm.updateEntity((AbstractDataObject)paramDO);
            }
        } else {
            axisService.addParameter(parameter);
            ServiceParameterDO param = new ServiceParameterDO();
            param.setName(parameter.getName());
            param.setValue(parameter.getParameterElement().toString());
            param.setService(serviceDO);
            try {
                this.pm.addEntity((AbstractDataObject)param);
            }
            catch (DuplicateEntityException e) {
                log.error((Object)"Service Parameter already exists", (Throwable)e);
            }
        }
    }

    public void removeServiceParameter(String serviceName, String paramName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        axisService.removeParameter(new Parameter(paramName, null));
        ServiceDO serviceDO = this.pm.getService(serviceName, "$EMPTY$");
        ServiceParameterDO sp = new ServiceParameterDO();
        sp.setService(serviceDO);
        sp.setName(paramName);
        serviceDO.getParameters().remove(sp);
        this.pm.updateEntity((AbstractDataObject)serviceDO);
    }

    public OMElement getWSDL(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        if (axisService != null) {
            int seperatorIndex;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String url = MessageContext.getCurrentMessageContext().getTo().getAddress();
            int ipindex = url.indexOf("//");
            String ip = null;
            if (ipindex >= 0 && (seperatorIndex = (ip = url.substring(ipindex + 2, url.length())).indexOf(":")) > 0) {
                ip = ip.substring(0, seperatorIndex);
            }
            axisService.printWSDL((OutputStream)out, ip);
            try {
                XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(out.toByteArray()));
                OMFactory fac = OMAbstractFactory.getOMFactory();
                OMNamespace namespace = fac.createOMNamespace("http://org.apache.axis2/xsd", "ns1");
                OMElement wsdlWrapper = fac.createOMElement("getWSDLResponse", namespace);
                OMElement retvalue = fac.createOMElement("return", null);
                wsdlWrapper.addChild((OMNode)retvalue);
                StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
                retvalue.addChild((OMNode)staxOMBuilder.getDocumentElement());
                return wsdlWrapper;
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        return null;
    }

    public OMElement getSchema(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        if (axisService != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            axisService.printSchema((OutputStream)out);
            try {
                XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(out.toByteArray()));
                OMFactory fac = OMAbstractFactory.getOMFactory();
                OMElement wsdlWrapper = fac.createOMElement("getWSDLReponse", null);
                StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
                wsdlWrapper.addChild((OMNode)staxOMBuilder.getDocumentElement());
                return wsdlWrapper;
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        return null;
    }

    public OMElement getPolicy(String serviceId, String serviceVersion) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("invalid service name");
        }
        PolicyInclude servicePolicyInclude = axisService.getPolicyInclude();
        Policy servicePolicy = servicePolicyInclude.getPolicy();
        if (servicePolicy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement();
        }
        return PolicyUtil.getPolicyAsOMElement((Policy)servicePolicy);
    }

    public PolicyData[] getPolicies(String serviceId, String serviceVersion) throws AxisFault {
        PolicyData policyData;
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("invalid service name");
        }
        ArrayList<PolicyData> policyDataArray = new ArrayList<PolicyData>();
        PolicyInclude servicePolicyInclude = axisService.getPolicyInclude();
        PolicyRegistry registry = servicePolicyInclude.getPolicyRegistry();
        ArrayList policyList = servicePolicyInclude.getPolicyElements(3);
        if (!policyList.isEmpty()) {
            policyData = new PolicyData();
            policyData.setWrapper("Policies in services.xml");
            policyData.setPolycies(PolicyUtil.processPolicyElements(policyList.iterator(), (PolicyRegistry)registry));
            policyDataArray.add(policyData);
        }
        if (!(policyList = servicePolicyInclude.getPolicyElements(6)).isEmpty()) {
            policyData = new PolicyData();
            policyData.setWrapper("Policies in wsdl:service");
            policyData.setPolycies(PolicyUtil.processPolicyElements(policyList.iterator(), (PolicyRegistry)registry));
            policyDataArray.add(policyData);
        }
        if (!(policyList = servicePolicyInclude.getPolicyElements(8)).isEmpty()) {
            policyData = new PolicyData();
            policyData.setWrapper("Policies in wsdl:portType");
            policyData.setPolycies(PolicyUtil.processPolicyElements(policyList.iterator(), (PolicyRegistry)registry));
            policyDataArray.add(policyData);
        }
        if (!(policyList = servicePolicyInclude.getPolicyElements(7)).isEmpty()) {
            policyData = new PolicyData();
            policyData.setWrapper("Policies in wsdl:port");
            policyData.setPolycies(PolicyUtil.processPolicyElements(policyList.iterator(), (PolicyRegistry)registry));
            policyDataArray.add(policyData);
        }
        if (!(policyList = servicePolicyInclude.getPolicyElements(9)).isEmpty()) {
            policyData = new PolicyData();
            policyData.setWrapper("Policies in wsdl:binding");
            policyData.setPolycies(PolicyUtil.processPolicyElements(policyList.iterator(), (PolicyRegistry)registry));
            policyDataArray.add(policyData);
        }
        return policyDataArray.toArray(new PolicyData[policyDataArray.size()]);
    }

    public void removePolicy(String serviceId, String version, String policyId) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("Invalid service name " + serviceId);
        }
        axisService.getPolicyInclude().removePolicyElement(policyId);
        ServiceDO serviceDO = this.pm.getService(serviceId, version);
        ArrayList<ServicePolicyDO> policiesToBeRemoved = new ArrayList<ServicePolicyDO>();
        Iterator policyIter = serviceDO.getPolicies().iterator();
        while (policyIter.hasNext()) {
            ServicePolicyDO servicePolicyDO = (ServicePolicyDO)policyIter.next();
            if (!servicePolicyDO.getUuid().equals(policyId)) continue;
            policiesToBeRemoved.add(servicePolicyDO);
        }
        Set policies = serviceDO.getPolicies();
        Iterator iterator = policiesToBeRemoved.iterator();
        while (iterator.hasNext()) {
            policies.remove(iterator.next());
        }
        this.pm.updateEntity((AbstractDataObject)serviceDO);
    }

    public void setPolicy(String serviceId, String version, String policyString) throws AxisFault {
        Policy servicePolicy;
        OMAttribute attribute;
        OMElement policyElement;
        ByteArrayInputStream bais = new ByteArrayInputStream(policyString.getBytes());
        try {
            policyElement = new StAXOMBuilder((InputStream)bais).getDocumentElement();
            policyElement.build();
        }
        catch (Exception e) {
            throw new AxisFault("Cannot deserialize service policy. The policy may be invalid.", (Throwable)e);
        }
        AxisService axisService = this.getAxisConfig().getService(serviceId);
        if (axisService == null) {
            throw new AxisFault("Invalid service name " + serviceId);
        }
        if (!policyElement.getLocalName().equals("Policy")) {
            policyElement = policyElement.getFirstElement();
        }
        if ((attribute = policyElement.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"))) == null) {
            throw new AxisFault("ID Attribute not found in Policy element. Please verify that the policy XML is valid.");
        }
        String idAttrVal = attribute.getAttributeValue();
        PolicyInclude policyInclude = axisService.getPolicyInclude();
        try {
            servicePolicy = PolicyUtil.getPolicyFromOMElement((OMElement)policyElement);
        }
        catch (NullPointerException npe) {
            log.error((Object)("Error: When constructing Policy object from the string : " + policyElement.toString()), (Throwable)npe);
            throw new AxisFault("Error: Invalid policy", (Throwable)npe);
        }
        catch (RuntimeException rte) {
            log.error((Object)("Error: When constructing Policy object from the string : " + policyElement.toString()), (Throwable)rte);
            throw new AxisFault("Error: Invalid policy", (Throwable)rte);
        }
        ServicePolicyDO servicePolicyDO = new ServicePolicyDO();
        servicePolicyDO.setUuid(idAttrVal);
        servicePolicyDO.setService(this.pm.getService(serviceId, "$EMPTY$"));
        servicePolicyDO.setPolicy(policyElement.toString());
        if (policyInclude.getPolicy(idAttrVal) != null) {
            policyInclude.updatePolicy(servicePolicy);
            try {
                this.pm.updateServicePolicy(servicePolicyDO);
            }
            catch (ServicePolicyNotFoundException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        policyInclude.addPolicyElement(3, servicePolicy);
        servicePolicyDO.setType(3);
        try {
            this.pm.addServicePolicy(servicePolicyDO);
        }
        catch (ServicePolicyAlreadyExistsException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public String[] getServiceUsers(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name " + serviceName);
        }
        ArrayList<String> users = new ArrayList<String>();
        ServiceUserDO[] userDOs = this.pm.getUsersForService(serviceName, "$EMPTY$");
        for (int i = 0; i < userDOs.length; ++i) {
            ServiceUserDO userDO = userDOs[i];
            users.add(userDO.getUsername());
        }
        return users.toArray(new String[users.size()]);
    }

    public ServiceUserData[] getServiceUsersWithDescription(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name " + serviceName);
        }
        ServiceUserDO[] userDOs = this.pm.getUsersForService(serviceName, "$EMPTY$");
        ServiceUserData[] suData = new ServiceUserData[userDOs.length];
        if (userDOs.length == 0) {
            return new ServiceUserData[0];
        }
        for (int i = 0; i < suData.length; ++i) {
            ServiceUserDO serviceUserData = userDOs[i];
            ServiceUserData userData = new ServiceUserData();
            userData.setUser(serviceUserData.getUsername());
            userData.setDescription(serviceUserData.getDescription());
            suData[i] = userData;
        }
        return suData;
    }

    public ServiceRoleData[] getServiceRolesWithDescription(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name " + serviceName);
        }
        ServiceUserRoleDO[] roleDOs = this.pm.getRolesForService(serviceName, "$EMPTY$");
        ServiceRoleData[] srData = new ServiceRoleData[roleDOs.length];
        if (roleDOs.length == 0) {
            return new ServiceRoleData[0];
        }
        for (int i = 0; i < srData.length; ++i) {
            ServiceUserRoleDO serviceRoleData = roleDOs[i];
            ServiceRoleData roleData = new ServiceRoleData();
            roleData.setRole(serviceRoleData.getRole());
            roleData.setDescription(serviceRoleData.getDescription());
            srData[i] = roleData;
        }
        return srData;
    }

    public String[] getClassNames(String archiveId) throws AxisFault {
        String filePath = this.getFilePathFromArchiveId(archiveId);
        if (filePath != null) {
            try {
                String[] entries = new ArchiveManipulator().check(filePath);
                ArrayList<String> classnames = new ArrayList<String>();
                for (int i = 0; i < entries.length; ++i) {
                    String entry = entries[i];
                    if (!entry.endsWith(".class")) continue;
                    entry = entry.replace('/', '.').substring(0, entry.lastIndexOf(".class"));
                    classnames.add(entry);
                }
                return classnames.toArray(new String[classnames.size()]);
            }
            catch (IOException e) {
                String msg = "Could not read archive";
                log.error((Object)msg, (Throwable)e);
                throw new AxisFault(msg, (Throwable)e);
            }
        }
        return new String[]{""};
    }

    public void createAndDeployService(String archiveId, String[] serviceClasses) throws AxisFault {
        String filePathFromArchiveId = this.getFilePathFromArchiveId(archiveId);
        if (filePathFromArchiveId == null) {
            String msg = "A non-existent file was requested";
            log.warn((Object)msg);
            throw new AxisFault(msg);
        }
        int endIndex = filePathFromArchiveId.lastIndexOf(File.separator);
        String filePath = filePathFromArchiveId.substring(0, endIndex);
        String archiveFileName = filePathFromArchiveId.substring(endIndex);
        archiveFileName = archiveFileName.substring(0, archiveFileName.lastIndexOf("."));
        ArchiveManipulator archiveManipulator = new ArchiveManipulator();
        String unzippeDir = filePath + File.separator + "temp";
        File unzipped = new File(unzippeDir);
        unzipped.mkdirs();
        try {
            archiveManipulator.extract(filePathFromArchiveId, unzippeDir);
        }
        catch (IOException e) {
            throw new AxisFault("Cannot extract archive", (Throwable)e);
        }
        File file = new File(unzippeDir + File.separator + "META-INF" + File.separator + "services.xml");
        file.mkdirs();
        try {
            File absoluteFile = file.getAbsoluteFile();
            if (absoluteFile.exists()) {
                absoluteFile.delete();
            }
            absoluteFile.createNewFile();
            FileOutputStream os = new FileOutputStream(file);
            OMElement servicesXML = this.createServicesXML(serviceClasses);
            servicesXML.build();
            servicesXML.serialize((OutputStream)os);
        }
        catch (Exception e) {
            String msg = "Cannot write services XML";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        String outAARFilename = filePath + File.separator + archiveFileName + ".aar";
        try {
            archiveManipulator.archiveDir(outAARFilename, unzipped.getPath());
        }
        catch (IOException e) {
            String msg = "Cannot create new AAR archive";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        String repo = MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration().getRepository().getPath() + File.separator + "services";
        try {
            new FileManipulator().copyFile(new File(outAARFilename), new File(repo + File.separator + archiveFileName + ".aar"));
        }
        catch (IOException e) {
            String msg = "Cannot copy AAR file to Repo";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    private OMElement createServicesXMLFromSpringBeans(String[] springBeans, String springContextLocation) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace emptyNS = factory.createOMNamespace("", "");
        OMElement serviceGroupEle = factory.createOMElement("serviceGroup", "", "");
        for (int i = 0; i < springBeans.length; ++i) {
            String serviceBeanName = springBeans[i];
            OMElement serviceEle = factory.createOMElement("service", "", "");
            OMElement schemaEle = factory.createOMElement("schema", "", "");
            schemaEle.addAttribute(factory.createOMAttribute("elementFormDefaultQualified", emptyNS, "false"));
            serviceEle.addAttribute(factory.createOMAttribute("name", emptyNS, serviceBeanName));
            OMElement msgReceiversEle = factory.createOMElement("messageReceivers", "", "");
            OMElement msgReceiverEle1 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle1.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-only", emptyNS);
            msgReceiverEle1.addAttribute("class", (class$org$apache$axis2$rpc$receivers$RPCInOnlyMessageReceiver == null ? ServiceAdmin.class$("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver") : class$org$apache$axis2$rpc$receivers$RPCInOnlyMessageReceiver).getName(), emptyNS);
            OMElement msgReceiverEle2 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle2.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-out", emptyNS);
            msgReceiverEle2.addAttribute("class", (class$org$apache$axis2$rpc$receivers$RPCMessageReceiver == null ? ServiceAdmin.class$("org.apache.axis2.rpc.receivers.RPCMessageReceiver") : class$org$apache$axis2$rpc$receivers$RPCMessageReceiver).getName(), emptyNS);
            msgReceiversEle.addChild((OMNode)msgReceiverEle1);
            msgReceiversEle.addChild((OMNode)msgReceiverEle2);
            OMElement parameterEleServiceObjectSupplier = factory.createOMElement("parameter", "", "");
            parameterEleServiceObjectSupplier.addAttribute("locked", "true", emptyNS);
            parameterEleServiceObjectSupplier.addAttribute("name", "ServiceObjectSupplier", emptyNS);
            parameterEleServiceObjectSupplier.setText((class$org$wso2$wsas$admin$service$spring$GenericApplicationContextSupplier == null ? ServiceAdmin.class$("org.wso2.wsas.admin.service.spring.GenericApplicationContextSupplier") : class$org$wso2$wsas$admin$service$spring$GenericApplicationContextSupplier).getName());
            OMElement parameterEleSpringBeanName = factory.createOMElement("parameter", "", "");
            parameterEleSpringBeanName.addAttribute("locked", "true", emptyNS);
            parameterEleSpringBeanName.addAttribute("name", "SpringBeanName", emptyNS);
            parameterEleSpringBeanName.setText(serviceBeanName);
            OMElement parameterEleSpringContextLocation = factory.createOMElement("parameter", "", "");
            parameterEleSpringContextLocation.addAttribute("locked", "true", emptyNS);
            parameterEleSpringContextLocation.addAttribute("name", "SpringContextLocation", emptyNS);
            parameterEleSpringContextLocation.setText(springContextLocation);
            serviceEle.addChild((OMNode)schemaEle);
            serviceEle.addChild((OMNode)msgReceiversEle);
            serviceEle.addChild((OMNode)parameterEleServiceObjectSupplier);
            serviceEle.addChild((OMNode)parameterEleSpringBeanName);
            serviceEle.addChild((OMNode)parameterEleSpringContextLocation);
            serviceGroupEle.addChild((OMNode)serviceEle);
        }
        return serviceGroupEle;
    }

    private OMElement createServicesXML(String[] serviceClasses) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace emptyNS = factory.createOMNamespace("", "");
        OMElement serviceGroupEle = factory.createOMElement("serviceGroup", "", "");
        for (int i = 0; i < serviceClasses.length; ++i) {
            String serviceClass = serviceClasses[i];
            String serviceName = serviceClass.substring(serviceClass.lastIndexOf(".") + 1);
            OMElement serviceEle = factory.createOMElement("service", "", "");
            OMElement schemaEle = factory.createOMElement("schema", "", "");
            schemaEle.addAttribute(factory.createOMAttribute("elementFormDefaultQualified", emptyNS, "false"));
            serviceEle.addAttribute(factory.createOMAttribute("name", emptyNS, serviceName));
            OMElement msgReceiversEle = factory.createOMElement("messageReceivers", "", "");
            OMElement msgReceiverEle1 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle1.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-only", emptyNS);
            msgReceiverEle1.addAttribute("class", "org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver", emptyNS);
            OMElement msgReceiverEle2 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle2.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-out", emptyNS);
            msgReceiverEle2.addAttribute("class", "org.apache.axis2.rpc.receivers.RPCMessageReceiver", emptyNS);
            msgReceiversEle.addChild((OMNode)msgReceiverEle1);
            msgReceiversEle.addChild((OMNode)msgReceiverEle2);
            OMElement parameterEle = factory.createOMElement("parameter", "", "");
            parameterEle.addAttribute("locked", "false", emptyNS);
            parameterEle.addAttribute("name", "ServiceClass", emptyNS);
            parameterEle.setText(serviceClass);
            serviceEle.addChild((OMNode)schemaEle);
            serviceEle.addChild((OMNode)msgReceiversEle);
            serviceEle.addChild((OMNode)parameterEle);
            serviceGroupEle.addChild((OMNode)serviceEle);
        }
        return serviceGroupEle;
    }

    private String getFilePathFromArchiveId(String archiveId) {
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        Map fileResMap = (Map)configCtx.getProperty("file.resource.map");
        return (String)fileResMap.get(archiveId);
    }

    public boolean deleteFaultyServiceArchive(String archiveName) throws AxisFault {
        File file;
        if (File.separatorChar == '\\') {
            archiveName = archiveName.replace('/', '\\');
        }
        boolean isDeleted = false;
        if (archiveName != null && archiveName.trim().length() != 0 && (file = new File(archiveName)).exists()) {
            if (!(file.isDirectory() && new FileManipulator().deleteDir(file) || file.delete())) {
                throw new AxisFault("Faulty service archive deletion failed. Due to a JVM issue on MS-Windows, AAR files cannot be deleted. Please stop the server and manually delete this file.");
            }
            isDeleted = true;
            this.getAxisConfig().getFaultyServices().remove(archiveName);
        }
        return isDeleted;
    }

    public FaultService[] getFaultyServiceArchives() throws AxisFault {
        AxisConfiguration ac = this.getAxisConfig();
        Hashtable faultyServices = ac.getFaultyServices();
        ArrayList<FaultService> fsList = new ArrayList<FaultService>();
        Iterator keys = faultyServices.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String fault = (String)faultyServices.get(key);
            FaultService fs = new FaultService();
            if (File.separatorChar == '\\') {
                key = key.replace('\\', '/');
            }
            fs.setServiceName(key);
            fs.setFault(fault);
            fsList.add(fs);
        }
        return fsList.toArray(new FaultService[fsList.size()]);
    }

    public int getNumberOfFaultyServices() throws AxisFault {
        return this.getAxisConfig().getFaultyServices().size();
    }

    public SpringBeansData getSpringBeanNames(String springContextId, String springBeanId) throws AxisFault {
        String springContextFilePath = this.getFilePathFromArchiveId(springContextId);
        String springBeanFilePath = this.getFilePathFromArchiveId(springBeanId);
        String springUUID = this.storeSpringCtx(springContextFilePath);
        SpringBeansData data = new SpringBeansData();
        data.setSpringContext(springUUID);
        try {
            GenericApplicationContext aCtx = GenericApplicationContextUtil.getSpringApplicationContext(springContextFilePath, springBeanFilePath);
            String[] beanDefintions = aCtx.getBeanDefinitionNames();
            data.setBeans(beanDefintions);
        }
        catch (Exception e) {
            throw new AxisFault("Cannot load Spring beans. Please check the Spring context configuration file and verify that the defined Spring beans exist in the .jar file.");
        }
        return data;
    }

    private String storeSpringCtx(String springContextFilePath) throws AxisFault {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String springFileName = springContextFilePath.substring(springContextFilePath.lastIndexOf(File.separator) + 1);
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        File springDir = new File(serverConfig.getFirstProperty("Axis2Config.RepositoryLocation") + File.separator + "spring" + File.separator + uuid);
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        Map fileResMap = (Map)configCtx.getProperty("file.resource.map");
        if (!springDir.exists()) {
            springDir.mkdirs();
        }
        springDir = new File(springDir.getAbsolutePath(), springFileName);
        fileResMap.put(uuid, springDir.getAbsolutePath());
        try {
            int len;
            File file = new File(springContextFilePath);
            FileInputStream in = new FileInputStream(file);
            FileOutputStream out = new FileOutputStream(springDir);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        return uuid;
    }

    public void createAndDeploySpringBean(String springContextId, String springBeanId, String[] beanClasses) throws AxisFault {
        String filePathFromArchiveId = this.getFilePathFromArchiveId(springBeanId);
        String filePathForSpringContext = this.getFilePathFromArchiveId(springContextId);
        ConfigurationContext configCtx = MessageContext.getCurrentMessageContext().getConfigurationContext();
        Map fileResMap = (Map)configCtx.getProperty("file.resource.map");
        fileResMap.remove(springContextId);
        if (filePathFromArchiveId == null) {
            String msg = "A non-existent file was requested";
            log.warn((Object)msg);
            throw new AxisFault(msg);
        }
        int endIndex = filePathFromArchiveId.lastIndexOf(File.separator);
        String filePath = filePathFromArchiveId.substring(0, endIndex);
        String archiveFileName = filePathFromArchiveId.substring(endIndex);
        archiveFileName = archiveFileName.substring(0, archiveFileName.lastIndexOf("."));
        ArchiveManipulator archiveManipulator = new ArchiveManipulator();
        String unzippeDir = filePath + File.separator + "springTemp";
        File unzipped = new File(unzippeDir);
        unzipped.mkdirs();
        try {
            archiveManipulator.extract(filePathFromArchiveId, unzippeDir);
        }
        catch (IOException e) {
            throw new AxisFault("Cannot extract archive", (Throwable)e);
        }
        File file = new File(unzippeDir + File.separator + "META-INF" + File.separator + "services.xml");
        file.mkdirs();
        try {
            File absoluteFile = file.getAbsoluteFile();
            if (absoluteFile.exists()) {
                absoluteFile.delete();
            }
            absoluteFile.createNewFile();
            FileOutputStream os = new FileOutputStream(file);
            OMElement servicesXML = this.createServicesXMLFromSpringBeans(beanClasses, filePathForSpringContext);
            servicesXML.build();
            servicesXML.serialize((OutputStream)os);
        }
        catch (Exception e) {
            String msg = "Cannot write services XML";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        String outAARFilename = filePath + File.separator + archiveFileName + ".aar";
        try {
            archiveManipulator.archiveDir(outAARFilename, unzipped.getPath());
        }
        catch (IOException e) {
            String msg = "Cannot create new AAR archive";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        String repo = MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration().getRepository().getPath() + File.separator + "services";
        try {
            new FileManipulator().copyFile(new File(outAARFilename), new File(repo + File.separator + archiveFileName + ".aar"));
        }
        catch (IOException e) {
            String msg = "Cannot copy AAR file to Repo";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public void createAndDeployEJBService(String archiveId, String[] serviceClasses, String jnpProviderUrl, String beanJNDIName, String homeInterface, String remoteInterface) throws AxisFault {
        EJBAppServerDO ejbAppServerDO = this.pm.getEJBAppServerConfiguration(jnpProviderUrl);
        if (ejbAppServerDO == null) {
            throw new AxisFault("Non-existance Application server configuration");
        }
        EJBProviderAdmin ejbProviderAdmin = new EJBProviderAdmin();
        try {
            EJBProviderDO ejbProviderDO = ejbProviderAdmin.getEJBConfiguration(beanJNDIName, jnpProviderUrl);
            if (ejbProviderDO != null) {
                throw new AxisFault("A Service exists for the provided JNDI name(" + beanJNDIName + ") and JNP Url(" + jnpProviderUrl + ").");
            }
        }
        catch (Exception e) {
            throw new AxisFault("A Service exists for the provided JNDI name(" + beanJNDIName + ") and JNP Url(" + jnpProviderUrl + ").");
        }
        ejbProviderAdmin.addEJBConfiguration(ejbAppServerDO.getProviderURL(), ejbAppServerDO.getJndiContextClass(), ejbAppServerDO.getUserName(), ejbAppServerDO.getUserName(), beanJNDIName, homeInterface, remoteInterface, ejbAppServerDO.getAppServerType());
        String filePathFromArchiveId = this.getFilePathFromArchiveId(archiveId);
        if (filePathFromArchiveId == null) {
            String msg = "A non-existent file was requested";
            log.warn((Object)msg);
            throw new AxisFault(msg);
        }
        int endIndex = filePathFromArchiveId.lastIndexOf(File.separator);
        String filePath = filePathFromArchiveId.substring(0, endIndex);
        String archiveFileName = filePathFromArchiveId.substring(endIndex);
        archiveFileName = archiveFileName.substring(0, archiveFileName.lastIndexOf("."));
        ArchiveManipulator archiveManipulator = new ArchiveManipulator();
        String unzippeDir = filePath + File.separator + "temp";
        File unzipped = new File(unzippeDir);
        unzipped.mkdirs();
        try {
            archiveManipulator.extract(filePathFromArchiveId, unzippeDir);
        }
        catch (IOException e) {
            throw new AxisFault("Cannot extract archive", (Throwable)e);
        }
        File file = new File(unzippeDir + File.separator + "META-INF" + File.separator + "services.xml");
        file.mkdirs();
        try {
            File absoluteFile = file.getAbsoluteFile();
            if (absoluteFile.exists()) {
                absoluteFile.delete();
            }
            absoluteFile.createNewFile();
            FileOutputStream os = new FileOutputStream(file);
            OMElement servicesXML = this.createServicesXMLForEJBService(serviceClasses, ejbAppServerDO.getProviderURL(), ejbAppServerDO.getJndiContextClass(), ejbAppServerDO.getUserName(), ejbAppServerDO.getPassword(), beanJNDIName, homeInterface, remoteInterface);
            servicesXML.build();
            servicesXML.serialize((OutputStream)os);
        }
        catch (Exception e) {
            String msg = "Cannot write services XML";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        String outAARFilename = filePath + File.separator + archiveFileName + ".aar";
        try {
            archiveManipulator.archiveDir(outAARFilename, unzipped.getPath());
        }
        catch (IOException e) {
            String msg = "Cannot create new AAR archive";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        String repo = MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration().getRepository().getPath() + File.separator + "services";
        try {
            new FileManipulator().copyFile(new File(outAARFilename), new File(repo + File.separator + archiveFileName + ".aar"));
        }
        catch (IOException e) {
            String msg = "Cannot copy AAR file to Repo";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    private OMElement createServicesXMLForEJBService(String[] serviceClasses, String providerURL, String jndiContextClass, String userName, String password, String beanJNDIName, String homeInterface, String remoteInterface) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace emptyNS = factory.createOMNamespace("", "");
        OMElement serviceGroupEle = factory.createOMElement("serviceGroup", "", "");
        for (int i = 0; i < serviceClasses.length; ++i) {
            String serviceClass = serviceClasses[i];
            String serviceName = serviceClass.substring(serviceClass.lastIndexOf(".") + 1);
            OMElement serviceEle = factory.createOMElement("service", "", "");
            OMElement schemaEle = factory.createOMElement("schema", "", "");
            schemaEle.addAttribute(factory.createOMAttribute("elementFormDefaultQualified", emptyNS, "false"));
            serviceEle.addAttribute(factory.createOMAttribute("name", emptyNS, serviceName));
            OMElement msgReceiversEle = factory.createOMElement("messageReceivers", "", "");
            OMElement msgReceiverEle1 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle1.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-only", emptyNS);
            msgReceiverEle1.addAttribute("class", "org.apache.axis2.rpc.receivers.ejb.EJBInOnlyMessageReceiver", emptyNS);
            OMElement msgReceiverEle2 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle2.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-out", emptyNS);
            msgReceiverEle2.addAttribute("class", "org.apache.axis2.rpc.receivers.ejb.EJBMessageReceiver", emptyNS);
            msgReceiversEle.addChild((OMNode)msgReceiverEle1);
            msgReceiversEle.addChild((OMNode)msgReceiverEle2);
            OMElement parameterEle1 = factory.createOMElement("parameter", "", "");
            parameterEle1.addAttribute("name", "remoteInterfaceName", emptyNS);
            parameterEle1.setText(remoteInterface);
            OMElement parameterEle2 = factory.createOMElement("parameter", "", "");
            parameterEle2.addAttribute("name", "homeInterfaceName", emptyNS);
            parameterEle2.setText(homeInterface);
            OMElement parameterEle3 = factory.createOMElement("parameter", "", "");
            parameterEle3.addAttribute("name", "beanJndiName", emptyNS);
            parameterEle3.setText(beanJNDIName);
            OMElement parameterEle4 = factory.createOMElement("parameter", "", "");
            parameterEle4.addAttribute("name", "providerUrl", emptyNS);
            parameterEle4.setText(providerURL);
            OMElement parameterEle5 = factory.createOMElement("parameter", "", "");
            parameterEle5.addAttribute("name", "jndiContextClass", emptyNS);
            parameterEle5.setText(jndiContextClass);
            OMElement parameterEle6 = factory.createOMElement("parameter", "", "");
            parameterEle6.addAttribute("name", "jndiUser", emptyNS);
            parameterEle6.setText(userName);
            OMElement parameterEle7 = factory.createOMElement("parameter", "", "");
            parameterEle7.addAttribute("name", "jndiPassword", emptyNS);
            parameterEle7.setText(password);
            OMElement parameterEle8 = factory.createOMElement("parameter", "", "");
            parameterEle8.addAttribute("name", "ServiceClass", emptyNS);
            parameterEle8.setText(serviceClass);
            OMElement parameterEle9 = factory.createOMElement("parameter", "", "");
            parameterEle9.addAttribute("name", "serviceType", emptyNS);
            parameterEle9.setText("ejb_service");
            serviceEle.addChild((OMNode)schemaEle);
            serviceEle.addChild((OMNode)msgReceiversEle);
            serviceEle.addChild((OMNode)parameterEle1);
            serviceEle.addChild((OMNode)parameterEle2);
            serviceEle.addChild((OMNode)parameterEle3);
            serviceEle.addChild((OMNode)parameterEle4);
            serviceEle.addChild((OMNode)parameterEle5);
            serviceEle.addChild((OMNode)parameterEle6);
            serviceEle.addChild((OMNode)parameterEle7);
            serviceEle.addChild((OMNode)parameterEle8);
            serviceEle.addChild((OMNode)parameterEle9);
            serviceGroupEle.addChild((OMNode)serviceEle);
        }
        return serviceGroupEle;
    }
}

