/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.admin.service.AbstractAdmin;
import org.wso2.wsas.admin.service.util.ServiceArchiveCreator;
import org.wso2.wsas.admin.service.util.ServiceGroupMetaData;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.AbstractDataObject;
import org.wso2.wsas.persistence.dataobject.OperationDO;
import org.wso2.wsas.persistence.dataobject.OperationParameterDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceGroupDO;
import org.wso2.wsas.persistence.dataobject.ServiceGroupParameterDO;
import org.wso2.wsas.persistence.dataobject.ServiceParameterDO;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;
import org.wso2.wsas.util.AdminFilter;
import org.wso2.wsas.util.ParameterUtil;
import org.wso2.wsas.util.PolicyUtil;
import org.wso2.wsas.util.Utils;

public class ServiceGroupAdmin
extends AbstractAdmin {
    private static Log log = LogFactory.getLog((Class)ServiceGroupAdmin.class);
    private PersistenceManager pm = new PersistenceManager();

    public ServiceGroupMetaData listServiceGroup(String serviceGroupName) throws AxisFault {
        ServiceGroupMetaData sgmd = new ServiceGroupMetaData();
        AxisServiceGroup serviceGroup = this.getAxisConfig().getServiceGroup(serviceGroupName);
        sgmd.setGroup_name(serviceGroup.getServiceGroupName());
        Parameter parameter = serviceGroup.getParameter("enableMTOM");
        if (parameter != null) {
            sgmd.setEnableMTOM((String)parameter.getValue());
        }
        return sgmd;
    }

    public ServiceGroupMetaData configureMTOM(String flag, String serviceGroupName) throws AxisFault {
        ServiceDO[] serviceDOs;
        Parameter parameter;
        AxisServiceGroup serviceGroup = this.getAxisConfig().getServiceGroup(serviceGroupName);
        if (serviceGroup == null) {
            throw new AxisFault("Service group " + serviceGroupName + "cannnot be found!");
        }
        ArrayList parameters = serviceGroup.getParameters();
        boolean found = false;
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter2 = (Parameter)iterator.next();
            if (parameter2.getParameterType() != 1 || !parameter2.getValue().toString().equals("enableMTOM")) continue;
            parameter2.setValue((Object)flag.trim());
            found = true;
            break;
        }
        if (!found) {
            parameter = ParameterUtil.createParameter((String)"enableMTOM", (String)flag.trim());
            serviceGroup.addParameter(parameter);
        }
        parameter = serviceGroup.getParameter("enableMTOM");
        Iterator iterator2 = serviceGroup.getServices();
        while (iterator2.hasNext()) {
            AxisService axisServce = (AxisService)iterator2.next();
            axisServce.addParameter(ParameterUtil.createParameter((String)"enableMTOM", (String)((String)parameter.getValue())));
            Iterator iterator1 = axisServce.getOperations();
            while (iterator1.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)iterator1.next();
                axisOperation.addParameter(ParameterUtil.createParameter((String)"enableMTOM", (String)((String)parameter.getValue())));
            }
        }
        ServiceGroupDO serviceGroupDO = this.pm.getServiceGroup(serviceGroupName);
        ServiceGroupParameterDO sgParamDO = serviceGroupDO.getParameter(parameter.getName());
        if (sgParamDO != null) {
            sgParamDO.setValue(parameter.getParameterElement().toString());
            this.pm.updateEntity((AbstractDataObject)sgParamDO);
        } else {
            sgParamDO = new ServiceGroupParameterDO();
            sgParamDO.setName(parameter.getName());
            sgParamDO.setValue(parameter.getParameterElement().toString());
            sgParamDO.setServiceGroup(serviceGroupDO);
            try {
                this.pm.addEntity((AbstractDataObject)sgParamDO);
            }
            catch (DuplicateEntityException e) {
                log.error((Object)"Service Parameter already exists", (Throwable)e);
            }
        }
        serviceGroupDO = this.pm.getServiceGroup(serviceGroupName);
        if (serviceGroupDO != null && (serviceDOs = this.pm.getServices(serviceGroupDO)) != null) {
            for (int i = 0; i < serviceDOs.length; ++i) {
                ServiceDO serviceDO = serviceDOs[i];
                ServiceParameterDO serviceParameterDO = serviceDO.getParameter(parameter.getName());
                if (serviceParameterDO != null) {
                    serviceParameterDO.setValue(parameter.getParameterElement().toString());
                    this.pm.updateEntity((AbstractDataObject)serviceParameterDO);
                } else {
                    serviceParameterDO = new ServiceParameterDO();
                    serviceParameterDO.setName(parameter.getName());
                    serviceParameterDO.setValue(parameter.getParameterElement().toString());
                    serviceParameterDO.setService(serviceDO);
                    try {
                        this.pm.addEntity((AbstractDataObject)serviceParameterDO);
                    }
                    catch (DuplicateEntityException e) {
                        log.error((Object)"Service Parameter already exists", (Throwable)e);
                    }
                }
                OperationDO[] operationDOs = this.pm.getOperations(serviceDO);
                if (operationDOs == null) continue;
                for (int j = 0; j < operationDOs.length; ++j) {
                    OperationDO operationDO = operationDOs[j];
                    OperationParameterDO[] operationParameterDOs = this.pm.getOperationParameters(operationDO);
                    OperationParameterDO operationParameterDO = null;
                    for (int k = 0; k < operationParameterDOs.length; ++k) {
                        if (!operationParameterDOs[k].getName().equals(parameter.getName())) continue;
                        operationParameterDO = operationParameterDOs[k];
                        break;
                    }
                    if (operationParameterDO != null) {
                        operationParameterDO.setValue(parameter.getParameterElement().toString());
                        this.pm.updateEntity((AbstractDataObject)operationParameterDO);
                        continue;
                    }
                    operationParameterDO = new OperationParameterDO();
                    operationParameterDO.setName(parameter.getName());
                    operationParameterDO.setValue(parameter.getParameterElement().toString());
                    operationParameterDO.setOperation(operationDO);
                    try {
                        this.pm.addEntity((AbstractDataObject)operationParameterDO);
                        continue;
                    }
                    catch (DuplicateEntityException e) {
                        log.error((Object)"Service Parameter already exists", (Throwable)e);
                    }
                }
            }
        }
        return this.listServiceGroup(serviceGroupName);
    }

    public ServiceGroupMetaData[] listServiceGroups() throws AxisFault {
        ArrayList<ServiceGroupMetaData> sgList = new ArrayList<ServiceGroupMetaData>();
        Iterator sgs = this.getAxisConfig().getServiceGroups();
        while (sgs.hasNext()) {
            Parameter parameter;
            boolean clientsideService = false;
            AxisServiceGroup axisServiceGroup = (AxisServiceGroup)sgs.next();
            String sgName = axisServiceGroup.getServiceGroupName();
            if (AdminFilter.isFilteredOutService((String)sgName)) continue;
            ServiceGroupMetaData sgMetaData = new ServiceGroupMetaData();
            sgMetaData.setServiceContextPath(this.getConfigContext().getServiceContextPath());
            ArrayList<String> services = new ArrayList<String>();
            ArrayList<String> serviceTypes = new ArrayList<String>();
            Iterator serviceIter = axisServiceGroup.getServices();
            while (serviceIter.hasNext()) {
                AxisService axisService = (AxisService)serviceIter.next();
                if (axisService.isClientSide()) {
                    clientsideService = true;
                }
                services.add(axisService.getName());
                Parameter serviceTypeParam = axisService.getParameter("serviceType");
                if (serviceTypeParam != null) {
                    serviceTypes.add(axisService.getName() + "#" + (String)serviceTypeParam.getValue());
                    continue;
                }
                serviceTypes.add(axisService.getName() + "#" + "other_service");
            }
            sgMetaData.setServices(services.toArray(new String[services.size()]));
            sgMetaData.setServiceTypes(serviceTypes.toArray(new String[serviceTypes.size()]));
            sgMetaData.setGroup_id(sgName);
            sgMetaData.setGroup_name(sgName);
            sgMetaData.setGroup_version("-");
            if (!clientsideService) {
                sgList.add(sgMetaData);
            }
            if ((parameter = axisServiceGroup.getParameter("enableMTOM")) != null) {
                sgMetaData.setEnableMTOM((String)parameter.getValue());
                continue;
            }
            sgMetaData.setEnableMTOM("false");
        }
        Collections.sort(sgList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ServiceGroupMetaData a = (ServiceGroupMetaData)arg0;
                ServiceGroupMetaData b = (ServiceGroupMetaData)arg1;
                return a.getGroup_name().compareToIgnoreCase(b.getGroup_name());
            }
        });
        return sgList.toArray(new ServiceGroupMetaData[sgList.size()]);
    }

    public void removeServiceGroup(String groupName) throws AxisFault {
        AxisServiceGroup asg = this.getAxisConfig().getServiceGroup(groupName);
        if (asg == null) {
            throw new AxisFault("Invalid service group name: " + groupName);
        }
        this.getAxisConfig().removeServiceGroup(groupName);
    }

    public OMElement[] getServiceGroupParameters(String service_group_id, String group_version) throws AxisFault {
        ArrayList<OMElement> allParameter = new ArrayList<OMElement>();
        ArrayList globalParameters = this.getAxisConfig().getParameters();
        for (int i = 0; i < globalParameters.size(); ++i) {
            Parameter parameter = (Parameter)globalParameters.get(i);
            allParameter.add(parameter.getParameterElement());
        }
        AxisServiceGroup asg = this.getAxisConfig().getServiceGroup(service_group_id);
        ArrayList sgParameters = asg.getParameters();
        for (int i = 0; i < sgParameters.size(); ++i) {
            Parameter parameter = (Parameter)sgParameters.get(i);
            allParameter.add(parameter.getParameterElement());
        }
        return allParameter.toArray(new OMElement[allParameter.size()]);
    }

    public OMElement[] getDeclaredServiceGroupParameters(String serviceGroupId) throws AxisFault {
        ArrayList<OMElement> allParameter = new ArrayList<OMElement>();
        AxisServiceGroup asg = this.getAxisConfig().getServiceGroup(serviceGroupId);
        ArrayList sgParameters = asg.getParameters();
        for (int i = 0; i < sgParameters.size(); ++i) {
            Parameter parameter = (Parameter)sgParameters.get(i);
            OMElement element = parameter.getParameterElement();
            if (element == null) continue;
            allParameter.add(element);
        }
        return allParameter.toArray(new OMElement[allParameter.size()]);
    }

    public void setServiceGroupParameters(String serviceGroupId, OMElement[] parameterElement) throws AxisFault {
        for (int i = 0; i < parameterElement.length; ++i) {
            this.setServiceGroupParameter(serviceGroupId, parameterElement[i]);
        }
    }

    public void setServiceGroupParameter(String serviceGroupId, OMElement parameterElement) throws AxisFault {
        AxisServiceGroup axisServiceGroup = this.getAxisConfig().getServiceGroup(serviceGroupId);
        Parameter parameter = ParameterUtil.createParameter((OMElement)parameterElement);
        Parameter p = axisServiceGroup.getParameter(parameter.getName());
        ServiceGroupDO serviceGroupDO = this.pm.getServiceGroup(serviceGroupId);
        ServiceGroupParameterDO sgParamDO = serviceGroupDO.getParameter(parameter.getName());
        if (p != null && sgParamDO != null) {
            if (!p.isLocked()) {
                axisServiceGroup.addParameter(parameter);
                sgParamDO.setValue(parameterElement.toString());
                this.pm.updateEntity((AbstractDataObject)sgParamDO);
            }
        } else if (p == null || !p.isLocked()) {
            axisServiceGroup.addParameter(parameter);
            sgParamDO = new ServiceGroupParameterDO();
            sgParamDO.setName(parameter.getName());
            sgParamDO.setValue(parameterElement.toString());
            sgParamDO.setServiceGroup(serviceGroupDO);
            try {
                this.pm.addEntity((AbstractDataObject)sgParamDO);
            }
            catch (DuplicateEntityException e) {
                log.error((Object)"Service Parameter already exists", (Throwable)e);
            }
        }
    }

    public void removeServiceGroupParameter(String serviceGroupId, OMElement parameterElement) throws AxisFault {
        AxisServiceGroup axisServiceGroup = this.getAxisConfig().getServiceGroup(serviceGroupId);
        Parameter parameter = ParameterUtil.createParameter((OMElement)parameterElement);
        Parameter p = axisServiceGroup.getParameter(parameter.getName());
        ServiceGroupDO serviceGroupDO = this.pm.getServiceGroup(serviceGroupId);
        ServiceGroupParameterDO sgParamDO = serviceGroupDO.getParameter(parameter.getName());
        if (p != null && sgParamDO != null) {
            if (!p.isLocked()) {
                axisServiceGroup.removeParameter(parameter);
                this.pm.deleteEntity((AbstractDataObject)sgParamDO);
            }
        } else if (p == null || !p.isLocked()) {
            axisServiceGroup.removeParameter(parameter);
        }
    }

    public boolean deleteServiceGroup(String serviceGroupName) throws AxisFault {
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        if (Utils.isURL((String)axis2Repo)) {
            throw new AxisFault("You are not permitted to remove the " + serviceGroupName + " service group from the URL repository " + axis2Repo);
        }
        AxisConfiguration axisConfig = this.getAxisConfig();
        AxisServiceGroup asGroup = axisConfig.getServiceGroup(serviceGroupName);
        if (asGroup == null) {
            throw new AxisFault("invalid service group name " + serviceGroupName);
        }
        String fileName = "";
        Parameter hotDeployment = axisConfig.getParameter("hotdeployment");
        boolean hotdeploymentEnabled = true;
        if (hotDeployment != null) {
            hotdeploymentEnabled = Boolean.valueOf((String)hotDeployment.getValue());
        }
        ArrayList<String> serviceToBeRemoved = new ArrayList<String>();
        Iterator serviceIter = asGroup.getServices();
        while (serviceIter.hasNext()) {
            File file;
            AxisService axisService = (AxisService)serviceIter.next();
            URL fn = axisService.getFileName();
            if (fn != null) {
                fileName = fn.getPath();
            }
            if (!(fileName == null || fileName.trim().length() == 0 || !(file = new File(fileName)).exists() || file.isDirectory() && new FileManipulator().deleteDir(file) || file.delete())) {
                throw new AxisFault("Service archive deletion failed. Due to a JVM issue on MS-Windows, AAR files cannot be deleted!");
            }
            if (hotdeploymentEnabled) continue;
            serviceToBeRemoved.add(axisService.getName());
        }
        if (!hotdeploymentEnabled) {
            Iterator iterator = serviceToBeRemoved.iterator();
            while (iterator.hasNext()) {
                axisConfig.removeService((String)iterator.next());
            }
            axisConfig.removeServiceGroup(asGroup.getServiceGroupName());
        }
        return true;
    }

    public OMElement getPolicy(String serviceGroupId, String serviceGroupVersion) throws AxisFault {
        AxisServiceGroup axisServiceGroup = this.getAxisConfig().getServiceGroup(serviceGroupId);
        if (axisServiceGroup == null) {
            throw new AxisFault("Invalid AxisServiceGroup: " + serviceGroupId);
        }
        PolicyInclude groupPolicyInclude = axisServiceGroup.getPolicyInclude();
        Policy groupPolicy = groupPolicyInclude.getPolicy();
        if (groupPolicy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement();
        }
        return PolicyUtil.getPolicyAsOMElement((Policy)groupPolicy);
    }

    public void setPolicy(String serviceGroupId, String serviceGroupVersion, OMElement policyElement) throws AxisFault {
        Policy groupPolicy;
        AxisServiceGroup axisServiceGroup = this.getAxisConfig().getServiceGroup(serviceGroupId);
        if (axisServiceGroup == null) {
            throw new AxisFault("Invalid AxisServiceGroup: " + serviceGroupId);
        }
        try {
            groupPolicy = PolicyUtil.getPolicyFromOMElement((OMElement)policyElement);
        }
        catch (RuntimeException ex) {
            throw new AxisFault("cannot convert the OMElement to Policy", (Throwable)ex);
        }
        PolicyInclude groupPolicyInclude = axisServiceGroup.getPolicyInclude();
        groupPolicyInclude.setPolicy(groupPolicy);
    }

    public String dumpAAR(String serviceGroupName) throws AxisFault {
        return ServiceArchiveCreator.createArchive(this.configCtx, serviceGroupName);
    }
}

