/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service.logging;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SyslogAppender;
import org.wso2.wsas.admin.service.util.AppenderData;
import org.wso2.wsas.admin.service.util.LogData;
import org.wso2.wsas.admin.service.util.LoggerData;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.AppenderDO;
import org.wso2.wsas.persistence.dataobject.LoggerDO;
import org.wso2.wsas.util.LoggingUtil;

public class LoggingAdmin {
    private static final Log log = LogFactory.getLog((Class)LoggingAdmin.class);
    private PersistenceManager pm = new PersistenceManager();

    public void updateSystemLog(String logLevel, String logPattern) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to update log data with ==> Log level " + logLevel + " log pattern " + logPattern));
        }
        HashSet appenderSet = new HashSet();
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(Level.toLevel((String)logLevel));
        this.pm.updateConfigurationProperty("system.log.level", logLevel);
        this.pm.updateConfigurationProperty("system.log.pattern", logPattern);
        this.addAppendersToSet(rootLogger.getAllAppenders(), appenderSet);
        Enumeration loggers = LogManager.getLoggerRepository().getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (logger.getLevel() == null) continue;
            this.addAppendersToSet(logger.getAllAppenders(), appenderSet);
            if (logLevel == null || logLevel.trim().length() == 0) continue;
            LoggerDO loggerDO = this.pm.getLoggerDO(logger.getName());
            logger.setLevel(Level.toLevel((String)logLevel));
            this.pm.updateLoggerData(loggerDO.getName(), logLevel, loggerDO.getAdditivity());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("set the logger ==> " + logger.getName() + " to " + logger.getLevel().toString()));
        }
        Iterator iter = appenderSet.iterator();
        while (iter.hasNext()) {
            Appender appender = (Appender)iter.next();
            AppenderDO appenderDO = this.pm.getAppenderDO(appender.getName());
            if (appender.getLayout() != null && appender.getLayout() instanceof PatternLayout) {
                if (logPattern != null && logPattern.trim().length() != 0) {
                    ((PatternLayout)appender.getLayout()).setConversionPattern(logPattern);
                    this.pm.updateAppenderData(appenderDO.getName(), logPattern, logLevel, appenderDO.getLogFileName(), appenderDO.getSysLogHost(), appenderDO.getFacility(), appenderDO.getIsFileAppender(), appenderDO.getIsSysLogAppender());
                }
                if (appender instanceof AppenderSkeleton) {
                    AppenderSkeleton appenderSkeleton = (AppenderSkeleton)appender;
                    appenderSkeleton.setThreshold((Priority)Level.toLevel((String)logLevel));
                    appenderSkeleton.activateOptions();
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("set details for appender ==> " + appenderDO.toString()));
        }
    }

    public AppenderData getAppenderData(String appenderName) {
        AppenderData appenderData = new AppenderData();
        AppenderDO appenderDO = this.pm.getAppenderDO(appenderName);
        appenderData.setName(appenderDO.getName());
        appenderData.setLogFile(appenderDO.getLogFileName());
        appenderData.setPattern(appenderDO.getPattern());
        appenderData.setIsFileAppender(appenderDO.getIsFileAppender());
        appenderData.setIsSysLogAppender(appenderDO.getIsSysLogAppender());
        appenderData.setFacility(appenderDO.getFacility());
        appenderData.setSysLogHost(appenderDO.getSysLogHost());
        appenderData.setThreshold(appenderDO.getThreshold());
        return appenderData;
    }

    public LoggerData getLoggerData(String loggerName) {
        LoggerData loggerData = new LoggerData();
        LoggerDO loggerDO = this.pm.getLoggerDO(loggerName);
        loggerData.setName(loggerDO.getName());
        loggerData.setLevel(loggerDO.getLogLevel());
        loggerData.setAditivity(loggerDO.getAdditivity());
        return loggerData;
    }

    public void updateAllAppenderData(String appenderName, String appenderPattern, String threshold, String logFileName, String sysLogHost, String facility) throws AxisFault {
        AppenderDO appenderDO = this.pm.getAppenderDO(appenderName);
        if (appenderDO.getIsFileAppender()) {
            File logFile = new File(logFileName = logFileName.replace('\\', '/'));
            if (!logFile.isAbsolute()) {
                if (logFileName.startsWith("./")) {
                    logFileName = logFileName.substring(2);
                }
                logFileName = (System.getProperty("wso2wsas.home") + "/" + logFileName).replace('\\', '/');
                logFile = new File(logFileName);
            }
            if (!logFile.exists()) {
                String dirName;
                File dir;
                int lastIndex = logFileName.lastIndexOf("/");
                String msg = "Cannot create logfile " + logFileName + ". Please verify that the log file name is valid " + "and that you have read-write access to this file.";
                if (lastIndex != -1 && !(dir = new File(dirName = logFileName.substring(0, lastIndex))).exists() && !dir.mkdirs()) {
                    throw new AxisFault(msg);
                }
                try {
                    if (!logFile.createNewFile()) {
                        throw new AxisFault(msg);
                    }
                }
                catch (IOException e) {
                    throw new AxisFault(msg);
                }
            }
            this.pm.updateAppenderData(appenderName, appenderPattern, threshold, logFileName, null, null, true, false);
        } else if (appenderDO.getIsSysLogAppender()) {
            this.pm.updateAppenderData(appenderName, appenderPattern, threshold, null, sysLogHost, facility, false, true);
        } else {
            this.pm.updateAppenderData(appenderName, appenderPattern, threshold, null, null, null, false, false);
        }
        HashSet appenderSet = new HashSet();
        Logger rootLogger = Logger.getRootLogger();
        this.addAppendersToSet(rootLogger.getAllAppenders(), appenderSet);
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (logger.getLevel() == null) continue;
            this.addAppendersToSet(logger.getAllAppenders(), appenderSet);
        }
        Appender appender = null;
        Iterator iter = appenderSet.iterator();
        while (iter.hasNext() && !(appender = (Appender)iter.next()).getName().equals(appenderName)) {
        }
        if (appender != null) {
            if (appender.getLayout() != null && appender.getLayout() instanceof PatternLayout) {
                ((PatternLayout)appender.getLayout()).setConversionPattern(appenderPattern);
            }
            if (appender instanceof FileAppender) {
                ((FileAppender)appender).setFile(logFileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("change the logfile of the appender ==> " + appender.getName() + " to " + logFileName));
                }
                ((FileAppender)appender).activateOptions();
            }
            if (appender instanceof SyslogAppender) {
                SyslogAppender syslogAppender = (SyslogAppender)appender;
                syslogAppender.setSyslogHost(sysLogHost);
                syslogAppender.setFacility(facility);
            }
            if (appender instanceof AppenderSkeleton) {
                AppenderSkeleton appenderSkeleton = (AppenderSkeleton)appender;
                appenderSkeleton.setThreshold((Priority)Level.toLevel((String)threshold));
                appenderSkeleton.activateOptions();
            }
        }
    }

    public void updateLoggerData(String loggerName, String loggerLevel, boolean additivity) {
        this.pm.updateLoggerData(loggerName, loggerLevel, additivity);
        Logger logger = LogManager.getLogger((String)loggerName);
        if (logger != null) {
            logger.setLevel(Level.toLevel((String)loggerLevel));
            logger.setAdditivity(additivity);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set the log level of logger ==>" + logger.getName() + " to " + logger.getLevel().toString()));
            }
        }
    }

    public LogData getSystemLog() throws AxisFault {
        LoggerData[] loggerData;
        LogData logData = new LogData();
        logData.setLogLevel(this.pm.getConfigurationProperty("system.log.level"));
        logData.setLogPattern(this.pm.getConfigurationProperty("system.log.pattern"));
        AppenderData[] appenderData = this.getAllAppenderData();
        if (appenderData.length > 0) {
            logData.setAppenderData(appenderData);
            logData.setSelectedAppenderData(appenderData[0]);
        }
        if ((loggerData = this.getAllLoggerData()).length > 0) {
            logData.setLoggerData(loggerData);
            logData.setSelectedLoggerData(loggerData[0]);
        }
        return logData;
    }

    public void restoreDefaults() {
        LoggingUtil.restoreDefaults();
    }

    private AppenderData[] getAllAppenderData() {
        List appenderDOs = this.pm.getAllAppenders();
        AppenderData[] appenderDataArray = new AppenderData[appenderDOs.size()];
        for (int i = 0; i < appenderDOs.size(); ++i) {
            AppenderDO appeanderDO = (AppenderDO)appenderDOs.get(i);
            appenderDataArray[i] = new AppenderData();
            appenderDataArray[i].setName(appeanderDO.getName());
            appenderDataArray[i].setPattern(appeanderDO.getPattern());
            appenderDataArray[i].setFacility(appeanderDO.getFacility());
            appenderDataArray[i].setLogFile(appeanderDO.getLogFileName());
            appenderDataArray[i].setIsFileAppender(appeanderDO.getIsFileAppender());
            appenderDataArray[i].setIsSysLogAppender(appeanderDO.getIsSysLogAppender());
            appenderDataArray[i].setSysLogHost(appeanderDO.getSysLogHost());
            appenderDataArray[i].setThreshold(appeanderDO.getThreshold());
        }
        return appenderDataArray;
    }

    private LoggerData[] getAllLoggerData() {
        List loggerDOs = this.pm.getAllLoggers();
        LoggerData[] loggerDatas = new LoggerData[loggerDOs.size()];
        for (int i = 0; i < loggerDOs.size(); ++i) {
            LoggerDO loggerDO = (LoggerDO)loggerDOs.get(i);
            loggerDatas[i] = new LoggerData(loggerDO.getName(), loggerDO.getLogLevel(), loggerDO.getAdditivity());
        }
        return loggerDatas;
    }

    private void addAppendersToSet(Enumeration appenders, Set appenderSet) {
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            appenderSet.add(appender);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Add appender ==> " + appender.getName() + " to appender set"));
        }
    }
}

