/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.classloader.MultiParentClassLoader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class GenericApplicationContextUtil {
    public static GenericApplicationContext getSpringApplicationContext(InputStream applicationContxtInStream, String springBeansFilePath) throws AxisFault {
        GenericApplicationContext appContext = new GenericApplicationContext();
        File urlFile = new File(springBeansFilePath);
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        try {
            URL url = urlFile.toURL();
            URLClassLoader urlCl = URLClassLoader.newInstance(new URL[]{url}, prevCl);
            Thread.currentThread().setContextClassLoader(urlCl);
            XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
            xbdr.setValidating(false);
            xbdr.loadBeanDefinitions((Resource)new InputStreamResource(applicationContxtInStream));
            appContext.refresh();
        }
        catch (MalformedURLException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl);
        }
        return appContext;
    }

    public static GenericApplicationContext getSpringApplicationContext(String applicationContxtFilePath, ClassLoader springBeansClassLoader) throws AxisFault {
        GenericApplicationContext appContext = new GenericApplicationContext();
        appContext.setClassLoader(springBeansClassLoader);
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)new MultiParentClassLoader(new URL[0], new ClassLoader[]{springBeansClassLoader, prevCl}));
            XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
            xbdr.setValidating(false);
            xbdr.loadBeanDefinitions((Resource)new InputStreamResource((InputStream)new FileInputStream(new File(applicationContxtFilePath))));
            appContext.refresh();
        }
        catch (FileNotFoundException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl);
        }
        return appContext;
    }

    public static GenericApplicationContext getSpringApplicationContext(String applicationContxtFilePath, String springBeansFilePath) throws AxisFault {
        try {
            return GenericApplicationContextUtil.getSpringApplicationContext(new FileInputStream(new File(applicationContxtFilePath)), springBeansFilePath);
        }
        catch (FileNotFoundException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

