/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.admin.service.util;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import org.wso2.utils.ServerConfiguration;

public class ServerData {
    private String javaRuntimeName;
    private String javaVMVersion;
    private String javaVMVendor;
    private String javaHome;
    private String javaVersion;
    private String osName;
    private String osVersion;
    private String userHome;
    private String userTimezone;
    private String userName;
    private String userCountry;
    private String axis2Location;
    private String serverName;
    private String repoLocation;
    private String wso2wsasVersion;

    public ServerData(String serverName, String repoLocation) {
        this.init();
        this.serverName = serverName;
        this.repoLocation = repoLocation;
    }

    public ServerData() {
        this.init();
    }

    private void init() {
        this.javaRuntimeName = System.getProperty("java.runtime.name");
        this.javaVMVersion = System.getProperty("java.vm.version");
        this.javaVMVendor = System.getProperty("java.vm.vendor");
        this.userCountry = System.getProperty("user.country");
        this.osName = System.getProperty("os.name");
        this.osVersion = System.getProperty("os.version");
        this.userHome = System.getProperty("user.home");
        this.userTimezone = System.getProperty("user.timezone");
        this.userName = System.getProperty("user.name");
        this.javaHome = System.getProperty("java.home");
        this.javaVersion = System.getProperty("java.version");
        this.wso2wsasVersion = ServerConfiguration.getInstance().getFirstProperty("Version");
        this.axis2Location = this.axis2Location();
    }

    private String axis2Location() {
        try {
            Class<?> clazz = Class.forName("org.apache.axis2.engine.AxisEngine");
            URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
            String location = url.toString();
            if (location.startsWith("jar")) {
                url = ((JarURLConnection)url.openConnection()).getJarFileURL();
                location = url.toString();
            }
            if (location.startsWith("file")) {
                File file = new File(url.getFile());
                return file.getAbsolutePath();
            }
            return url.toString();
        }
        catch (Throwable t) {
            return "an unknown location";
        }
    }

    public String getJavaRuntimeName() {
        return this.javaRuntimeName;
    }

    public void setJavaRuntimeName(String javaRuntimeName) {
        this.javaRuntimeName = javaRuntimeName;
    }

    public String getJavaVMVersion() {
        return this.javaVMVersion;
    }

    public void setJavaVMVersion(String javaVMVersion) {
        this.javaVMVersion = javaVMVersion;
    }

    public String getUserCountry() {
        return this.userCountry;
    }

    public void setUserCountry(String userCountry) {
        this.userCountry = userCountry;
    }

    public String getJavaVMVendor() {
        return this.javaVMVendor;
    }

    public void setJavaVMVendor(String javaVMVendor) {
        this.javaVMVendor = javaVMVendor;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public void setUserHome(String userHome) {
        this.userHome = userHome;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserTimezone() {
        return this.userTimezone;
    }

    public void setUserTimezone(String userTimezone) {
        this.userTimezone = userTimezone;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public String getAxis2Location() {
        return this.axis2Location;
    }

    public void setAxis2Location(String axis2Location) {
        this.axis2Location = axis2Location;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getRepoLocation() {
        return this.repoLocation;
    }

    public void setRepoLocation(String repoLocation) {
        this.repoLocation = repoLocation;
    }

    public String getWso2wsasVersion() {
        return this.wso2wsasVersion;
    }

    public void setWso2wsasVersion(String wso2wsasVersion) {
        this.wso2wsasVersion = wso2wsasVersion;
    }
}

