/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.sample.exchange;

import java.util.ArrayList;
import java.util.Map;
import org.wso2.wsas.sample.trader.ClientDetails;
import org.wso2.wsas.sample.utils.Utils;
import org.wso2.www.types.exchange.trader.service.ClientInfo;

public class Exchange {
    private static Exchange ourInstance = new Exchange();
    private String myEPR = "http://127.0.0.1:3501/services/ExchangeTrader";
    private ArrayList tradersToBeNotified = new ArrayList();
    private Map registeredClients;
    private int totalTraded = 0;

    private Exchange() {
        Utils.getPrePopulatedStockMarket("TraderExchange");
        this.registeredClients = Utils.getPrePopulatedClientList();
    }

    public static Exchange getInstance() {
        return ourInstance;
    }

    public void registerTrader(String epr) {
        this.tradersToBeNotified.add(epr);
    }

    public String registerClient(ClientInfo info) {
        ClientDetails clntDetails = new ClientDetails(info.getSsn(), info.getName());
        this.registeredClients.put(info.getName(), clntDetails);
        return info.getName();
    }

    public int getTotalTraded() {
        return this.totalTraded;
    }

    public void buy(String userId, String symbol, int quantity) {
        this.totalTraded += quantity;
    }

    public void sell(String userId, String symbol, int quantity) {
        this.totalTraded += quantity;
    }

    public String getMyEPR() {
        return this.myEPR;
    }

    public void setMyEPR(String myEPR) {
        this.myEPR = myEPR;
    }
}

