/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.sample.trader.client;

import org.wso2.wsas.sample.trader.client.TraderClientCallbackHandler;
import org.wso2.www.types.trader.client.ArrayOfString;
import org.wso2.www.types.trader.client.BuyResponse;
import org.wso2.www.types.trader.client.CreateAccountResponse;
import org.wso2.www.types.trader.client.DepositResponse;
import org.wso2.www.types.trader.client.GetPortfolioResponse;
import org.wso2.www.types.trader.client.GetQuoteResponse;
import org.wso2.www.types.trader.client.GetSymbolsResponse;
import org.wso2.www.types.trader.client.PortFolio;
import org.wso2.www.types.trader.client.PortFolioItem;
import org.wso2.www.types.trader.client.SellResponse;
import org.wso2.www.types.trader.client.StockQuote;
import org.wso2.www.types.trader.client.TradeStatus;

public class TraderClientCallbackHandlerExt
extends TraderClientCallbackHandler {
    boolean complete;

    public TraderClientCallbackHandlerExt(Object clientData) {
        super(clientData);
    }

    public boolean isComplete() {
        return this.complete;
    }

    private void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void receiveErrorbuy(Exception e) {
        System.out.println(e.getMessage());
        this.setComplete(true);
    }

    public void receiveErrorcreateAccount(Exception e) {
        System.out.println(e.getMessage());
        this.setComplete(true);
    }

    public void receiveErrordeposit(Exception e) {
        System.out.println(e.getStackTrace());
        this.setComplete(true);
    }

    public void receiveErrorgetPortfolio(Exception e) {
        System.out.println(e.getMessage());
        this.setComplete(true);
    }

    public void receiveErrorgetQuote(Exception e) {
        System.out.println(e.getMessage());
        this.setComplete(true);
    }

    public void receiveErrorgetSymbols(Exception e) {
        System.out.println(e.getMessage());
        this.setComplete(true);
    }

    public void receiveErrorsell(Exception e) {
        System.out.println(e.getStackTrace());
        this.setComplete(true);
    }

    public void receiveResultbuy(BuyResponse param73) {
        TradeStatus tradeStatus = param73.getTrade_status();
        System.out.println("Status :" + tradeStatus.getStatus());
        System.out.println("Reason :" + tradeStatus.getReason());
        this.setComplete(true);
    }

    public void receiveResultcreateAccount(CreateAccountResponse param81) {
        System.out.println("\nResults");
        System.out.println("-------");
        System.out.println("User ID       :" + param81.getUserid());
        this.setComplete(true);
    }

    public void receiveResultdeposit(DepositResponse param77) {
        System.out.println("Done");
        this.setComplete(true);
    }

    public void receiveResultgetPortfolio(GetPortfolioResponse param75) {
        System.out.println("\nResults");
        System.out.println("-------");
        PortFolio portFolio = param75.getPortFolio();
        PortFolioItem[] portFolioItems = portFolio.getPortFolioItem();
        if (portFolioItems != null) {
            int length = portFolioItems.length;
            if (length == 1 && portFolioItems[0].getSymbol().equalsIgnoreCase("Invalid")) {
                System.out.println("Username and/or password invalid!");
            } else if (length == 1 && portFolioItems[0].getSymbol().equalsIgnoreCase("Empty")) {
                System.out.println("No portfolio items are available");
            } else {
                for (int i = 0; i < length; ++i) {
                    PortFolioItem portFolioItem = portFolioItems[i];
                    System.out.println("Symbol:" + portFolioItem.getSymbol() + "     Amount:" + portFolioItem.getAmount());
                }
            }
        } else {
            System.out.println("No portfolio items are available");
        }
        this.setComplete(true);
    }

    public void receiveResultgetQuote(GetQuoteResponse param79) {
        StockQuote stockQuote = param79.getStock_quote();
        System.out.println("\nResults");
        System.out.println("-------");
        System.out.println("Name       :" + stockQuote.getName());
        System.out.println("Symbol     :" + stockQuote.getSymbol());
        System.out.println("High value :" + stockQuote.getHigh());
        System.out.println("Low value  :" + stockQuote.getLow());
        System.out.println("Price      :" + stockQuote.getPrice());
        this.setComplete(true);
    }

    public void receiveResultgetSymbols(GetSymbolsResponse param83) {
        System.out.println("\nResults");
        System.out.println("-------");
        ArrayOfString arr = param83.get_return();
        String[] symbols = arr.getValue();
        if (symbols != null) {
            System.out.println("\n");
            int count = 1;
            int length = symbols.length;
            for (int i = 0; i < length; ++i) {
                System.out.print(symbols[i] + "    ");
                if (++count != 10) continue;
                count = 1;
                System.out.println("\n");
            }
        } else {
            System.out.println("No symbols available");
        }
        this.setComplete(true);
    }

    public void receiveResultsell(SellResponse param71) {
        System.out.println("\nResults");
        System.out.println("-------");
        TradeStatus tradeStatus = param71.getTrade_status();
        System.out.println("Status :" + tradeStatus.getStatus());
        System.out.println("Reason :" + tradeStatus.getReason());
        this.setComplete(true);
    }
}

