/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.sample.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.wso2.wsas.sample.trader.ClientDetails;
import org.wso2.wsas.sample.trader.SymbolTable;
import org.wso2.www.types.trader.exchange.service.StockQuote;

public class Utils {
    public static final String TRADER_EXCHANGE = "TraderExchange";
    public static final String TRADER_CLIENT = "TraderClient";

    public static Map getPrePopulatedStockMarket(String interactionType) {
        Object stockQuote;
        Map symbolTable = SymbolTable.getInstance().populateSymbolTable();
        System.out.print("Populating the stock market ................");
        Iterator iterator = symbolTable.keySet().iterator();
        Random random = new Random();
        while (iterator.hasNext()) {
            Object stockQuote2;
            String symbolName = (String)iterator.next();
            if (TRADER_EXCHANGE.equals(interactionType)) {
                stockQuote2 = new StockQuote();
                ((StockQuote)stockQuote2).setName(symbolName);
                ((StockQuote)stockQuote2).setSymbol((String)symbolTable.get(symbolName));
                ((StockQuote)stockQuote2).setPrice(Math.round(random.nextFloat() * 100.0f));
                symbolTable.put(symbolName, stockQuote2);
                continue;
            }
            if (!TRADER_CLIENT.equals(interactionType)) continue;
            stockQuote2 = new org.wso2.www.types.trader.client.service.StockQuote();
            ((org.wso2.www.types.trader.client.service.StockQuote)stockQuote2).setName(symbolName);
            ((org.wso2.www.types.trader.client.service.StockQuote)stockQuote2).setSymbol((String)symbolTable.get(symbolName));
            ((org.wso2.www.types.trader.client.service.StockQuote)stockQuote2).setPrice(Math.round(random.nextFloat() * 100.0f));
            symbolTable.put(symbolName, stockQuote2);
        }
        if (TRADER_EXCHANGE.equals(interactionType)) {
            stockQuote = new StockQuote();
            ((StockQuote)stockQuote).setName("w");
            ((StockQuote)stockQuote).setSymbol("Tungsten");
            ((StockQuote)stockQuote).setPrice(101.22f);
            symbolTable.put("w", stockQuote);
        } else if (TRADER_CLIENT.equals(interactionType)) {
            stockQuote = new org.wso2.www.types.trader.client.service.StockQuote();
            ((org.wso2.www.types.trader.client.service.StockQuote)stockQuote).setName("w");
            ((org.wso2.www.types.trader.client.service.StockQuote)stockQuote).setSymbol("Tungsten");
            ((org.wso2.www.types.trader.client.service.StockQuote)stockQuote).setPrice(101.22f);
            symbolTable.put("w", stockQuote);
        }
        System.out.println("Done.");
        return symbolTable;
    }

    public static Map getPrePopulatedClientList() {
        HashMap<String, ClientDetails> clients = new HashMap<String, ClientDetails>();
        clients.put("Sanjiva", new ClientDetails("123451", "Sanjiva"));
        clients.put("Dims", new ClientDetails("123452", "Dims"));
        clients.put("Paul", new ClientDetails("123453", "Paul"));
        clients.put("Jivaka", new ClientDetails("123454", "Jivaka"));
        clients.put("Ajith", new ClientDetails("123455", "Ajith"));
        clients.put("Chinthaka", new ClientDetails("123456", "Chinthaka"));
        clients.put("Ruchith", new ClientDetails("123457", "Ruchith"));
        clients.put("Deepal", new ClientDetails("123458", "Deepal"));
        clients.put("Saminda", new ClientDetails("123459", "Saminda"));
        clients.put("Azeez", new ClientDetails("123460", "Azeez"));
        clients.put("Chamil", new ClientDetails("123461", "Chamil"));
        clients.put("Chamikara", new ClientDetails("123462", "Chamikara"));
        clients.put("Sanka", new ClientDetails("123463", "Sanka"));
        clients.put("Chatra", new ClientDetails("123464", "Chatra"));
        clients.put("Samisa", new ClientDetails("123465", "Samisa"));
        clients.put("Sahan", new ClientDetails("123466", "Sahan"));
        clients.put("Amila", new ClientDetails("123467", "Amila"));
        return clients;
    }
}

